/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.util.Random;
import mondrian.olap.MondrianDef;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.agg.AggregationKey;
import mondrian.spi.DataSourceChangeListener;

public class DataSourceChangeListenerImpl4
implements DataSourceChangeListener {
    private int flushInverseFrequencyHierarchy;
    private int flushInverseFrequencyAggregation;
    final Random random = new Random(123456L);

    public DataSourceChangeListenerImpl4() {
        this(0, 0);
    }

    public DataSourceChangeListenerImpl4(int flushInverseFrequencyHierarchy, int flushInverseFrequencyAggregation) {
        this.flushInverseFrequencyHierarchy = flushInverseFrequencyHierarchy;
        this.flushInverseFrequencyAggregation = flushInverseFrequencyAggregation;
    }

    @Override
    public synchronized boolean isHierarchyChanged(RolapHierarchy hierarchy) {
        if (this.flushInverseFrequencyHierarchy != 0) {
            return this.random.nextInt(this.flushInverseFrequencyHierarchy) == 0;
        }
        return true;
    }

    @Override
    public synchronized boolean isAggregationChanged(AggregationKey aggregation) {
        if (this.flushInverseFrequencyAggregation != 0) {
            return this.random.nextInt(this.flushInverseFrequencyAggregation) == 0;
        }
        return true;
    }

    public String getTableName(RolapHierarchy hierarchy) {
        MondrianDef.RelationOrJoin relation = hierarchy.getRelation();
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table tableRelation = (MondrianDef.Table)relation;
            return tableRelation.name;
        }
        return null;
    }
}

