/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnMetaData {
    public final int ordinal;
    public final boolean autoIncrement;
    public final boolean caseSensitive;
    public final boolean searchable;
    public final boolean currency;
    public final int nullable;
    public final boolean signed;
    public final int displaySize;
    public final String label;
    public final String columnName;
    public final String schemaName;
    public final int precision;
    public final int scale;
    public final String tableName;
    public final String catalogName;
    public final boolean readOnly;
    public final boolean writable;
    public final boolean definitelyWritable;
    public final String columnClassName;
    public final AvaticaType type;

    @JsonCreator
    public ColumnMetaData(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="autoIncrement") boolean autoIncrement, @JsonProperty(value="caseSensitive") boolean caseSensitive, @JsonProperty(value="searchable") boolean searchable, @JsonProperty(value="currency") boolean currency, @JsonProperty(value="nullable") int nullable, @JsonProperty(value="signed") boolean signed, @JsonProperty(value="displaySize") int displaySize, @JsonProperty(value="label") String label, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="type") AvaticaType type, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="definitelyWritable") boolean definitelyWritable, @JsonProperty(value="columnClassName") String columnClassName) {
        this.ordinal = ordinal;
        this.autoIncrement = autoIncrement;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.currency = currency;
        this.nullable = nullable;
        this.signed = signed;
        this.displaySize = displaySize;
        this.label = label;
        this.columnName = ColumnMetaData.first(columnName, label);
        this.schemaName = schemaName;
        this.precision = precision;
        this.scale = scale;
        this.tableName = tableName;
        this.catalogName = catalogName;
        this.type = type;
        this.readOnly = readOnly;
        this.writable = writable;
        this.definitelyWritable = definitelyWritable;
        this.columnClassName = columnClassName;
    }

    private static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static ScalarType scalar(int type, String typeName, Rep rep) {
        return new ScalarType(type, typeName, rep);
    }

    public static StructType struct(List<ColumnMetaData> columns) {
        return new StructType(columns);
    }

    public static ArrayType array(AvaticaType componentType, String typeName, Rep rep) {
        return new ArrayType(2003, typeName, rep, componentType);
    }

    public static ColumnMetaData dummy(AvaticaType type, boolean nullable) {
        return new ColumnMetaData(0, false, true, false, false, nullable ? 1 : 0, true, -1, null, null, null, -1, -1, null, null, type, true, false, false, type.columnClassName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SqlType {
        BOOLEAN(16, Boolean.class),
        TINYINT(-6, Byte.class),
        SMALLINT(5, Short.class),
        INTEGER(4, Integer.class),
        BIGINT(-5, Long.class),
        DECIMAL(3, BigDecimal.class),
        FLOAT(6, Float.class),
        REAL(7, Float.class),
        DOUBLE(8, Double.class),
        DATE(91, Date.class),
        TIME(92, Time.class),
        TIMESTAMP(93, Timestamp.class),
        INTERVAL_YEAR_MONTH(1111, Boolean.class),
        INTERVAL_DAY_TIME(1111, Boolean.class),
        CHAR(1, String.class),
        VARCHAR(12, String.class),
        BINARY(-2, byte[].class),
        VARBINARY(-3, byte[].class),
        NULL(0, Void.class),
        ANY(2000, Object.class),
        SYMBOL(1111, Object.class),
        MULTISET(2003, List.class),
        ARRAY(2003, Array.class),
        MAP(1111, Map.class),
        DISTINCT(2001, Object.class),
        STRUCTURED(2002, Object.class),
        ROW(2002, Object.class),
        OTHER(1111, Object.class),
        CURSOR(2012, Object.class),
        COLUMN_LIST(1113, Object.class);

        private final int type;
        private final Class clazz;
        private static final Map<Integer, SqlType> BY_ID;

        private SqlType(int type, Class clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public static SqlType valueOf(int type) {
            return BY_ID.get(type);
        }

        static {
            BY_ID = new HashMap<Integer, SqlType>();
            for (SqlType sqlType : SqlType.values()) {
                BY_ID.put(sqlType.type, sqlType);
            }
        }
    }

    public static class ArrayType
    extends AvaticaType {
        public final AvaticaType component;

        private ArrayType(int type, String typeName, Rep representation, AvaticaType component) {
            super(type, typeName, representation);
            this.component = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructType
    extends AvaticaType {
        public final List<ColumnMetaData> columns;

        @JsonCreator
        public StructType(List<ColumnMetaData> columns) {
            super(2002, "STRUCT", Rep.OBJECT);
            this.columns = columns;
        }
    }

    public static class ScalarType
    extends AvaticaType {
        @JsonCreator
        public ScalarType(@JsonProperty(value="type") int type, @JsonProperty(value="typeName") String typeName, @JsonProperty(value="representation") Rep representation) {
            super(type, typeName, representation);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ScalarType.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ScalarType.class, name="scalar"), @JsonSubTypes.Type(value=StructType.class, name="struct"), @JsonSubTypes.Type(value=ArrayType.class, name="array")})
    public static class AvaticaType {
        public final int type;
        public final String typeName;
        public final Rep representation;

        protected AvaticaType(int type, String typeName, Rep representation) {
            this.type = type;
            this.typeName = typeName;
            this.representation = representation;
            assert (representation != null);
        }

        public String columnClassName() {
            return SqlType.valueOf(this.type).clazz.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rep {
        PRIMITIVE_BOOLEAN(Boolean.TYPE),
        PRIMITIVE_BYTE(Byte.TYPE),
        PRIMITIVE_CHAR(Character.TYPE),
        PRIMITIVE_SHORT(Short.TYPE),
        PRIMITIVE_INT(Integer.TYPE),
        PRIMITIVE_LONG(Long.TYPE),
        PRIMITIVE_FLOAT(Float.TYPE),
        PRIMITIVE_DOUBLE(Double.TYPE),
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        CHARACTER(Character.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        JAVA_SQL_TIME(Time.class),
        JAVA_SQL_TIMESTAMP(Timestamp.class),
        JAVA_SQL_DATE(Date.class),
        JAVA_UTIL_DATE(java.util.Date.class),
        STRING(String.class),
        OBJECT(Object.class);

        public final Class clazz;
        public static final Map<Class, Rep> VALUE_MAP;

        private Rep(Class clazz) {
            this.clazz = clazz;
        }

        public static Rep of(Type clazz) {
            Rep rep = VALUE_MAP.get(clazz);
            return rep != null ? rep : OBJECT;
        }

        static {
            HashMap<Class, Rep> builder = new HashMap<Class, Rep>();
            for (Rep rep : Rep.values()) {
                builder.put(rep.clazz, rep);
            }
            VALUE_MAP = Collections.unmodifiableMap(builder);
        }
    }
}

