/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.Meta;

public interface Service {
    public ResultSetResponse apply(CatalogsRequest var1);

    public ResultSetResponse apply(SchemasRequest var1);

    public PrepareResponse apply(PrepareRequest var1);

    public ResultSetResponse apply(PrepareAndExecuteRequest var1);

    public CreateStatementResponse apply(CreateStatementRequest var1);

    public static class CreateStatementResponse
    extends Response {
        public final int id;

        @JsonCreator
        public CreateStatementResponse(@JsonProperty(value="id") int id) {
            this.id = id;
        }
    }

    public static class CreateStatementRequest
    extends Request {
        public final int connectionId;

        @JsonCreator
        public CreateStatementRequest(@JsonProperty(value="signature") int connectionId) {
            this.connectionId = connectionId;
        }

        CreateStatementResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class PrepareResponse
    extends Response {
        public final Meta.Signature signature;

        @JsonCreator
        public PrepareResponse(@JsonProperty(value="signature") Meta.Signature signature) {
            this.signature = signature;
        }
    }

    public static class PrepareRequest
    extends Request {
        public final int statementId;
        public final String sql;
        public final int maxRowCount;

        @JsonCreator
        public PrepareRequest(@JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") int maxRowCount) {
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        PrepareResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class PrepareAndExecuteRequest
    extends Request {
        public final int statementId;
        public final String sql;
        public final int maxRowCount;

        @JsonCreator
        public PrepareAndExecuteRequest(@JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") int maxRowCount) {
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResultSetResponse
    extends Response {
        public final int statementId;
        public final boolean ownStatement;
        public final Meta.Signature signature;
        public final List<Object> rows;

        @JsonCreator
        public ResultSetResponse(@JsonProperty(value="statementId") int statementId, @JsonProperty(value="ownStatement") boolean ownStatement, @JsonProperty(value="signature") Meta.Signature signature, @JsonProperty(value="rows") List<Object> rows) {
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.signature = signature;
            this.rows = rows;
        }
    }

    public static class SchemasRequest
    extends Request {
        public final String catalog;
        public final String schemaPattern;

        @JsonCreator
        public SchemasRequest(@JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern) {
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
        }

        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class CatalogsRequest
    extends Request {
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response", defaultImpl=ResultSetResponse.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ResultSetResponse.class, name="resultSet"), @JsonSubTypes.Type(value=PrepareResponse.class, name="prepare"), @JsonSubTypes.Type(value=CreateStatementResponse.class, name="createStatement")})
    public static abstract class Response {
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="request", defaultImpl=SchemasRequest.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogsRequest.class, name="getCatalogs"), @JsonSubTypes.Type(value=SchemasRequest.class, name="getSchemas"), @JsonSubTypes.Type(value=PrepareRequest.class, name="prepare"), @JsonSubTypes.Type(value=PrepareAndExecuteRequest.class, name="prepareAndExecute"), @JsonSubTypes.Type(value=CreateStatementRequest.class, name="createStatement")})
    public static abstract class Request {
        abstract Response accept(Service var1);
    }

    public static interface Factory {
        public Service create(AvaticaConnection var1);
    }
}

