/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.ClassUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.AbstractRepository;
import org.pentaho.di.repository.ReconnectableRepository;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.repo.RepositorySessionTimeoutHandler;
import org.pentaho.di.ui.spoon.Spoon;

public class RepositoryConnectController {
    public static final String DEFAULT_URL = "defaultUrl";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String SUCCESS = "success";
    public static final String ERROR_401 = "401";
    private static Class<?> PKG = RepositoryConnectController.class;
    private static LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryConnectController.class);
    private RepositoryMeta currentRepository;
    private RepositoryMeta connectedRepository;
    private RepositoriesMeta repositoriesMeta;
    private PluginRegistry pluginRegistry;
    private Spoon spoon;
    private List<RepositoryContollerListener> listeners = new ArrayList<RepositoryContollerListener>();

    public RepositoryConnectController(PluginRegistry pluginRegistry, Spoon spoon, RepositoriesMeta repositoriesMeta) {
        this.pluginRegistry = pluginRegistry;
        this.spoon = spoon;
        this.repositoriesMeta = repositoriesMeta;
        try {
            repositoriesMeta.readData();
        }
        catch (KettleException ke) {
            log.logError("Unable to load repositories", (Throwable)ke);
        }
    }

    public RepositoryConnectController() {
        this(PluginRegistry.getInstance(), Spoon.getInstance(), new RepositoriesMeta());
    }

    public String getPlugins() {
        List plugins = this.pluginRegistry.getPlugins(RepositoryPluginType.class);
        JSONArray list = new JSONArray();
        for (PluginInterface pluginInterface : plugins) {
            if (pluginInterface.getIds()[0].equals("PentahoEnterpriseRepository")) continue;
            JSONObject repoJSON = new JSONObject();
            repoJSON.put((Object)"id", (Object)pluginInterface.getIds()[0]);
            repoJSON.put((Object)"name", (Object)pluginInterface.getName());
            repoJSON.put((Object)"description", (Object)pluginInterface.getDescription());
            list.add((Object)repoJSON);
        }
        return list.toString();
    }

    public boolean createRepository(String id, Map<String, Object> items) {
        try {
            RepositoryMeta repositoryMeta = (RepositoryMeta)this.pluginRegistry.loadClass(RepositoryPluginType.class, id, RepositoryMeta.class);
            repositoryMeta.populate(items, this.repositoriesMeta);
            if (repositoryMeta.getName() != null) {
                Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
                repository.init(repositoryMeta);
                if (this.currentRepository != null) {
                    if (this.isCompatibleRepositoryEdit(repositoryMeta)) {
                        this.setConnectedRepository(repositoryMeta);
                    }
                    this.repositoriesMeta.removeRepository(this.repositoriesMeta.indexOfRepository(this.currentRepository));
                }
                this.repositoriesMeta.addRepository(repositoryMeta);
                this.repositoriesMeta.writeData();
                this.currentRepository = repositoryMeta;
                if (!((AbstractRepository)repository).test()) {
                    return false;
                }
                ((AbstractRepository)repository).create();
            }
        }
        catch (KettleException ke) {
            log.logError("Unable to load repository type", (Throwable)ke);
            return false;
        }
        return true;
    }

    private boolean isCompatibleRepositoryEdit(RepositoryMeta repositoryMeta) {
        if (this.repositoriesMeta.indexOfRepository(this.currentRepository) >= 0 && this.connectedRepository != null && this.repositoryEquals(this.connectedRepository, this.currentRepository)) {
            RepositoryMeta clone = repositoryMeta.clone();
            clone.setName(this.connectedRepository.getName());
            clone.setDescription(this.connectedRepository.getDescription());
            clone.setDefault(this.connectedRepository.isDefault());
            return this.repositoryEquals(this.connectedRepository, clone);
        }
        return false;
    }

    private boolean repositoryEquals(RepositoryMeta repo1, RepositoryMeta repo2) {
        return repo1.toJSONObject().equals((Object)repo2.toJSONObject());
    }

    public String getRepositories() {
        JSONArray list = new JSONArray();
        if (this.repositoriesMeta != null) {
            for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
                list.add((Object)this.repositoriesMeta.getRepository(i).toJSONObject());
            }
        }
        return list.toString();
    }

    public String getRepository(String name) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(name);
        if (repositoryMeta != null) {
            this.currentRepository = repositoryMeta;
            return repositoryMeta.toJSONObject().toString();
        }
        return "";
    }

    public DatabaseMeta getDatabase(String name) {
        return this.repositoriesMeta.searchDatabase(name);
    }

    public void removeDatabase(String name) {
        int index = this.repositoriesMeta.indexOfDatabase(this.repositoriesMeta.searchDatabase(name));
        if (index != -1) {
            this.repositoriesMeta.removeDatabase(index);
        }
        this.save();
    }

    public String getDatabases() {
        JSONArray list = new JSONArray();
        for (int i = 0; i < this.repositoriesMeta.nrDatabases(); ++i) {
            JSONObject databaseJSON = new JSONObject();
            databaseJSON.put((Object)"name", (Object)this.repositoriesMeta.getDatabase(i).getName());
            list.add((Object)databaseJSON);
        }
        return list.toString();
    }

    public String connectToRepository() {
        return this.connectToRepository(this.currentRepository);
    }

    public String connectToRepository(String username, String password) {
        return this.connectToRepository(this.currentRepository, username, password);
    }

    public String connectToRepository(RepositoryMeta repositoryMeta) {
        return this.connectToRepository(repositoryMeta, null, null);
    }

    public String connectToRepository(RepositoryMeta repositoryMeta, String username, String password) {
        JSONObject jsonObject = new JSONObject();
        try {
            Spoon spoon;
            Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            if (repository instanceof ReconnectableRepository) {
                repository = this.wrapWithRepositoryTimeoutHandler((ReconnectableRepository)repository);
            }
            repository.init(repositoryMeta);
            repository.connect(username, password);
            if (username != null) {
                this.getPropsUI().setLastRepositoryLogin(username);
            }
            if ((spoon = this.getSpoon()).getRepository() != null) {
                spoon.closeRepository();
            } else {
                spoon.closeAllJobsAndTransformations(true);
            }
            spoon.setRepository(repository);
            this.setConnectedRepository(repositoryMeta);
            this.fireListeners();
            jsonObject.put((Object)SUCCESS, (Object)true);
        }
        catch (KettleException ke) {
            if (ke.getMessage().contains(ERROR_401)) {
                jsonObject.put((Object)ERROR_MESSAGE, (Object)BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidCredentials", (String[])new String[0]));
            } else {
                jsonObject.put((Object)ERROR_MESSAGE, (Object)BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]));
            }
            jsonObject.put((Object)SUCCESS, (Object)false);
            log.logError("Unable to connect to repository", (Throwable)ke);
        }
        return jsonObject.toString();
    }

    public String reconnectToRepository(String username, String password) {
        Repository currentRepositoryInstance = this.getConnectedRepositoryInstance();
        return this.reconnectToRepository(this.currentRepository, (ReconnectableRepository)currentRepositoryInstance, username, password);
    }

    public String reconnectToRepository(RepositoryMeta repositoryMeta, ReconnectableRepository repository, String username, String password) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (username != null) {
                this.getPropsUI().setLastRepositoryLogin(username);
            }
            if (repository.isConnected()) {
                repository.disconnect();
            }
            repository.init(repositoryMeta);
            repository.connect(username, password);
            jsonObject.put((Object)SUCCESS, (Object)true);
        }
        catch (KettleException ke) {
            if (ke.getMessage().contains(ERROR_401)) {
                jsonObject.put((Object)ERROR_MESSAGE, (Object)BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidCredentials", (String[])new String[0]));
            } else {
                jsonObject.put((Object)ERROR_MESSAGE, (Object)BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]));
            }
            jsonObject.put((Object)SUCCESS, (Object)false);
            log.logError("Unable to connect to repository", (Throwable)ke);
        }
        return jsonObject.toString();
    }

    public boolean deleteRepository(String name) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(name);
        int index = this.repositoriesMeta.indexOfRepository(repositoryMeta);
        if (index != -1) {
            if (this.getSpoon().getRepositoryName() != null && this.getSpoon().getRepositoryName().equals(repositoryMeta.getName())) {
                this.getSpoon().closeRepository();
                this.setConnectedRepository(null);
            }
            this.repositoriesMeta.removeRepository(index);
            this.save();
        }
        return true;
    }

    public void addDatabase(DatabaseMeta databaseMeta) {
        if (databaseMeta != null) {
            this.repositoriesMeta.addDatabase(databaseMeta);
            this.save();
        }
    }

    public boolean setDefaultRepository(String name) {
        RepositoryMeta repositoryMeta = this.repositoriesMeta.findRepository(name);
        for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
            this.repositoriesMeta.getRepository(i).setDefault(Boolean.valueOf(false));
        }
        if (repositoryMeta != null) {
            repositoryMeta.setDefault(Boolean.valueOf(true));
        }
        try {
            this.repositoriesMeta.writeData();
        }
        catch (KettleException ke) {
            log.logError("Unable to set default repository", (Throwable)ke);
        }
        return true;
    }

    public String getDefaultUrl() {
        ResourceBundle resourceBundle = PropertyResourceBundle.getBundle(PKG.getPackage().getName() + ".plugin");
        return resourceBundle.getString(DEFAULT_URL);
    }

    public String getCurrentUser() {
        return this.getPropsUI().getLastRepositoryLogin();
    }

    public void setCurrentRepository(RepositoryMeta repositoryMeta) {
        this.currentRepository = repositoryMeta;
    }

    public RepositoryMeta getCurrentRepository() {
        return this.currentRepository;
    }

    public RepositoryMeta getConnectedRepository() {
        return this.connectedRepository;
    }

    public void setConnectedRepository(RepositoryMeta connectedRepository) {
        this.connectedRepository = connectedRepository;
    }

    public RepositoryMeta getDefaultRepositoryMeta() {
        for (int i = 0; i < this.repositoriesMeta.nrRepositories(); ++i) {
            RepositoryMeta repositoryMeta = this.repositoriesMeta.getRepository(i);
            if (!repositoryMeta.isDefault().booleanValue()) continue;
            return repositoryMeta;
        }
        return null;
    }

    public Repository getRepository(RepositoryMeta repositoryMeta) {
        try {
            Repository repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            return repository;
        }
        catch (KettlePluginException kpe) {
            log.logDebug("Unabled to load repository", new Object[]{kpe});
            return null;
        }
    }

    public RepositoryMeta getRepositoryMetaByName(String name) {
        return this.repositoriesMeta.findRepository(name);
    }

    public boolean isConnected(String name) {
        if (this.getSpoon().rep != null) {
            return this.getSpoon().rep.getName().equals(name);
        }
        return false;
    }

    public boolean isConnected() {
        return this.getSpoon().rep != null;
    }

    public Repository getConnectedRepositoryInstance() {
        return this.getSpoon().rep;
    }

    public void save() {
        try {
            this.repositoriesMeta.writeData();
        }
        catch (KettleException ke) {
            log.logError("Unable to write to repositories", (Throwable)ke);
        }
    }

    private Spoon getSpoon() {
        if (this.spoon == null) {
            this.spoon = Spoon.getInstance();
        }
        return this.spoon;
    }

    private Repository wrapWithRepositoryTimeoutHandler(ReconnectableRepository repository) {
        List repositoryIntrerfaces = ClassUtils.getAllInterfaces(repository.getClass());
        Class[] repositoryIntrerfacesArray = repositoryIntrerfaces.toArray(new Class[repositoryIntrerfaces.size()]);
        return (Repository)Proxy.newProxyInstance(repository.getClass().getClassLoader(), repositoryIntrerfacesArray, (InvocationHandler)new RepositorySessionTimeoutHandler(repository, this));
    }

    public PropsUI getPropsUI() {
        return PropsUI.getInstance();
    }

    public void addListener(RepositoryContollerListener listener) {
        this.listeners.add(listener);
    }

    public void fireListeners() {
        for (RepositoryContollerListener listener : this.listeners) {
            listener.update();
        }
    }

    public static interface RepositoryContollerListener {
        public void update();
    }
}

