/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gpload;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpload.GPLoad;
import org.pentaho.di.trans.steps.gpload.GPLoadData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="GPLoad", image="BLKGP.svg", i18nPackageName="org.pentaho.di.trans.steps.gpload", name="GPLoad.TypeLongDesc", description="GPLoad.TypeLongDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Bulk", documentationUrl="http://wiki.pentaho.com/display/EAI/Greenplum+Load")
@InjectionSupported(localizationPrefix="GPLoad.Injection.", groups={"FIELDS", "LOCALHOSTS", "GP_CONFIG"})
public class GPLoadMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GPLoadMeta.class;
    @Injection(name="LOCALHOST_NAME", group="LOCALHOSTS")
    private String[] localHosts;
    @Injection(name="PORT", group="LOCALHOSTS")
    private String localhostPort;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    @Injection(name="ERROR_TABLE", group="GP_CONFIG")
    private String errorTableName;
    @Injection(name="GPLOAD_PATH", group="GP_CONFIG")
    private String gploadPath;
    @Injection(name="CONTROL_FILE", group="GP_CONFIG")
    private String controlFile;
    @Injection(name="DATA_FILE", group="GP_CONFIG")
    private String dataFile;
    @Injection(name="LOG_FILE", group="GP_CONFIG")
    private String logFile;
    @Injection(name="NULL_AS", group="GP_CONFIG")
    private String nullAs;
    private DatabaseMeta databaseMeta;
    @Injection(name="FIELD_TABLE", group="FIELDS")
    private String[] fieldTable;
    @Injection(name="FIELD_STREAM", group="FIELDS")
    private String[] fieldStream;
    @Injection(name="FIELD_MATCH", group="FIELDS")
    private boolean[] matchColumn;
    @Injection(name="FIELD_UPDATE", group="FIELDS")
    private boolean[] updateColumn;
    @Injection(name="FIELD_DATEMASK", group="FIELDS")
    private String[] dateMask;
    @Injection(name="MAX_ERRORS", group="GP_CONFIG")
    private String maxErrors;
    @Injection(name="LOAD_METHOD")
    private String loadMethod;
    @Injection(name="LOAD_ACTION", group="FIELDS")
    private String loadAction;
    @Injection(name="ENCODING", group="GP_CONFIG")
    private String encoding;
    @Injection(name="ERASE_FILE")
    private boolean eraseFiles;
    @Injection(name="ENCLOSURE_NUMBERS")
    private boolean encloseNumbers;
    @Injection(name="DELIMITER", group="GP_CONFIG")
    private String delimiter;
    public static String MAX_ERRORS_DEFAULT = "50";
    @Injection(name="UPDATE_CONDITIONS", group="FIELDS")
    private String updateCondition;
    public static final String[] SUPPORTED_ENCODINGS = new String[]{"", "BIG5", "EUC_CN", "EUC_JP", "EUC_KR", "EUC_TW", "GB18030", "GBK", "ISO-8859-1", "ISO_8859_5", "ISO_8859_6", "ISO_8859_7", "ISO_8859_8", "JOHAB", "KOI8", "LATIN1", "LATIN2", "LATIN3", "LATIN4", "LATIN5", "LATIN6", "LATIN7", "LATIN8", "LATIN9", "LATIN10", "MULE_INTERNAL", "SJIS", "SQL_ASCII", "UHC", "UTF8", "WIN866", "WIN874", "WIN1250", "WIN1251", "WIN1252", "WIN1253", "WIN1254", "WIN1255", "WIN1256", "WIN1257", "WIN1258"};
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_MERGE = "merge";
    public static final String METHOD_AUTO_END = "AUTO_END";
    public static final String METHOD_MANUAL = "MANUAL";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getErrorTableName() {
        return this.errorTableName;
    }

    public void setErrorTableName(String errorTableName) {
        this.errorTableName = errorTableName;
    }

    public String getGploadPath() {
        return this.gploadPath;
    }

    public void setGploadPath(String gploadPath) {
        this.gploadPath = gploadPath;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String[] dateMask) {
        this.dateMask = dateMask;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.dateMask = new String[nrvalues];
        this.matchColumn = new boolean[nrvalues];
        this.updateColumn = new boolean[nrvalues];
    }

    public void allocateLocalHosts(int numberOfLocalHosts) {
        this.localHosts = new String[numberOfLocalHosts];
    }

    public Object clone() {
        GPLoadMeta retval = (GPLoadMeta)((Object)super.clone());
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.dateMask[i] = this.dateMask[i];
            retval.matchColumn[i] = this.matchColumn[i];
            retval.updateColumn[i] = this.updateColumn[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.maxErrors = XMLHandler.getTagValue((Node)stepnode, (String)"errors");
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.errorTableName = XMLHandler.getTagValue((Node)stepnode, (String)"error_table");
            this.loadMethod = XMLHandler.getTagValue((Node)stepnode, (String)"load_method");
            this.loadAction = XMLHandler.getTagValue((Node)stepnode, (String)"load_action");
            this.gploadPath = XMLHandler.getTagValue((Node)stepnode, (String)"gpload_path");
            this.controlFile = XMLHandler.getTagValue((Node)stepnode, (String)"control_file");
            this.dataFile = XMLHandler.getTagValue((Node)stepnode, (String)"data_file");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.logFile = XMLHandler.getTagValue((Node)stepnode, (String)"log_file");
            this.nullAs = XMLHandler.getTagValue((Node)stepnode, (String)"null_as");
            this.eraseFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"erase_files"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.updateCondition = XMLHandler.getTagValue((Node)stepnode, (String)"update_condition");
            Node localHostsNode = XMLHandler.getSubNode((Node)stepnode, (String)"local_hosts");
            int nLocalHosts = XMLHandler.countNodes((Node)localHostsNode, (String)"local_host");
            this.allocateLocalHosts(nLocalHosts);
            for (int i = 0; i < nLocalHosts; ++i) {
                Node localHostNode = XMLHandler.getSubNodeByNr((Node)localHostsNode, (String)"local_host", (int)i);
                this.localHosts[i] = XMLHandler.getNodeValue((Node)localHostNode);
            }
            this.localhostPort = XMLHandler.getTagValue((Node)stepnode, (String)"localhost_port");
            this.encloseNumbers = XMLHandler.getTagValue((Node)stepnode, (String)"enclose_numbers").equalsIgnoreCase("Y");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                String locDateMask;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.dateMask[i] = (locDateMask = XMLHandler.getTagValue((Node)vnode, (String)"date_mask")) == null ? "" : (DATE_MASK_DATE.equals(locDateMask) || DATE_MASK_DATETIME.equals(locDateMask) ? locDateMask : "");
                this.matchColumn[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"match_column"));
                this.updateColumn[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"update_column"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.maxErrors = MAX_ERRORS_DEFAULT;
        this.schemaName = "";
        this.localhostPort = "";
        this.tableName = BaseMessages.getString(PKG, (String)"GPLoadMeta.DefaultTableName", (String[])new String[0]);
        this.errorTableName = "";
        this.loadMethod = METHOD_AUTO_END;
        this.loadAction = ACTION_INSERT;
        this.gploadPath = "/usr/local/greenplum-db/bin/gpload";
        this.controlFile = "control${Internal.Step.CopyNr}.cfg";
        this.dataFile = "load${Internal.Step.CopyNr}.dat";
        this.logFile = "";
        this.nullAs = "";
        this.encoding = "";
        this.delimiter = ",";
        this.encloseNumbers = false;
        this.eraseFiles = true;
        this.updateCondition = "";
        this.allocate(0);
        this.allocateLocalHosts(0);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"errors", (String)this.maxErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_table", (String)this.errorTableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_method", (String)this.loadMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_action", (String)this.loadAction));
        retval.append("    ").append(XMLHandler.addTagValue((String)"gpload_path", (String)this.gploadPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"control_file", (String)this.controlFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"data_file", (String)this.dataFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"null_as", (String)this.nullAs));
        retval.append("    ").append(XMLHandler.addTagValue((String)"erase_files", (boolean)this.eraseFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclose_numbers", (String)(this.encloseNumbers ? "Y" : "N")));
        retval.append("    ").append(XMLHandler.addTagValue((String)"localhost_port", (String)this.localhostPort));
        retval.append("    ").append(XMLHandler.addTagValue((String)"update_condition", (String)this.updateCondition));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"date_mask", (String)this.dateMask[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"match_column", (String)(this.matchColumn[i] ? "Y" : "N")));
            retval.append("        ").append(XMLHandler.addTagValue((String)"update_column", (String)(this.updateColumn[i] ? "Y" : "N")));
            retval.append("      </mapping>").append(Const.CR);
        }
        retval.append("      <local_hosts>").append(Const.CR);
        for (String localHost : this.localHosts) {
            retval.append("        ").append(XMLHandler.addTagValue((String)"local_host", (String)localHost));
        }
        retval.append("      </local_hosts>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.maxErrors = rep.getStepAttributeString(id_step, "errors");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.errorTableName = rep.getStepAttributeString(id_step, "error_table");
            this.loadMethod = rep.getStepAttributeString(id_step, "load_method");
            this.loadAction = rep.getStepAttributeString(id_step, "load_action");
            this.gploadPath = rep.getStepAttributeString(id_step, "gpload_path");
            this.controlFile = rep.getStepAttributeString(id_step, "control_file");
            this.dataFile = rep.getStepAttributeString(id_step, "data_file");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.logFile = rep.getStepAttributeString(id_step, "log_file");
            this.nullAs = rep.getStepAttributeString(id_step, "null_as");
            this.eraseFiles = rep.getStepAttributeBoolean(id_step, "erase_files");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.localhostPort = rep.getStepAttributeString(id_step, "localhost_port");
            this.encloseNumbers = rep.getStepAttributeString(id_step, "enclose_numbers").equalsIgnoreCase("Y");
            this.updateCondition = rep.getStepAttributeString(id_step, "update_condition");
            int numberOfLocalHosts = rep.countNrStepAttributes(id_step, "local_host");
            this.allocateLocalHosts(numberOfLocalHosts);
            for (int i = 0; i < numberOfLocalHosts; ++i) {
                this.localHosts[i] = rep.getStepAttributeString(id_step, i, "local_host");
            }
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.dateMask[i] = rep.getStepAttributeString(id_step, i, "date_mask");
                this.matchColumn[i] = rep.getStepAttributeBoolean(id_step, i, "match_column");
                this.updateColumn[i] = rep.getStepAttributeBoolean(id_step, i, "update_column");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "errors", this.maxErrors);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "error_table", this.errorTableName);
            rep.saveStepAttribute(id_transformation, id_step, "load_method", this.loadMethod);
            rep.saveStepAttribute(id_transformation, id_step, "load_action", this.loadAction);
            rep.saveStepAttribute(id_transformation, id_step, "gpload_path", this.gploadPath);
            rep.saveStepAttribute(id_transformation, id_step, "control_file", this.controlFile);
            rep.saveStepAttribute(id_transformation, id_step, "data_file", this.dataFile);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "log_file", this.logFile);
            rep.saveStepAttribute(id_transformation, id_step, "null_as", this.nullAs);
            rep.saveStepAttribute(id_transformation, id_step, "erase_files", this.eraseFiles);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "enclose_numbers", this.encloseNumbers ? "Y" : "N");
            rep.saveStepAttribute(id_transformation, id_step, "localhost_port", this.localhostPort);
            rep.saveStepAttribute(id_transformation, id_step, "update_condition", this.updateCondition);
            for (i = 0; i < this.localHosts.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "local_host", this.localHosts[i]);
            }
            for (i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "date_mask", this.dateMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "match_column", this.matchColumn[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "update_column", this.updateColumn[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GPLoadMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"GPLoadMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"GPLoadMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"GPLoadMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"GPLoadMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GPLoad(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GPLoadData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getNullAs() {
        return this.nullAs;
    }

    public void setNullAs(String nullAs) {
        this.nullAs = nullAs;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public void setLoadMethod(String method) {
        this.loadMethod = method;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEnclosure() {
        return "";
    }

    public boolean isEraseFiles() {
        return this.eraseFiles;
    }

    public void setEraseFiles(boolean eraseFiles) {
        this.eraseFiles = eraseFiles;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setEncloseNumbers(boolean encloseNumbers) {
        this.encloseNumbers = encloseNumbers;
    }

    public boolean getEncloseNumbers() {
        return this.encloseNumbers;
    }

    public void setLocalHosts(String[] localHosts) {
        this.localHosts = localHosts;
    }

    public String[] getLocalHosts() {
        return this.localHosts;
    }

    public void setLocalhostPort(String localhostPort) {
        this.localhostPort = localhostPort;
    }

    public String getLocalhostPort() {
        return this.localhostPort;
    }

    public void setMatchColumns(boolean[] matchColumn) {
        this.matchColumn = matchColumn;
    }

    public boolean[] getMatchColumn() {
        return this.matchColumn;
    }

    public void setUpdateColumn(boolean[] updateColumn) {
        this.updateColumn = updateColumn;
    }

    public boolean[] getUpdateColumn() {
        return this.updateColumn;
    }

    public boolean hasMatchColumn() {
        for (boolean matchColumn : this.matchColumn) {
            if (!matchColumn) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpdateColumn() {
        for (boolean updateColumn : this.updateColumn) {
            if (!updateColumn) continue;
            return true;
        }
        return false;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    public String getUpdateCondition() {
        return this.updateCondition;
    }
}

