/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.elasticsearchbulk;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.elasticsearchbulk.ElasticSearchBulkMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.LabelComboVar;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.elasticsearchbulk.LabelTimeComposite;

public class ElasticSearchBulkDialog
extends BaseStepDialog
implements StepDialogInterface {
    private ElasticSearchBulkMeta model;
    private static Class<?> PKG = ElasticSearchBulkMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wGeneralTab;
    private Composite wGeneralComp;
    private FormData fdGeneralComp;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private LabelTextVar wIdOutField;
    private Group wIndexGroup;
    private FormData fdIndexGroup;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private String[] fieldNames;
    private CTabItem wFieldsTab;
    private LabelTextVar wIndex;
    private LabelTextVar wType;
    private ModifyListener lsMod;
    private Button wIsJson;
    private Label wlIsJson;
    private Label wlUseOutput;
    private Button wUseOutput;
    private LabelComboVar wJsonField;
    private TableView wFields;
    private CTabItem wServersTab;
    private TableView wServers;
    private CTabItem wSettingsTab;
    private TableView wSettings;
    private LabelTimeComposite wTimeOut;
    private Label wlStopOnError;
    private Button wStopOnError;
    private Button wTest;
    private Button wTestCl;
    private LabelComboVar wIdInField;
    private Button wIsOverwrite;
    private Label wlIsOverwrite;

    public ElasticSearchBulkDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.model = (ElasticSearchBulkMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.model);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ElasticSearchBulkDialog.this.model.setChanged();
            }
        };
        this.changed = this.model.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.addGeneralTab();
        this.addServersTab();
        this.addFieldsTab();
        this.addSettingsTab();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.addStandardListeners();
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData(this.model);
        this.model.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void addStandardListeners() {
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ElasticSearchBulkDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ElasticSearchBulkDialog.this.cancel();
            }
        };
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ElasticSearchBulkDialog.this.model.setChanged();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ElasticSearchBulkDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ElasticSearchBulkDialog.this.cancel();
            }
        });
    }

    private void addGeneralTab() {
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.General.Tab", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.fillIndexGroup(this.wGeneralComp);
        this.fillOptionsGroup(this.wGeneralComp);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment((Control)this.wStepname, 4);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
    }

    private void fillIndexGroup(Composite parentTab) {
        this.wIndexGroup = new Group(parentTab, 32);
        this.props.setLook((Control)this.wIndexGroup);
        this.wIndexGroup.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IndexGroup.Label", (String[])new String[0]));
        FormLayout indexGroupLayout = new FormLayout();
        indexGroupLayout.marginWidth = 10;
        indexGroupLayout.marginHeight = 10;
        this.wIndexGroup.setLayout((Layout)indexGroupLayout);
        this.wIndex = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wIndexGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Index.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Index.Tooltip", (String[])new String[0]));
        this.wIndex.addModifyListener(this.lsMod);
        this.wType = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wIndexGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Type.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Type.Tooltip", (String[])new String[0]));
        this.wType.addModifyListener(this.lsMod);
        this.wTest = new Button((Composite)this.wIndexGroup, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TestIndex.Label", (String[])new String[0]));
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TestIndex.Tooltip", (String[])new String[0]));
        this.wTest.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ElasticSearchBulkDialog.this.test(TestType.INDEX);
            }
        });
        Control[] connectionControls = new Control[]{this.wIndex, this.wType};
        this.placeControls(this.wIndexGroup, connectionControls);
        BaseStepDialog.positionBottomButtons((Composite)this.wIndexGroup, (Button[])new Button[]{this.wTest}, (int)4, (Control)this.wType);
        this.fdIndexGroup = new FormData();
        this.fdIndexGroup.left = new FormAttachment(0, 4);
        this.fdIndexGroup.top = new FormAttachment((Control)this.wStepname, 4);
        this.fdIndexGroup.right = new FormAttachment(100, -4);
        this.wIndexGroup.setLayoutData((Object)this.fdIndexGroup);
    }

    private void addServersTab() {
        this.wServersTab = new CTabItem(this.wTabFolder, 0);
        this.wServersTab.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.ServersTab.TabTitle", (String[])new String[0]));
        FormLayout serversLayout = new FormLayout();
        serversLayout.marginWidth = 5;
        serversLayout.marginHeight = 5;
        Composite wServersComp = new Composite((Composite)this.wTabFolder, 0);
        wServersComp.setLayout((Layout)serversLayout);
        this.props.setLook((Control)wServersComp);
        this.wTestCl = new Button(wServersComp, 8);
        this.wTestCl.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TestCluster.Label", (String[])new String[0]));
        this.wTestCl.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TestCluster.Tooltip", (String[])new String[0]));
        this.wTestCl.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ElasticSearchBulkDialog.this.test(TestType.CLUSTER);
            }
        });
        this.setButtonPositions(new Button[]{this.wTestCl}, 4, null);
        ColumnInfo[] columnsMeta = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.ServersTab.Address.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.ServersTab.Port.Column", (String[])new String[0]), 1, true)};
        this.wServers = new TableView((VariableSpace)this.transMeta, wServersComp, 67586, columnsMeta, 1, this.lsMod, this.props);
        FormData fdServers = new FormData();
        fdServers.left = new FormAttachment(0, 4);
        fdServers.top = new FormAttachment(0, 4);
        fdServers.right = new FormAttachment(100, -4);
        fdServers.bottom = new FormAttachment((Control)this.wTestCl, -4);
        this.wServers.setLayoutData((Object)fdServers);
        FormData fdServersComp = new FormData();
        fdServersComp.left = new FormAttachment(0, 0);
        fdServersComp.top = new FormAttachment(0, 0);
        fdServersComp.right = new FormAttachment(100, 0);
        fdServersComp.bottom = new FormAttachment(100, 0);
        wServersComp.setLayoutData((Object)fdServersComp);
        wServersComp.layout();
        this.wServersTab.setControl((Control)wServersComp);
    }

    private void addSettingsTab() {
        this.wSettingsTab = new CTabItem(this.wTabFolder, 0);
        this.wSettingsTab.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.SettingsTab.TabTitle", (String[])new String[0]));
        FormLayout serversLayout = new FormLayout();
        serversLayout.marginWidth = 5;
        serversLayout.marginHeight = 5;
        Composite wSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        wSettingsComp.setLayout((Layout)serversLayout);
        this.props.setLook((Control)wSettingsComp);
        ColumnInfo[] columnsMeta = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.SettingsTab.Property.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.SettingsTab.Value.Column", (String[])new String[0]), 1, false)};
        this.wSettings = new TableView((VariableSpace)this.transMeta, wSettingsComp, 67586, columnsMeta, 1, this.lsMod, this.props);
        FormData fdServers = new FormData();
        fdServers.left = new FormAttachment(0, 4);
        fdServers.top = new FormAttachment(0, 4);
        fdServers.right = new FormAttachment(100, -4);
        fdServers.bottom = new FormAttachment(100, -4);
        this.wSettings.setLayoutData((Object)fdServers);
        FormData fdServersComp = new FormData();
        fdServersComp.left = new FormAttachment(0, 0);
        fdServersComp.top = new FormAttachment(0, 0);
        fdServersComp.right = new FormAttachment(100, 0);
        fdServersComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdServersComp);
        wSettingsComp.layout();
        this.wSettingsTab.setControl((Control)wSettingsComp);
    }

    private void addFieldsTab() {
        String[] stringArray;
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                ElasticSearchBulkDialog.this.getPreviousFields(ElasticSearchBulkDialog.this.wFields);
            }
        };
        this.wGet.addListener(13, this.lsGet);
        this.setButtonPositions(new Button[]{this.wGet}, 4, null);
        int fieldsRowCount = this.model.getFields().size();
        if (this.fieldNames != null) {
            stringArray = this.fieldNames;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] names = stringArray;
        ColumnInfo[] columnsMeta = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.NameColumn.Column", (String[])new String[0]), 2, names, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TargetNameColumn.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, columnsMeta, fieldsRowCount, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 4);
        fdFields.top = new FormAttachment(0, 4);
        fdFields.right = new FormAttachment(100, -4);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -4);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void fillOptionsGroup(Composite parentTab) {
        int margin = 4;
        this.wSettingsGroup = new Group(parentTab, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)settingGroupLayout);
        this.wTimeOut = new LabelTimeComposite((Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TimeOut.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.TimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeOut);
        this.wTimeOut.addModifyListener(this.lsMod);
        this.wlBatchSize = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.BatchSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBatchSize);
        this.wBatchSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(this.lsMod);
        this.wlStopOnError = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlStopOnError.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.StopOnError.Label", (String[])new String[0]));
        this.wStopOnError = new Button((Composite)this.wSettingsGroup, 131104);
        this.wStopOnError.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.StopOnError.Tooltip", (String[])new String[0]));
        this.wIdInField = new LabelComboVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IdField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IdField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wIdInField);
        this.wIdInField.getComboWidget().setEditable(true);
        this.wIdInField.addModifyListener(this.lsMod);
        this.wIdInField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ElasticSearchBulkDialog.this.getPreviousFields(ElasticSearchBulkDialog.this.wIdInField);
            }
        });
        this.getPreviousFields(this.wIdInField);
        this.wlIsOverwrite = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlIsOverwrite.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Overwrite.Label", (String[])new String[0]));
        this.wIsOverwrite = new Button((Composite)this.wSettingsGroup, 131104);
        this.wIsOverwrite.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Overwrite.Tooltip", (String[])new String[0]));
        this.wlUseOutput = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlUseOutput.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.UseOutput.Label", (String[])new String[0]));
        this.wUseOutput = new Button((Composite)this.wSettingsGroup, 131104);
        this.wUseOutput.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.UseOutput.Tooltip", (String[])new String[0]));
        this.wUseOutput.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }

            public void widgetSelected(SelectionEvent arg0) {
                ElasticSearchBulkDialog.this.wIdOutField.setEnabled(ElasticSearchBulkDialog.this.wUseOutput.getSelection());
            }
        });
        this.wIdOutField = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IdOutField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IdOutField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wIdOutField);
        this.wIdOutField.setEnabled(this.wUseOutput.getSelection());
        this.wIdOutField.addModifyListener(this.lsMod);
        this.wlIsJson = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlIsJson.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IsJson.Label", (String[])new String[0]));
        this.wIsJson = new Button((Composite)this.wSettingsGroup, 131104);
        this.wIsJson.setToolTipText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IsJson.Tooltip", (String[])new String[0]));
        this.wIsJson.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }

            public void widgetSelected(SelectionEvent arg0) {
                ElasticSearchBulkDialog.this.wJsonField.setEnabled(ElasticSearchBulkDialog.this.wIsJson.getSelection());
                ElasticSearchBulkDialog.this.wFields.setEnabled(!ElasticSearchBulkDialog.this.wIsJson.getSelection());
                ElasticSearchBulkDialog.this.wFields.setVisible(!ElasticSearchBulkDialog.this.wIsJson.getSelection());
                ElasticSearchBulkDialog.this.wGet.setEnabled(!ElasticSearchBulkDialog.this.wIsJson.getSelection());
            }
        });
        this.wJsonField = new LabelComboVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.JsonField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.JsonField.Tooltip", (String[])new String[0]));
        this.wJsonField.getComboWidget().setEditable(true);
        this.props.setLook((Control)this.wJsonField);
        this.wJsonField.addModifyListener(this.lsMod);
        this.wJsonField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ElasticSearchBulkDialog.this.getPreviousFields(ElasticSearchBulkDialog.this.wJsonField);
            }
        });
        this.getPreviousFields(this.wJsonField);
        this.wJsonField.setEnabled(this.wIsJson.getSelection());
        Control[] settingsControls = new Control[]{this.wlBatchSize, this.wBatchSize, this.wlStopOnError, this.wStopOnError, this.wTimeOut, this.wIdInField, this.wlIsOverwrite, this.wIsOverwrite, this.wlUseOutput, this.wUseOutput, this.wIdOutField, this.wlIsJson, this.wIsJson, this.wJsonField};
        this.placeControls(this.wSettingsGroup, settingsControls);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wIndexGroup, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
    }

    private void getPreviousFields(LabelComboVar combo) {
        String value = combo.getText();
        combo.removeAll();
        combo.setItems(this.getInputFieldNames());
        if (value != null) {
            combo.setText(value);
        }
    }

    private String[] getInputFieldNames() {
        if (this.fieldNames == null) {
            try {
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.fieldNames = r.getFieldNames();
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
                return new String[0];
            }
        }
        return this.fieldNames;
    }

    private void getPreviousFields(TableView table) {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)table, (int)1, (int[])new int[]{1, 2}, null, (int)0, (int)0, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void placeControls(Group group, Control[] controls) {
        Group previousAbove = group;
        Group previousLeft = group;
        for (Control control : controls) {
            if (control instanceof Label) {
                this.addLabelAfter(control, (Control)previousAbove);
                previousLeft = control;
                continue;
            }
            this.addWidgetAfter(control, (Control)previousAbove, (Control)previousLeft);
            previousAbove = control;
            previousLeft = group;
        }
    }

    private void addWidgetAfter(Control widget, Control widgetAbove, Control widgetLeft) {
        this.props.setLook(widget);
        FormData fData = new FormData();
        fData.left = new FormAttachment(widgetLeft, 4);
        fData.top = new FormAttachment(widgetAbove, 4);
        fData.right = new FormAttachment(100, -4);
        widget.setLayoutData((Object)fData);
    }

    private void addLabelAfter(Control widget, Control widgetAbove) {
        this.props.setLook(widget);
        FormData fData = new FormData();
        fData.top = new FormAttachment(widgetAbove, 4);
        fData.right = new FormAttachment(35, -4);
        widget.setLayoutData((Object)fData);
    }

    public void getData(ElasticSearchBulkMeta in) {
        this.wIndex.setText(Const.NVL((String)in.getIndex(), (String)""));
        this.wType.setText(Const.NVL((String)in.getType(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)in.getBatchSize(), (String)"50000"));
        this.wStopOnError.setSelection(in.isStopOnError());
        this.wTimeOut.setText(Const.NVL((String)in.getTimeOut(), (String)""));
        this.wTimeOut.setTimeUnit(in.getTimeoutUnit());
        this.wIdInField.setText(Const.NVL((String)in.getIdInField(), (String)""));
        this.wIsOverwrite.setSelection(in.isOverWriteIfSameId());
        this.wIsJson.setSelection(in.isJsonInsert());
        this.wJsonField.setText(Const.NVL((String)in.getJsonField(), (String)""));
        this.wJsonField.setEnabled(this.wIsJson.getSelection());
        this.wUseOutput.setSelection(in.isUseOutput());
        this.wIdOutField.setText(Const.NVL((String)in.getIdOutField(), (String)""));
        this.wIdOutField.setEnabled(this.wUseOutput.getSelection());
        this.mapToTableView(this.model.getFieldsMap(), this.wFields);
        for (ElasticSearchBulkMeta.Server server : this.model.getServers()) {
            this.wServers.add(new String[]{server.address, "" + server.port});
        }
        this.wServers.removeEmptyRows();
        this.wServers.setRowNums();
        this.mapToTableView(this.model.getSettingsMap(), this.wSettings);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void mapToTableView(Map<String, String> map, TableView table) {
        for (String key : map.keySet()) {
            table.add(new String[]{key, map.get(key)});
        }
        table.removeEmptyRows();
        table.setRowNums();
    }

    private void cancel() {
        this.stepname = null;
        this.model.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.toModel(this.model);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.ErrorValidateData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.ErrorValidateData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void toModel(ElasticSearchBulkMeta in) throws KettleException {
        String[] row;
        int i;
        this.stepname = this.wStepname.getText();
        in.setType(this.wType.getText());
        in.setIndex(this.wIndex.getText());
        in.setBatchSize(this.wBatchSize.getText());
        in.setTimeOut(Const.NVL((String)this.wTimeOut.getText(), null));
        in.setTimeoutUnit(this.wTimeOut.getTimeUnit());
        in.setIdInField(this.wIdInField.getText());
        in.setOverWriteIfSameId(StringUtils.isNotBlank((String)this.wIdInField.getText()) && this.wIsOverwrite.getSelection());
        in.setStopOnError(this.wStopOnError.getSelection());
        in.setJsonInsert(this.wIsJson.getSelection());
        in.setJsonField(this.wIsJson.getSelection() ? this.wJsonField.getText() : null);
        in.setIdOutField(this.wIdOutField.getText());
        in.setUseOutput(this.wUseOutput.getSelection());
        in.clearFields();
        if (!this.wIsJson.getSelection()) {
            for (i = 0; i < this.wFields.getItemCount(); ++i) {
                row = this.wFields.getItem(i);
                if (!StringUtils.isNotBlank((String)row[0])) continue;
                in.addField(row[0], row[1]);
            }
        }
        in.clearServers();
        for (i = 0; i < this.wServers.getItemCount(); ++i) {
            row = this.wServers.getItem(i);
            if (!StringUtils.isNotBlank((String)row[0])) continue;
            try {
                in.addServer(row[0], Integer.parseInt(row[1]));
                continue;
            }
            catch (NumberFormatException nfe) {
                in.addServer(row[0], 9300);
            }
        }
        in.clearSettings();
        for (i = 0; i < this.wSettings.getItemCount(); ++i) {
            row = this.wSettings.getItem(i);
            in.addSetting(row[0], row[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void test(TestType testType) {
        originalClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        client = null;
        node = null;
        try {
            tempMeta = new ElasticSearchBulkMeta();
            this.toModel(tempMeta);
            settingsBuilder = Settings.settingsBuilder();
            settingsBuilder.put(Settings.Builder.EMPTY_SETTINGS);
            settingsBuilder.put(tempMeta.getSettingsMap());
            tClientBuilder = TransportClient.builder().settings(settingsBuilder);
            if (!tempMeta.getServers().isEmpty()) {
                node = null;
                tClient = tClientBuilder.build();
                for (ElasticSearchBulkMeta.Server s : tempMeta.getServers()) {
                    tClient.addTransportAddress((TransportAddress)s.getAddr());
                }
                client = tClient;
            } else {
                nodeBuilder = NodeBuilder.nodeBuilder();
                nodeBuilder.settings(settingsBuilder);
                node = nodeBuilder.client(true).node();
                client = node.client();
                node.start();
            }
            admin = client.admin();
            switch (14.$SwitchMap$org$pentaho$di$ui$trans$steps$elasticsearchbulk$ElasticSearchBulkDialog$TestType[testType.ordinal()]) {
                case 1: {
                    if (StringUtils.isBlank((String)tempMeta.getIndex())) {
                        this.showError(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulk.Error.NoIndex", (String[])new String[0]));
                        ** break;
lbl36:
                        // 1 sources

                    } else {
                        indicesExistBld = admin.indices().prepareExists(new String[]{tempMeta.getIndex()});
                        indicesExistResponse = (IndicesExistsResponse)indicesExistBld.execute().get();
                        if (!indicesExistResponse.isExists()) {
                            this.showError(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulkDialog.Error.NoIndex", (String[])new String[0]));
                            return;
                        }
                        indicesBld = admin.indices().prepareRecoveries(new String[]{tempMeta.getIndex()});
                        lafInd = indicesBld.execute();
                        shards = "" + ((RecoveryResponse)lafInd.get()).getSuccessfulShards() + "/" + ((RecoveryResponse)lafInd.get()).getTotalShards();
                        this.showMessage(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulkDialog.TestIndex.TestOK", (String[])new String[]{shards}));
                        ** break;
                    }
lbl47:
                    // 1 sources

                    break;
                }
                case 2: {
                    clusterBld = admin.cluster().prepareState();
                    lafClu = clusterBld.execute();
                    cluResp = (ClusterStateResponse)lafClu.actionGet();
                    name = cluResp.getClusterName().value();
                    cluState = cluResp.getState();
                    numNodes = cluState.getNodes().size();
                    this.showMessage(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulkDialog.TestCluster.TestOK", (Object[])new Object[]{name, numNodes}));
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                ** default:
lbl59:
                // 1 sources

                break;
            }
        }
        catch (NoNodeAvailableException e) {
            this.showError(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulkDialog.Error.NoNodesFound", (String[])new String[0]));
        }
        catch (MasterNotDiscoveredException e) {
            this.showError(BaseMessages.getString(ElasticSearchBulkDialog.PKG, (String)"ElasticSearchBulkDialog.Error.NoNodesFound", (String[])new String[0]));
        }
        catch (Exception e) {
            this.showError(e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (node != null) {
                node.close();
            }
        }
        Thread.currentThread().setContextClassLoader(originalClassloader);
    }

    private void showError(String message) {
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setMessage(message);
        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
        mb.open();
    }

    private void showMessage(String message) {
        MessageBox mb = new MessageBox(this.shell, 34);
        mb.setMessage(message);
        mb.setText(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Test.TestOKTitle", (String[])new String[0]));
        mb.open();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static enum TestType {
        INDEX,
        CLUSTER;

    }
}

