/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.AttachmentUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.CallbackLookup;
import org.apache.wss4j.dom.message.DOMCallbackLookup;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.X509Util;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static Element findEncryptedDataElement(Document doc, WSDocInfo wsDocInfo, String dataRefURI) throws WSSecurityException {
        Element encryptedDataElement;
        CallbackLookup callbackLookup = wsDocInfo.getCallbackLookup();
        if (callbackLookup == null) {
            callbackLookup = new DOMCallbackLookup(doc);
        }
        if ((encryptedDataElement = callbackLookup.getElement(dataRefURI, null, true)) == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "dataRef", new Object[]{dataRefURI});
        }
        if (encryptedDataElement.getLocalName().equals("EncryptedHeader") && encryptedDataElement.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            Node child;
            for (child = encryptedDataElement.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
            }
            return (Element)child;
        }
        return encryptedDataElement;
    }

    public static WSDataRef decryptEncryptedData(Document doc, String dataRefURI, Element encData, SecretKey symmetricKey, String symEncAlgo, RequestData requestData) throws WSSecurityException {
        String typeStr = encData.getAttributeNS(null, "Type");
        String xopURI = EncryptionUtils.getXOPURIFromEncryptedData(encData);
        if (typeStr != null && ("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only".equals(typeStr) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete".equals(typeStr))) {
            Element cipherData = org.apache.wss4j.common.util.XMLUtils.getDirectChildElement((Node)encData, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (cipherData == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
            }
            Element cipherReference = org.apache.wss4j.common.util.XMLUtils.getDirectChildElement((Node)cipherData, (String)"CipherReference", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (cipherReference == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
            }
            String uri = cipherReference.getAttributeNS(null, "URI");
            return EncryptionUtils.decryptAttachment(dataRefURI, uri, encData, symmetricKey, symEncAlgo, requestData);
        }
        WSDataRef dataRef = new WSDataRef();
        dataRef.setEncryptedElement(encData);
        dataRef.setWsuId(dataRefURI);
        dataRef.setAlgorithm(symEncAlgo);
        boolean content = X509Util.isContent(encData);
        dataRef.setContent(content);
        Element encDataOrig = encData;
        Node parent = encData.getParentNode();
        Node previousSibling = encData.getPreviousSibling();
        if (content) {
            encData = (Element)encData.getParentNode();
            parent = encData.getParentNode();
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.setSecureValidation(true);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
        Node decryptedNode = null;
        try {
            if (xopURI != null) {
                Element tempEncData = content ? encDataOrig : encData;
                decryptedNode = EncryptionUtils.decryptXopAttachment(symmetricKey, symEncAlgo, requestData, xopURI, tempEncData);
            } else {
                xmlCipher.doFinal(doc, encData, content);
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, ex);
        }
        if (parent.getLocalName().equals("EncryptedHeader") && parent.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd") || parent.getLocalName().equals("EncryptedAssertion") && parent.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            Node decryptedHeader = parent.getFirstChild();
            Node soapHeader = parent.getParentNode();
            soapHeader.replaceChild(decryptedHeader, parent);
            dataRef.setProtectedElement((Element)decryptedHeader);
            dataRef.setXpath(EncryptionUtils.getXPath(decryptedHeader));
        } else if (content) {
            dataRef.setProtectedElement(encData);
            dataRef.setXpath(EncryptionUtils.getXPath(encData));
        } else {
            if (decryptedNode == null) {
                decryptedNode = previousSibling == null ? parent.getFirstChild() : previousSibling.getNextSibling();
            }
            if (decryptedNode != null && 1 == decryptedNode.getNodeType()) {
                dataRef.setProtectedElement((Element)decryptedNode);
            }
            dataRef.setXpath(EncryptionUtils.getXPath(decryptedNode));
        }
        return dataRef;
    }

    private static String getXOPURIFromEncryptedData(Element encData) {
        Element cipherValue = EncryptionUtils.getCipherValueFromEncryptedData(encData);
        if (cipherValue != null) {
            return EncryptionUtils.getXOPURIFromCipherValue(cipherValue);
        }
        return null;
    }

    public static Element getCipherValueFromEncryptedData(Element encData) {
        Element cipherData = org.apache.wss4j.common.util.XMLUtils.getDirectChildElement((Node)encData, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (cipherData != null) {
            return org.apache.wss4j.common.util.XMLUtils.getDirectChildElement((Node)cipherData, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        }
        return null;
    }

    public static String getXOPURIFromCipherValue(Element cipherValue) {
        Element cipherValueChild;
        if (cipherValue != null && (cipherValueChild = org.apache.wss4j.common.util.XMLUtils.getDirectChildElement((Node)cipherValue, (String)"Include", (String)"http://www.w3.org/2004/08/xop/include")) != null && cipherValueChild.hasAttributeNS(null, "href")) {
            return cipherValueChild.getAttributeNS(null, "href");
        }
        return null;
    }

    private static WSDataRef decryptAttachment(String dataRefURI, String uri, Element encData, SecretKey symmetricKey, String symEncAlgo, RequestData requestData) throws WSSecurityException {
        WSDataRef dataRef = new WSDataRef();
        dataRef.setWsuId(dataRefURI);
        dataRef.setAlgorithm(symEncAlgo);
        try {
            if (uri == null || uri.length() < 5 || !uri.startsWith("cid:")) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
            }
            dataRef.setWsuId(uri);
            dataRef.setAttachment(true);
            CallbackHandler attachmentCallbackHandler = requestData.getAttachmentCallbackHandler();
            if (attachmentCallbackHandler == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
            }
            String attachmentId = uri.substring("cid:".length());
            AttachmentRequestCallback attachmentRequestCallback = new AttachmentRequestCallback();
            attachmentRequestCallback.setAttachmentId(attachmentId);
            attachmentCallbackHandler.handle(new Callback[]{attachmentRequestCallback});
            List attachments = attachmentRequestCallback.getAttachments();
            if (attachments == null || attachments.isEmpty() || !attachmentId.equals(((Attachment)attachments.get(0)).getId())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "empty", new Object[]{"Attachment not found"});
            }
            Attachment attachment = (Attachment)attachments.get(0);
            String encAlgo = X509Util.getEncAlgo(encData);
            String jceAlgorithm = JCEMapper.translateURItoJCEID((String)encAlgo);
            Cipher cipher = Cipher.getInstance(jceAlgorithm);
            InputStream attachmentInputStream = AttachmentUtils.setupAttachmentDecryptionStream((String)encAlgo, (Cipher)cipher, (Key)symmetricKey, (InputStream)attachment.getSourceStream());
            Attachment resultAttachment = new Attachment();
            resultAttachment.setId(attachment.getId());
            resultAttachment.setMimeType(encData.getAttributeNS(null, "MimeType"));
            resultAttachment.setSourceStream(attachmentInputStream);
            resultAttachment.addHeaders(attachment.getHeaders());
            String typeStr = encData.getAttributeNS(null, "Type");
            if ("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete".equals(typeStr)) {
                AttachmentUtils.readAndReplaceEncryptedAttachmentHeaders((Map)resultAttachment.getHeaders(), (InputStream)attachmentInputStream);
            }
            AttachmentResultCallback attachmentResultCallback = new AttachmentResultCallback();
            attachmentResultCallback.setAttachment(resultAttachment);
            attachmentResultCallback.setAttachmentId(resultAttachment.getId());
            attachmentCallbackHandler.handle(new Callback[]{attachmentResultCallback});
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        catch (IOException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        catch (NoSuchPaddingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        dataRef.setContent(true);
        encData.getParentNode().removeChild(encData);
        return dataRef;
    }

    private static Node decryptXopAttachment(SecretKey symmetricKey, String symEncAlgo, RequestData requestData, String xopURI, Element encData) throws WSSecurityException, IOException, UnsupportedCallbackException, NoSuchAlgorithmException, NoSuchPaddingException, ParserConfigurationException, SAXException {
        CallbackHandler attachmentCallbackHandler = requestData.getAttachmentCallbackHandler();
        if (attachmentCallbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
        }
        String attachmentId = xopURI.substring("cid:".length());
        AttachmentRequestCallback attachmentRequestCallback = new AttachmentRequestCallback();
        attachmentRequestCallback.setAttachmentId(attachmentId);
        attachmentCallbackHandler.handle(new Callback[]{attachmentRequestCallback});
        List attachments = attachmentRequestCallback.getAttachments();
        if (attachments == null || attachments.isEmpty() || !attachmentId.equals(((Attachment)attachments.get(0)).getId())) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "empty", new Object[]{"Attachment not found"});
        }
        Attachment attachment = (Attachment)attachments.get(0);
        String jceAlgorithm = JCEMapper.translateURItoJCEID((String)symEncAlgo);
        Cipher cipher = Cipher.getInstance(jceAlgorithm);
        InputStream attachmentInputStream = AttachmentUtils.setupAttachmentDecryptionStream((String)symEncAlgo, (Cipher)cipher, (Key)symmetricKey, (InputStream)attachment.getSourceStream());
        DocumentBuilder db = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = db.parse(attachmentInputStream);
        Node decryptedNode = encData.getOwnerDocument().importNode(document.getDocumentElement(), true);
        encData.getParentNode().appendChild(decryptedNode);
        XMLUtils.repoolDocumentBuilder((DocumentBuilder)db);
        encData.getParentNode().removeChild(encData);
        return decryptedNode;
    }

    public static String getXPath(Node decryptedNode) {
        if (decryptedNode == null) {
            return null;
        }
        String result = "";
        if (1 == decryptedNode.getNodeType()) {
            result = decryptedNode.getNodeName();
            result = EncryptionUtils.prependFullPath(result, decryptedNode.getParentNode());
        } else if (2 == decryptedNode.getNodeType()) {
            result = "@" + decryptedNode.getNodeName();
            result = EncryptionUtils.prependFullPath(result, ((Attr)decryptedNode).getOwnerElement());
        } else {
            return null;
        }
        return result;
    }

    private static String prependFullPath(String xpath, Node node) {
        if (node == null) {
            return null;
        }
        if (1 == node.getNodeType()) {
            xpath = node.getNodeName() + "/" + xpath;
            return EncryptionUtils.prependFullPath(xpath, node.getParentNode());
        }
        if (9 == node.getNodeType()) {
            return "/" + xpath;
        }
        return EncryptionUtils.prependFullPath(xpath, node.getParentNode());
    }

    public static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuilder sb = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            sb.append(((Text)node).getData());
        }
        String encodedData = sb.toString();
        try {
            return Base64.decode((String)encodedData);
        }
        catch (Base64DecodingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "decoding.general");
        }
    }

    public static String getDigestAlgorithm(Node encBodyData) throws WSSecurityException {
        Element digestElement;
        Element tmpE = WSSecurityUtil.getDirectChildElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null && (digestElement = WSSecurityUtil.getDirectChildElement(tmpE, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#")) != null) {
            return digestElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public static String getMGFAlgorithm(Node encBodyData) throws WSSecurityException {
        Element mgfElement;
        Element tmpE = WSSecurityUtil.getDirectChildElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null && (mgfElement = WSSecurityUtil.getDirectChildElement(tmpE, "MGF", "http://www.w3.org/2009/xmlenc11#")) != null) {
            return mgfElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public static byte[] getPSource(Node encBodyData) throws WSSecurityException {
        Element pSourceElement;
        Element tmpE = WSSecurityUtil.getDirectChildElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null && (pSourceElement = WSSecurityUtil.getDirectChildElement(tmpE, "OAEPparams", "http://www.w3.org/2001/04/xmlenc#")) != null) {
            return EncryptionUtils.getDecodedBase64EncodedData(pSourceElement);
        }
        return null;
    }
}

