/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.event;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class SyslogServerEvent
implements SyslogServerEventIF {
    private static final long serialVersionUID = 6136043067089899962L;
    public static final String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    protected String charSet = "UTF-8";
    protected byte[] raw = null;
    protected Date date = null;
    protected int level = -1;
    protected int facility = -1;
    protected String host = null;
    protected String message = null;
    protected InetAddress inetAddress = null;

    protected SyslogServerEvent() {
    }

    public SyslogServerEvent(byte[] byArray, int n, InetAddress inetAddress) {
        this.initialize(byArray, n, inetAddress);
        this.parse();
    }

    protected void initialize(byte[] byArray, int n, InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        this.raw = new byte[n];
        System.arraycopy(byArray, 0, this.raw, 0, n);
    }

    protected void parseHost() {
        int n = this.message.indexOf(32);
        String string = null;
        String string2 = null;
        if (n > -1) {
            String string3 = this.message.substring(0, n).trim();
            if (string3.equalsIgnoreCase(string = this.inetAddress.getHostAddress())) {
                this.host = string;
                this.message = this.message.substring(n + 1);
            }
            if (this.host == null && string3.equalsIgnoreCase(string2 = this.inetAddress.getHostName())) {
                this.host = string2;
                this.message = this.message.substring(n + 1);
            }
            if (this.host == null) {
                this.host = string2 != null ? string2 : string;
            }
        }
    }

    protected void parseDate() {
        if (this.message.length() >= 16 && this.message.charAt(3) == ' ' && this.message.charAt(6) == ' ') {
            String string = Integer.toString(Calendar.getInstance().get(1));
            String string2 = this.message.substring(0, 15) + " " + string;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            try {
                this.date = simpleDateFormat.parse(string2);
                this.message = this.message.substring(16);
            }
            catch (ParseException parseException) {
                this.date = new Date();
            }
        }
        this.parseHost();
    }

    protected void parsePriority() {
        int n;
        if (this.message.charAt(0) == '<' && (n = this.message.indexOf(">")) <= 4 && n > -1) {
            String string = this.message.substring(1, n);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
                this.facility = n2 >> 3 << 3;
                this.level = n2 - this.facility;
                this.message = this.message.substring(n + 1);
                this.parseDate();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parseHost();
        }
    }

    protected void parse() {
        this.message = SyslogUtility.newString(this, this.raw);
        this.parsePriority();
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int n) {
        this.facility = n;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }
}

