/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.ui.entry.hadoop;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.UserDefinedItem;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.hadoop.JobEntryHadoopJobExecutor;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.bigdata.api.mapreduce.MapReduceJarInfo;
import org.pentaho.bigdata.api.mapreduce.MapReduceService;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.jface.tags.JfaceCMenuList;
import org.pentaho.ui.xul.jface.tags.JfaceMenuList;
import org.pentaho.ui.xul.util.AbstractModelList;

public class JobEntryHadoopJobExecutorController
extends AbstractXulEventHandler {
    public static final String JOB_ENTRY_NAME = "jobEntryName";
    public static final String HADOOP_JOB_NAME = "hadoopJobName";
    public static final String JAR_URL = "jarUrl";
    public static final String DRIVER_CLASS = "driverClass";
    public static final String DRIVER_CLASSES = "driverClasses";
    public static final String IS_SIMPLE = "isSimple";
    public static final String USER_DEFINED = "userDefined";
    private static final Class<?> PKG = JobEntryHadoopJobExecutor.class;
    private String jobEntryName;
    private String hadoopJobName;
    private String jarUrl = "";
    private String driverClass = "";
    private List<String> driverClasses = new ArrayList<String>();
    private boolean isSimple = true;
    private SimpleConfiguration sConf = new SimpleConfiguration();
    private AdvancedConfiguration aConf = new AdvancedConfiguration();
    private JobEntryHadoopJobExecutor jobEntry;
    private JobMeta jobMeta;
    private AbstractModelList<UserDefinedItem> userDefined = new AbstractModelList();
    private final NamedClusterService namedClusterService;
    private final HadoopClusterDelegateImpl ncDelegate;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public JobEntryHadoopJobExecutorController(HadoopClusterDelegateImpl hadoopClusterDelegate, NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator) {
        this.ncDelegate = hadoopClusterDelegate;
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    protected VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public void accept() {
        NamedCluster reload;
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
        this.hadoopJobName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jar-url");
        this.jarUrl = ((Text)tempBox.getTextControl()).getText();
        JfaceCMenuList tempList = (JfaceCMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("driver-class");
        this.driverClass = tempList.getValue();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("command-line-arguments");
        this.sConf.cmdLineArgs = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-key-class");
        this.aConf.outputKeyClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-value-class");
        this.aConf.outputValueClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-mapper-class");
        this.aConf.mapperClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-reducer-class");
        this.aConf.reducerClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
        this.aConf.inputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
        this.aConf.outputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
        this.aConf.inputFormatClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
        this.aConf.outputFormatClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
        this.aConf.numMapTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
        this.aConf.numReduceTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
        this.aConf.loggingInterval = ((Text)tempBox.getTextControl()).getText();
        JfaceMenuList ncBox = (JfaceMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("named-clusters");
        if (!this.isSimple() && this.aConf.selectedNamedCluster != null && (reload = this.namedClusterService.getNamedClusterByName(this.aConf.selectedNamedCluster.getName(), this.jobMeta.getMetaStore())) != null) {
            this.aConf.selectedNamedCluster = reload;
        }
        String validationErrors = "";
        if (StringUtil.isEmpty((String)this.jobEntryName)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.JobEntryName.Error", (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.hadoopJobName)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"JobEntryHadoopJobExecutor.HadoopJobName.Error", (String[])new String[0]) + "\n";
        }
        if (!StringUtil.isEmpty((String)validationErrors)) {
            this.openErrorDialog(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), validationErrors);
            return;
        }
        this.jobEntry.setName(this.jobEntryName);
        this.jobEntry.setHadoopJobName(this.hadoopJobName);
        this.jobEntry.setSimple(this.isSimple);
        this.jobEntry.setJarUrl(this.jarUrl);
        this.jobEntry.setDriverClass(this.driverClass);
        this.jobEntry.setCmdLineArgs(this.sConf.getCommandLineArgs());
        this.jobEntry.setSimpleBlocking(this.sConf.isSimpleBlocking());
        this.jobEntry.setSimpleLoggingInterval(this.sConf.getSimpleLoggingInterval());
        this.jobEntry.setBlocking(this.aConf.isBlocking());
        this.jobEntry.setLoggingInterval(this.aConf.getLoggingInterval());
        this.jobEntry.setMapperClass(this.aConf.getMapperClass());
        this.jobEntry.setCombinerClass(this.aConf.getCombinerClass());
        this.jobEntry.setReducerClass(this.aConf.getReducerClass());
        this.jobEntry.setInputPath(this.aConf.getInputPath());
        this.jobEntry.setInputFormatClass(this.aConf.getInputFormatClass());
        this.jobEntry.setOutputPath(this.aConf.getOutputPath());
        this.jobEntry.setOutputKeyClass(this.aConf.getOutputKeyClass());
        this.jobEntry.setOutputValueClass(this.aConf.getOutputValueClass());
        this.jobEntry.setOutputFormatClass(this.aConf.getOutputFormatClass());
        this.jobEntry.setNamedCluster(this.aConf.selectedNamedCluster);
        this.jobEntry.setNumMapTasks(this.aConf.getNumMapTasks());
        this.jobEntry.setNumReduceTasks(this.aConf.getNumReduceTasks());
        this.jobEntry.setUserDefined((List<UserDefinedItem>)this.userDefined);
        this.jobEntry.setChanged();
        this.cancel();
    }

    public void init() throws XulDomException {
        if (this.jobEntry != null) {
            this.setName(this.jobEntry.getName());
            this.setJobEntryName(this.jobEntry.getName());
            this.setHadoopJobName(this.jobEntry.getHadoopJobName());
            this.setSimple(this.jobEntry.isSimple());
            this.setJarUrl(this.jobEntry.getJarUrl());
            this.populateDriverMenuList();
            this.setDriverClass(this.jobEntry.getDriverClass());
            this.sConf.setCommandLineArgs(this.jobEntry.getCmdLineArgs());
            this.sConf.setSimpleBlocking(this.jobEntry.isSimpleBlocking());
            this.sConf.setSimpleLoggingInterval(this.jobEntry.getSimpleLoggingInterval());
            this.userDefined.clear();
            if (this.jobEntry.getUserDefined() != null) {
                this.userDefined.addAll(this.jobEntry.getUserDefined());
            }
            VariableSpace varSpace = this.getVariableSpace();
            ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jar-url");
            tempBox.setVariableSpace(varSpace);
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("command-line-arguments");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-key-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-value-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-mapper-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-combiner-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-reducer-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("simple-logging-interval");
            tempBox.setVariableSpace(varSpace);
            this.aConf.setBlocking(this.jobEntry.isBlocking());
            this.aConf.setLoggingInterval(this.jobEntry.getLoggingInterval());
            this.aConf.setMapperClass(this.jobEntry.getMapperClass());
            this.aConf.setCombinerClass(this.jobEntry.getCombinerClass());
            this.aConf.setReducerClass(this.jobEntry.getReducerClass());
            this.aConf.setInputPath(this.jobEntry.getInputPath());
            this.aConf.setInputFormatClass(this.jobEntry.getInputFormatClass());
            this.aConf.setOutputPath(this.jobEntry.getOutputPath());
            this.aConf.setOutputKeyClass(this.jobEntry.getOutputKeyClass());
            this.aConf.setOutputValueClass(this.jobEntry.getOutputValueClass());
            this.aConf.setOutputFormatClass(this.jobEntry.getOutputFormatClass());
            this.aConf.setSelectedNamedCluster(this.jobEntry.getNamedCluster());
            this.aConf.setNumMapTasks(this.jobEntry.getNumMapTasks());
            this.aConf.setNumReduceTasks(this.jobEntry.getNumReduceTasks());
        }
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public void cancel() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public void browseJar() {
        String fname;
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
        Shell shell = (Shell)xulDialog.getRootObject();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterNames(new String[]{"Java Archives (jar)"});
        String prevName = this.jobEntry.environmentSubstitute(this.jarUrl);
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.jobEntry.environmentSubstitute(this.jobEntry.getFilename())).getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Const.isEmpty((String)prevName)) {
            try {
                if (KettleVFS.fileExists((String)prevName)) {
                    dialog.setFilterPath(KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)prevName).getParent()));
                } else {
                    if (!prevName.endsWith(".jar") && !prevName.endsWith(".zip")) {
                        prevName = "${Internal.Job.Filename.Directory}/" + Const.trim((String)this.jarUrl) + ".jar";
                    }
                    if (KettleVFS.fileExists((String)prevName)) {
                        this.setJarUrl(prevName);
                        return;
                    }
                }
            }
            catch (Exception e) {
                dialog.setFilterPath(parentFolder);
            }
        } else if (!Const.isEmpty(parentFolder)) {
            dialog.setFilterPath(parentFolder);
        }
        if ((fname = dialog.open()) != null) {
            File file = new File(fname);
            String name = file.getName();
            String parentFolderSelection = file.getParentFile().toString();
            if (!Const.isEmpty((String)parentFolder) && parentFolder.equals(parentFolderSelection)) {
                this.setJarUrl("${Internal.Job.Filename.Directory}/" + name);
            } else {
                this.setJarUrl(fname);
            }
            this.populateDriverMenuList();
        }
    }

    public void newUserDefinedItem() {
        this.userDefined.add((Object)new UserDefinedItem());
    }

    public SimpleConfiguration getSimpleConfiguration() {
        return this.sConf;
    }

    public AdvancedConfiguration getAdvancedConfiguration() {
        return this.aConf;
    }

    public AbstractModelList<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public String getName() {
        return "jobEntryController";
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        String previousVal = this.jobEntryName;
        String newVal = jobEntryName;
        this.jobEntryName = jobEntryName;
        this.firePropertyChange(JOB_ENTRY_NAME, previousVal, newVal);
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        String previousVal = this.hadoopJobName;
        String newVal = hadoopJobName;
        this.hadoopJobName = hadoopJobName;
        this.firePropertyChange(HADOOP_JOB_NAME, previousVal, newVal);
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        String previousVal = this.jarUrl;
        String newVal = jarUrl;
        this.jarUrl = jarUrl;
        this.firePropertyChange(JAR_URL, previousVal, newVal);
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        String previousVal = this.driverClass;
        String newVal = driverClass;
        this.driverClass = driverClass;
        this.firePropertyChange(DRIVER_CLASS, previousVal, newVal);
    }

    public List<String> getDriverClasses() {
        return this.driverClasses;
    }

    public void setDriverClasses(List<String> driverClasses) {
        List<String> previousVal = this.driverClasses;
        List<String> newVal = driverClasses;
        this.driverClasses = driverClasses;
        this.firePropertyChange(DRIVER_CLASSES, previousVal, newVal);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        ((XulVbox)this.getXulDomContainer().getDocumentRoot().getElementById("advanced-configuration")).setVisible(!isSimple);
        ((XulVbox)this.getXulDomContainer().getDocumentRoot().getElementById("simple-configuration")).setVisible(isSimple);
        boolean previousVal = this.isSimple;
        boolean newVal = isSimple;
        this.isSimple = isSimple;
        this.firePropertyChange(IS_SIMPLE, previousVal, newVal);
    }

    public void invertSimpleBlocking() {
        this.sConf.setSimpleBlocking(!this.sConf.isSimpleBlocking());
    }

    public void invertBlocking() {
        this.aConf.setBlocking(!this.aConf.isBlocking());
    }

    public JobEntryHadoopJobExecutor getJobEntry() {
        return this.jobEntry;
    }

    public void setJobEntry(JobEntryHadoopJobExecutor jobEntry) {
        this.jobEntry = jobEntry;
    }

    public List<NamedCluster> getNamedClusters() throws MetaStoreException {
        return this.namedClusterService.list(this.jobMeta.getMetaStore());
    }

    public void openErrorDialog(String title, String message) {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-dialog");
        errorDialog.setTitle(title);
        XulTextbox errorMessage = (XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-message");
        errorMessage.setValue(message);
        errorDialog.show();
    }

    public void closeErrorDialog() {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("hadoop-error-dialog");
        errorDialog.hide();
    }

    public void editNamedCluster() {
        try {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
            Shell shell = (Shell)xulDialog.getRootObject();
            NamedCluster namedCluster = this.aConf.isSelectedNamedCluster() ? this.aConf.selectedNamedCluster : this.namedClusterService.getClusterTemplate();
            String clusterName = this.ncDelegate.editNamedCluster(null, namedCluster, shell);
            if (clusterName != null) {
                this.firePropertyChange("namedClusters", namedCluster, this.getNamedClusters());
                this.selectNamedCluster(clusterName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void newNamedCluster() {
        try {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById("job-entry-dialog");
            Shell shell = (Shell)xulDialog.getRootObject();
            String newClusterName = this.ncDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, shell);
            if (newClusterName != null) {
                this.firePropertyChange("namedClusters", null, this.getNamedClusters());
                this.selectNamedCluster(newClusterName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void selectNamedCluster(String clusterName) throws MetaStoreException {
        XulMenuList namedClusterMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("named-clusters");
        for (NamedCluster nc : this.getNamedClusters()) {
            if (clusterName == null || !clusterName.equals(nc.getName())) continue;
            namedClusterMenu.setSelectedItem((Object)nc);
            this.aConf.setSelectedNamedCluster(nc);
        }
    }

    public void help() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement().getFirstChild();
        Shell shell = (Shell)xulDialog.getRootObject();
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.jobEntry.getPluginId());
        HelpUtils.openHelpDialog((Shell)shell, (PluginInterface)plugin);
    }

    private void populateDriverMenuList() {
        if (Const.isEmpty((String)this.jarUrl)) {
            return;
        }
        try {
            MapReduceJarInfo mapReduceJarInfo = ((MapReduceService)this.namedClusterServiceLocator.getService(this.aConf.selectedNamedCluster, MapReduceService.class)).getJarInfo(JobEntryHadoopJobExecutor.resolveJarUrl(this.jarUrl, this.getVariableSpace()));
            ArrayList<String> driverClasses = new ArrayList<String>(mapReduceJarInfo.getClassesWithMain());
            if (Const.isEmpty((String)this.driverClass)) {
                this.setDriverClasses(driverClasses);
                String mainClass = mapReduceJarInfo.getMainClass();
                if (mainClass != null) {
                    this.setDriverClass(mainClass);
                } else if (!driverClasses.isEmpty()) {
                    this.setDriverClass((String)driverClasses.get(0));
                }
            } else {
                String saveDriverClass = this.driverClass;
                this.setDriverClasses(driverClasses);
                this.setDriverClass(saveDriverClass);
            }
        }
        catch (Throwable e) {
            try {
                XulRoot xulDialog = (XulRoot)this.getXulDomContainer().getDocumentRoot().getRootElement();
                Shell shell = (Shell)xulDialog.getRootObject();
                new ErrorDialog(shell, "Error", "Unable to populate Driver Class list", e);
                this.setDriverClasses(Collections.emptyList());
            }
            catch (Throwable e2) {
                this.jobEntry.logError("Unable to construct error dialog for exception.", e);
            }
        }
    }

    public class AdvancedConfiguration
    extends XulEventSourceAdapter {
        public static final String OUTPUT_KEY_CLASS = "outputKeyClass";
        public static final String OUTPUT_VALUE_CLASS = "outputValueClass";
        public static final String MAPPER_CLASS = "mapperClass";
        public static final String COMBINER_CLASS = "combinerClass";
        public static final String REDUCER_CLASS = "reducerClass";
        public static final String INPUT_FORMAT_CLASS = "inputFormatClass";
        public static final String OUTPUT_FORMAT_CLASS = "outputFormatClass";
        public static final String INPUT_PATH = "inputPath";
        public static final String OUTPUT_PATH = "outputPath";
        public static final String BLOCKING = "blocking";
        public static final String LOGGING_INTERVAL = "loggingInterval";
        public static final String HDFS_HOSTNAME = "hdfsHostname";
        public static final String HDFS_PORT = "hdfsPort";
        public static final String JOB_TRACKER_HOSTNAME = "jobTrackerHostname";
        public static final String JOB_TRACKER_PORT = "jobTrackerPort";
        public static final String NUM_MAP_TASKS = "numMapTasks";
        public static final String NUM_REDUCE_TASKS = "numReduceTasks";
        private String outputKeyClass;
        private String outputValueClass;
        private String mapperClass;
        private String combinerClass;
        private String reducerClass;
        private String inputFormatClass;
        private String outputFormatClass;
        private NamedCluster selectedNamedCluster;
        private String inputPath;
        private String outputPath;
        private String numMapTasks = "1";
        private String numReduceTasks = "1";
        private boolean blocking;
        private String loggingInterval = "60";

        public String getOutputKeyClass() {
            return this.outputKeyClass;
        }

        public void setOutputKeyClass(String outputKeyClass) {
            String previousVal = this.outputKeyClass;
            String newVal = outputKeyClass;
            this.outputKeyClass = outputKeyClass;
            this.firePropertyChange(OUTPUT_KEY_CLASS, previousVal, newVal);
        }

        public String getOutputValueClass() {
            return this.outputValueClass;
        }

        public void setOutputValueClass(String outputValueClass) {
            String previousVal = this.outputValueClass;
            String newVal = outputValueClass;
            this.outputValueClass = outputValueClass;
            this.firePropertyChange(OUTPUT_VALUE_CLASS, previousVal, newVal);
        }

        public String getMapperClass() {
            return this.mapperClass;
        }

        public void setMapperClass(String mapperClass) {
            String previousVal = this.mapperClass;
            String newVal = mapperClass;
            this.mapperClass = mapperClass;
            this.firePropertyChange(MAPPER_CLASS, previousVal, newVal);
        }

        public String getCombinerClass() {
            return this.combinerClass;
        }

        public void setCombinerClass(String combinerClass) {
            String previousVal = this.combinerClass;
            String newVal = combinerClass;
            this.combinerClass = combinerClass;
            this.firePropertyChange(COMBINER_CLASS, previousVal, newVal);
        }

        public String getReducerClass() {
            return this.reducerClass;
        }

        public void setReducerClass(String reducerClass) {
            String previousVal = this.reducerClass;
            String newVal = reducerClass;
            this.reducerClass = reducerClass;
            this.firePropertyChange(REDUCER_CLASS, previousVal, newVal);
        }

        public String getInputFormatClass() {
            return this.inputFormatClass;
        }

        public void setInputFormatClass(String inputFormatClass) {
            String previousVal = this.inputFormatClass;
            String newVal = inputFormatClass;
            this.inputFormatClass = inputFormatClass;
            this.firePropertyChange(INPUT_FORMAT_CLASS, previousVal, newVal);
        }

        public String getOutputFormatClass() {
            return this.outputFormatClass;
        }

        public void setOutputFormatClass(String outputFormatClass) {
            String previousVal = this.outputFormatClass;
            String newVal = outputFormatClass;
            this.outputFormatClass = outputFormatClass;
            this.firePropertyChange(OUTPUT_FORMAT_CLASS, previousVal, newVal);
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public void setInputPath(String inputPath) {
            String previousVal = this.inputPath;
            String newVal = inputPath;
            this.inputPath = inputPath;
            this.firePropertyChange(INPUT_PATH, previousVal, newVal);
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public void setOutputPath(String outputPath) {
            String previousVal = this.outputPath;
            String newVal = outputPath;
            this.outputPath = outputPath;
            this.firePropertyChange(OUTPUT_PATH, previousVal, newVal);
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public void setBlocking(boolean blocking) {
            boolean previousVal = this.blocking;
            boolean newVal = blocking;
            this.blocking = blocking;
            this.firePropertyChange(BLOCKING, previousVal, newVal);
        }

        public String getLoggingInterval() {
            return this.loggingInterval;
        }

        public void setLoggingInterval(String loggingInterval) {
            String previousVal = this.loggingInterval;
            String newVal = loggingInterval;
            this.loggingInterval = loggingInterval;
            this.firePropertyChange(LOGGING_INTERVAL, previousVal, newVal);
        }

        public String getNumMapTasks() {
            return this.numMapTasks;
        }

        public void setNumMapTasks(String numMapTasks) {
            String previousVal = this.numMapTasks;
            String newVal = numMapTasks;
            this.numMapTasks = numMapTasks;
            this.firePropertyChange(NUM_MAP_TASKS, previousVal, newVal);
        }

        public String getNumReduceTasks() {
            return this.numReduceTasks;
        }

        public void setNumReduceTasks(String numReduceTasks) {
            String previousVal = this.numReduceTasks;
            String newVal = numReduceTasks;
            this.numReduceTasks = numReduceTasks;
            this.firePropertyChange(NUM_REDUCE_TASKS, previousVal, newVal);
        }

        public boolean isSelectedNamedCluster() {
            return this.selectedNamedCluster != null;
        }

        public void setSelectedNamedCluster(NamedCluster namedCluster) {
            this.selectedNamedCluster = namedCluster;
        }
    }

    public class SimpleConfiguration
    extends XulEventSourceAdapter {
        public static final String CMD_LINE_ARGS = "commandLineArgs";
        public static final String BLOCKING = "simpleBlocking";
        public static final String LOGGING_INTERVAL = "simpleLoggingInterval";
        private String cmdLineArgs;
        private boolean simpleBlocking;
        private String simpleLoggingInterval = "60";

        public String getCommandLineArgs() {
            return this.cmdLineArgs;
        }

        public void setCommandLineArgs(String cmdLineArgs) {
            String previousVal = this.cmdLineArgs;
            String newVal = cmdLineArgs;
            this.cmdLineArgs = cmdLineArgs;
            this.firePropertyChange(CMD_LINE_ARGS, previousVal, newVal);
        }

        public boolean isSimpleBlocking() {
            return this.simpleBlocking;
        }

        public void setSimpleBlocking(boolean simpleBlocking) {
            boolean old = this.simpleBlocking;
            this.simpleBlocking = simpleBlocking;
            this.firePropertyChange(BLOCKING, old, this.simpleBlocking);
        }

        public String getSimpleLoggingInterval() {
            return this.simpleLoggingInterval;
        }

        public void setSimpleLoggingInterval(String simpleLoggingInterval) {
            String old = this.simpleLoggingInterval;
            this.simpleLoggingInterval = simpleLoggingInterval;
            this.firePropertyChange(LOGGING_INTERVAL, old, this.simpleLoggingInterval);
        }
    }
}

