/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBootstrapActionsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Command> bootstrapActions;
    private String marker;

    public List<Command> getBootstrapActions() {
        if (this.bootstrapActions == null) {
            this.bootstrapActions = new ListWithAutoConstructFlag();
            this.bootstrapActions.setAutoConstruct(true);
        }
        return this.bootstrapActions;
    }

    public void setBootstrapActions(Collection<Command> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
            return;
        }
        ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
        bootstrapActionsCopy.addAll(bootstrapActions);
        this.bootstrapActions = bootstrapActionsCopy;
    }

    public ListBootstrapActionsResult withBootstrapActions(Command ... bootstrapActions) {
        if (this.getBootstrapActions() == null) {
            this.setBootstrapActions(new ArrayList<Command>(bootstrapActions.length));
        }
        for (Command value : bootstrapActions) {
            this.getBootstrapActions().add(value);
        }
        return this;
    }

    public ListBootstrapActionsResult withBootstrapActions(Collection<Command> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
        } else {
            ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
            bootstrapActionsCopy.addAll(bootstrapActions);
            this.bootstrapActions = bootstrapActionsCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListBootstrapActionsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBootstrapActions() != null) {
            sb.append("BootstrapActions: " + this.getBootstrapActions() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBootstrapActions() == null ? 0 : this.getBootstrapActions().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBootstrapActionsResult)) {
            return false;
        }
        ListBootstrapActionsResult other = (ListBootstrapActionsResult)obj;
        if (other.getBootstrapActions() == null ^ this.getBootstrapActions() == null) {
            return false;
        }
        if (other.getBootstrapActions() != null && !other.getBootstrapActions().equals(this.getBootstrapActions())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListBootstrapActionsResult clone() {
        try {
            return (ListBootstrapActionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

