/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorAction;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorActionException;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Log LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    HAServiceProtocol.HAServiceState state;
    final BPOfferService bpos;
    volatile long lastCacheReport = 0L;
    private final Scheduler scheduler;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private volatile RunningState runningState = RunningState.CONNECTING;
    private final Map<DatanodeStorage, PerStoragePendingIncrementalBR> pendingIncrementalBRperStorage = Maps.newHashMap();
    private volatile boolean sendImmediateIBR = false;
    private volatile boolean shouldServiceRun = true;
    private final DataNode dn;
    private final DNConf dnConf;
    private DatanodeRegistration bpRegistration;
    final LinkedList<BPServiceActorAction> bpThreadQueue = new LinkedList();
    private long prevBlockReportId = 0L;

    BPServiceActor(InetSocketAddress nnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.dnConf = this.dn.getDnConf();
        this.scheduler = new Scheduler(this.dnConf.heartBeatInterval, this.dnConf.blockReportInterval);
    }

    boolean isAlive() {
        if (!this.shouldServiceRun || !this.bpThread.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING || this.runningState == RunningState.CONNECTING;
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug((Object)(this + " received versionRequest response: " + nsInfo));
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            catch (IOException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)nnVersion, (String)(minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion())) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn((Object)ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info((Object)("Reported NameNode version '" + nnVersion + "' does not match " + "DataNode version '" + dnVersion + "' but is within acceptable " + "limits. Note: This is normal during a rolling upgrade."));
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.bpos.verifyAndSetNamespaceInfo(nsInfo);
        this.register(nsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportReceivedDeletedBlocks() throws IOException {
        ArrayList<StorageReceivedDeletedBlocks> reports = new ArrayList<StorageReceivedDeletedBlocks>(this.pendingIncrementalBRperStorage.size());
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            for (Map.Entry<DatanodeStorage, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
                DatanodeStorage storage = entry.getKey();
                PerStoragePendingIncrementalBR perStorageMap = entry.getValue();
                if (perStorageMap.getBlockInfoCount() <= 0) continue;
                ReceivedDeletedBlockInfo[] rdbi = perStorageMap.dequeueBlockInfos();
                reports.add(new StorageReceivedDeletedBlocks(storage, rdbi));
            }
            this.sendImmediateIBR = false;
        }
        if (reports.size() == 0) {
            return;
        }
        boolean success = false;
        long startTime = Time.monotonicNow();
        try {
            this.bpNamenode.blockReceivedAndDeleted(this.bpRegistration, this.bpos.getBlockPoolId(), reports.toArray(new StorageReceivedDeletedBlocks[reports.size()]));
            success = true;
        }
        finally {
            this.dn.getMetrics().addIncrementalBlockReport(Time.monotonicNow() - startTime);
            if (!success) {
                Map<DatanodeStorage, PerStoragePendingIncrementalBR> map2 = this.pendingIncrementalBRperStorage;
                synchronized (map2) {
                    for (StorageReceivedDeletedBlocks report : reports) {
                        PerStoragePendingIncrementalBR perStorageMap = this.pendingIncrementalBRperStorage.get(report.getStorage());
                        perStorageMap.putMissingBlockInfos(report.getBlocks());
                        this.sendImmediateIBR = true;
                    }
                }
            }
        }
    }

    private PerStoragePendingIncrementalBR getIncrementalBRMapForStorage(DatanodeStorage storage) {
        PerStoragePendingIncrementalBR mapForStorage = this.pendingIncrementalBRperStorage.get(storage);
        if (mapForStorage == null) {
            mapForStorage = new PerStoragePendingIncrementalBR();
            this.pendingIncrementalBRperStorage.put(storage, mapForStorage);
        }
        return mapForStorage;
    }

    void addPendingReplicationBlockInfo(ReceivedDeletedBlockInfo bInfo, DatanodeStorage storage) {
        for (Map.Entry<DatanodeStorage, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
            if (entry.getValue().removeBlockInfo(bInfo)) break;
        }
        this.getIncrementalBRMapForStorage(storage).putBlockInfo(bInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeBlock(ReceivedDeletedBlockInfo bInfo, String storageUuid, boolean now) {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, this.dn.getFSDataset().getStorage(storageUuid));
            this.sendImmediateIBR = true;
            if (now) {
                this.pendingIncrementalBRperStorage.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeDeletedBlock(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, this.dn.getFSDataset().getStorage(storageUuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerBlockReportForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.scheduler.scheduleHeartbeat();
            long oldBlockReportTime = this.scheduler.nextBlockReportTime;
            this.scheduler.forceFullBlockReportNow();
            this.pendingIncrementalBRperStorage.notifyAll();
            while (oldBlockReportTime == this.scheduler.nextBlockReportTime) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerHeartbeatForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            long nextHeartbeatTime = this.scheduler.scheduleHeartbeat();
            this.pendingIncrementalBRperStorage.notifyAll();
            while (nextHeartbeatTime - this.scheduler.nextHeartbeatTime >= 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerDeletionReportForTests() {
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.sendImmediateIBR = true;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.sendImmediateIBR) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    boolean hasPendingIBR() {
        return this.sendImmediateIBR;
    }

    private long generateUniqueBlockReportId() {
        long id = System.nanoTime();
        if (id <= this.prevBlockReportId) {
            id = this.prevBlockReportId + 1L;
        }
        this.prevBlockReportId = id;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DatanodeCommand> blockReport(long fullBrLeaseId) throws IOException {
        ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
        this.reportReceivedDeletedBlocks();
        long brCreateStartTime = Time.monotonicNow();
        Map<DatanodeStorage, BlockListAsLongs> perVolumeBlockLists = this.dn.getFSDataset().getBlockReports(this.bpos.getBlockPoolId());
        int i = 0;
        int totalBlockCount = 0;
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> kvPair : perVolumeBlockLists.entrySet()) {
            BlockListAsLongs blockList = kvPair.getValue();
            reports[i++] = new StorageBlockReport(kvPair.getKey(), blockList);
            totalBlockCount += blockList.getNumberOfBlocks();
        }
        int numReportsSent = 0;
        int numRPCs = 0;
        boolean success = false;
        long brSendStartTime = Time.monotonicNow();
        long reportId = this.generateUniqueBlockReportId();
        try {
            if ((long)totalBlockCount < this.dnConf.blockReportSplitThreshold) {
                DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), reports, new BlockReportContext(1, 0, reportId, fullBrLeaseId));
                numRPCs = 1;
                numReportsSent = reports.length;
                if (cmd != null) {
                    cmds.add(cmd);
                }
            } else {
                for (int r = 0; r < reports.length; ++r) {
                    StorageBlockReport[] singleReport = new StorageBlockReport[]{reports[r]};
                    DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), singleReport, new BlockReportContext(reports.length, r, reportId, fullBrLeaseId));
                    ++numReportsSent;
                    ++numRPCs;
                    if (cmd == null) continue;
                    cmds.add(cmd);
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            long brSendCost = Time.monotonicNow() - brSendStartTime;
            long brCreateCost = brSendStartTime - brCreateStartTime;
            this.dn.getMetrics().addBlockReport(brSendCost);
            int nCmds = cmds.size();
            LOG.info((Object)((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + "." + " The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing." + " Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on((String)"; ").join(cmds))) + "."));
            throw throwable;
        }
        long brSendCost = Time.monotonicNow() - brSendStartTime;
        long brCreateCost = brSendStartTime - brCreateStartTime;
        this.dn.getMetrics().addBlockReport(brSendCost);
        int nCmds = cmds.size();
        LOG.info((Object)((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + "." + " The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing." + " Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on((String)"; ").join(cmds))) + "."));
        this.scheduler.scheduleNextBlockReport();
        return cmds.size() == 0 ? null : cmds;
    }

    DatanodeCommand cacheReport() throws IOException {
        if (this.dn.getFSDataset().getCacheCapacity() == 0L) {
            return null;
        }
        DatanodeCommand cmd = null;
        long startTime = Time.monotonicNow();
        if (startTime - this.lastCacheReport > this.dnConf.cacheReportInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending cacheReport from service actor: " + this));
            }
            this.lastCacheReport = startTime;
            String bpid = this.bpos.getBlockPoolId();
            List<Long> blockIds = this.dn.getFSDataset().getCacheReport(bpid);
            long createTime = Time.monotonicNow();
            cmd = this.bpNamenode.cacheReport(this.bpRegistration, bpid, blockIds);
            long sendTime = Time.monotonicNow();
            long createCost = createTime - startTime;
            long sendCost = sendTime - createTime;
            this.dn.getMetrics().addCacheReport(sendCost);
            LOG.debug((Object)("CacheReport of " + blockIds.size() + " block(s) took " + createCost + " msec to generate and " + sendCost + " msecs for RPC and NN processing"));
        }
        return cmd;
    }

    HeartbeatResponse sendHeartBeat(boolean requestBlockReportLease) throws IOException {
        VolumeFailureSummary volumeFailureSummary;
        this.scheduler.scheduleNextHeartbeat();
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this));
        }
        int numFailedVolumes = (volumeFailureSummary = this.dn.getFSDataset().getVolumeFailureSummary()) != null ? volumeFailureSummary.getFailedStorageLocations().length : 0;
        return this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getXceiverCount(), numFailedVolumes, volumeFailureSummary, requestBlockReportLease);
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread((Runnable)this, this.formatThreadName());
        this.bpThread.setDaemon(true);
        this.bpThread.start();
    }

    private String formatThreadName() {
        List<StorageLocation> dataDirs = DataNode.getStorageLocations(this.dn.getConf());
        return "DataNode: [" + dataDirs.toString() + "] " + " heartbeating to " + this.nnAddr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.bpNamenode});
        this.bpos.shutdownActor(this);
    }

    private void handleRollingUpgradeStatus(HeartbeatResponse resp) throws IOException {
        RollingUpgradeStatus rollingUpgradeStatus = resp.getRollingUpdateStatus();
        if (rollingUpgradeStatus != null && rollingUpgradeStatus.getBlockPoolId().compareTo(this.bpos.getBlockPoolId()) != 0) {
            LOG.error((Object)("Invalid BlockPoolId " + rollingUpgradeStatus.getBlockPoolId() + " in HeartbeatResponse. Expected " + this.bpos.getBlockPoolId()));
        } else {
            this.bpos.signalRollingUpgrade(rollingUpgradeStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerService() throws Exception {
        LOG.info((Object)("For namenode " + this.nnAddr + " using" + " BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msec" + " CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msec" + " Initial delay: " + this.dnConf.initialBlockReportDelayMs + "msec" + "; heartBeatInterval=" + this.dnConf.heartBeatInterval));
        long fullBlockReportLeaseId = 0L;
        while (this.shouldRun()) {
            try {
                long startTime = this.scheduler.monotonicNow();
                boolean sendHeartbeat = this.scheduler.isHeartbeatDue(startTime);
                HeartbeatResponse resp = null;
                if (sendHeartbeat) {
                    boolean requestBlockReportLease;
                    boolean bl = requestBlockReportLease = fullBlockReportLeaseId == 0L && this.scheduler.isBlockReportDue(startTime);
                    if (!this.dn.areHeartbeatsDisabledForTests()) {
                        resp = this.sendHeartBeat(requestBlockReportLease);
                        assert (resp != null);
                        if (resp.getFullBlockReportLeaseId() != 0L) {
                            if (fullBlockReportLeaseId != 0L) {
                                LOG.warn((Object)(this.nnAddr + " sent back a full block report lease " + "ID of 0x" + Long.toHexString(resp.getFullBlockReportLeaseId()) + ", but we already have a lease ID of 0x" + Long.toHexString(fullBlockReportLeaseId) + ". " + "Overwriting old lease ID."));
                            }
                            fullBlockReportLeaseId = resp.getFullBlockReportLeaseId();
                        }
                        this.dn.getMetrics().addHeartbeat(this.scheduler.monotonicNow() - startTime);
                        this.bpos.updateActorStatesFromHeartbeat(this, resp.getNameNodeHaState());
                        this.state = resp.getNameNodeHaState().getState();
                        if (this.state == HAServiceProtocol.HAServiceState.ACTIVE) {
                            this.handleRollingUpgradeStatus(resp);
                        }
                        long startProcessCommands = Time.monotonicNow();
                        if (!this.processCommand(resp.getCommands())) continue;
                        long endProcessCommands = Time.monotonicNow();
                        if (endProcessCommands - startProcessCommands > 2000L) {
                            LOG.info((Object)("Took " + (endProcessCommands - startProcessCommands) + "ms to process " + resp.getCommands().length + " commands from NN"));
                        }
                    }
                }
                if (this.sendImmediateIBR || sendHeartbeat) {
                    this.reportReceivedDeletedBlocks();
                }
                List<DatanodeCommand> cmds = null;
                boolean forceFullBr = this.scheduler.forceFullBlockReport.getAndSet(false);
                if (forceFullBr) {
                    LOG.info((Object)("Forcing a full block report to " + this.nnAddr));
                }
                if (fullBlockReportLeaseId != 0L || forceFullBr) {
                    cmds = this.blockReport(fullBlockReportLeaseId);
                    fullBlockReportLeaseId = 0L;
                }
                this.processCommand(cmds == null ? null : cmds.toArray(new DatanodeCommand[cmds.size()]));
                DatanodeCommand cmd = this.cacheReport();
                this.processCommand(new DatanodeCommand[]{cmd});
                long waitTime = this.scheduler.getHeartbeatWaitTime();
                Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
                synchronized (map) {
                    if (waitTime > 0L && !this.sendImmediateIBR) {
                        try {
                            this.pendingIncrementalBRperStorage.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)("BPOfferService for " + this + " interrupted"));
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)(this + " is shutting down"), (Throwable)re);
                    this.shouldServiceRun = false;
                    return;
                }
                LOG.warn((Object)"RemoteException in offerService", (Throwable)re);
                try {
                    long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in offerService", (Throwable)e);
            }
            this.processQueueMessages();
        }
    }

    void register(NamespaceInfo nsInfo) throws IOException {
        DatanodeRegistration newBpRegistration = this.bpos.createRegistration();
        LOG.info((Object)(this + " beginning handshake with NN"));
        while (this.shouldRun()) {
            try {
                newBpRegistration = this.bpNamenode.registerDatanode(newBpRegistration);
                newBpRegistration.setNamespaceInfo(nsInfo);
                this.bpRegistration = newBpRegistration;
                break;
            }
            catch (EOFException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr + " :" + e.getLocalizedMessage()));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
        }
        LOG.info((Object)("Block pool " + this + " successfully registered with NN"));
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.scheduler.scheduleBlockReport(this.dnConf.initialBlockReportDelayMs);
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)("BPOfferService " + this + " interrupted while " + stateString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.info((Object)(this + " starting to offer service"));
        try {
            while (true) {
                try {
                    this.connectToNNAndHandshake();
                }
                catch (IOException ioe) {
                    this.runningState = RunningState.INIT_FAILED;
                    if (!this.shouldRetryInit()) {
                        this.runningState = RunningState.FAILED;
                        LOG.fatal((Object)("Initialization failed for " + this + ". Exiting. "), (Throwable)ioe);
                        LOG.warn((Object)("Ending block pool service for: " + this));
                        this.cleanUp();
                        return;
                    }
                    LOG.error((Object)("Initialization failed for " + this + " " + ioe.getLocalizedMessage()));
                    this.sleepAndLogInterrupts(5000, "initializing");
                    continue;
                }
                break;
            }
            this.runningState = RunningState.RUNNING;
        }
        catch (Throwable ex) {
            LOG.warn((Object)("Unexpected exception in block pool " + this), ex);
            this.runningState = RunningState.FAILED;
            return;
        }
        finally {
            LOG.warn((Object)("Ending block pool service for: " + this));
            this.cleanUp();
        }
        while (true) {
            if (!this.shouldRun()) {
                this.runningState = RunningState.EXITED;
                return;
            }
            try {
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception in BPOfferService for " + this), (Throwable)ex);
                this.sleepAndLogInterrupts(5000, "offering service");
                continue;
            }
            break;
        }
    }

    private boolean shouldRetryInit() {
        return this.shouldRun() && this.bpos.shouldRetryInit();
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.bpos.processCommandFromActor(cmd, this)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
            this.register(nsInfo);
            this.scheduler.scheduleHeartbeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerBlockReport(BlockReportOptions options) throws IOException {
        if (options.isIncremental()) {
            LOG.info((Object)(this.bpos.toString() + ": scheduling an incremental block report."));
            Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
            synchronized (map) {
                this.sendImmediateIBR = true;
                this.pendingIncrementalBRperStorage.notifyAll();
            }
        }
        LOG.info((Object)(this.bpos.toString() + ": scheduling a full block report."));
        Map<DatanodeStorage, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.scheduler.forceFullBlockReportNow();
            this.pendingIncrementalBRperStorage.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bpThreadEnqueue(BPServiceActorAction action) {
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            if (!this.bpThreadQueue.contains(action)) {
                this.bpThreadQueue.add(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueueMessages() {
        LinkedList<BPServiceActorAction> duplicateQueue;
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            duplicateQueue = new LinkedList<BPServiceActorAction>(this.bpThreadQueue);
            this.bpThreadQueue.clear();
        }
        while (!duplicateQueue.isEmpty()) {
            BPServiceActorAction actionItem = duplicateQueue.remove();
            try {
                actionItem.reportTo(this.bpNamenode, this.bpRegistration);
            }
            catch (BPServiceActorActionException baae) {
                LOG.warn((Object)(baae.getMessage() + this.nnAddr), (Throwable)baae);
                this.bpThreadEnqueue(actionItem);
            }
        }
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    static class Scheduler {
        @VisibleForTesting
        volatile long nextBlockReportTime = this.monotonicNow();
        @VisibleForTesting
        volatile long nextHeartbeatTime = this.monotonicNow();
        @VisibleForTesting
        boolean resetBlockReportTime = true;
        private final AtomicBoolean forceFullBlockReport = new AtomicBoolean(false);
        private final long heartbeatIntervalMs;
        private final long blockReportIntervalMs;

        Scheduler(long heartbeatIntervalMs, long blockReportIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.blockReportIntervalMs = blockReportIntervalMs;
        }

        long scheduleHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow();
            return this.nextHeartbeatTime;
        }

        long scheduleNextHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow() + this.heartbeatIntervalMs;
            return this.nextHeartbeatTime;
        }

        boolean isHeartbeatDue(long startTime) {
            return this.nextHeartbeatTime - startTime <= 0L;
        }

        boolean isBlockReportDue(long curTime) {
            return this.nextBlockReportTime - curTime <= 0L;
        }

        void forceFullBlockReportNow() {
            this.forceFullBlockReport.set(true);
            this.resetBlockReportTime = true;
        }

        long scheduleBlockReport(long delay) {
            this.nextBlockReportTime = delay > 0L ? this.monotonicNow() + (long)DFSUtil.getRandom().nextInt((int)delay) : this.monotonicNow();
            this.resetBlockReportTime = true;
            return this.nextBlockReportTime;
        }

        void scheduleNextBlockReport() {
            if (this.resetBlockReportTime) {
                this.nextBlockReportTime = this.monotonicNow() + (long)DFSUtil.getRandom().nextInt((int)this.blockReportIntervalMs);
                this.resetBlockReportTime = false;
            } else {
                this.nextBlockReportTime += (this.monotonicNow() - this.nextBlockReportTime + this.blockReportIntervalMs) / this.blockReportIntervalMs * this.blockReportIntervalMs;
            }
        }

        long getHeartbeatWaitTime() {
            return this.nextHeartbeatTime - this.monotonicNow();
        }

        @VisibleForTesting
        public long monotonicNow() {
            return Time.monotonicNow();
        }
    }

    private static class PerStoragePendingIncrementalBR {
        private final Map<Long, ReceivedDeletedBlockInfo> pendingIncrementalBR = Maps.newHashMap();

        private PerStoragePendingIncrementalBR() {
        }

        int getBlockInfoCount() {
            return this.pendingIncrementalBR.size();
        }

        ReceivedDeletedBlockInfo[] dequeueBlockInfos() {
            ReceivedDeletedBlockInfo[] blockInfos = this.pendingIncrementalBR.values().toArray(new ReceivedDeletedBlockInfo[this.getBlockInfoCount()]);
            this.pendingIncrementalBR.clear();
            return blockInfos;
        }

        int putMissingBlockInfos(ReceivedDeletedBlockInfo[] blockArray) {
            int blocksPut = 0;
            for (ReceivedDeletedBlockInfo rdbi : blockArray) {
                if (this.pendingIncrementalBR.containsKey(rdbi.getBlock().getBlockId())) continue;
                this.pendingIncrementalBR.put(rdbi.getBlock().getBlockId(), rdbi);
                ++blocksPut;
            }
            return blocksPut;
        }

        void putBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            this.pendingIncrementalBR.put(blockInfo.getBlock().getBlockId(), blockInfo);
        }

        boolean removeBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            return this.pendingIncrementalBR.remove(blockInfo.getBlock().getBlockId()) != null;
        }
    }

    static enum RunningState {
        CONNECTING,
        INIT_FAILED,
        RUNNING,
        EXITED,
        FAILED;

    }
}

