/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;

public class IPFailoverProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    private final Configuration conf;
    private final Class<T> xface;
    private final URI nameNodeUri;
    private FailoverProxyProvider.ProxyInfo<T> nnProxyInfo = null;

    public IPFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface) {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (Object)"Interface class %s is not a valid NameNode protocol!");
        this.xface = xface;
        this.nameNodeUri = uri;
        this.conf = new Configuration(conf);
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.nnProxyInfo == null) {
            try {
                InetSocketAddress nnAddr = NameNode.getAddress(this.conf, this.nameNodeUri);
                this.nnProxyInfo = new FailoverProxyProvider.ProxyInfo(NameNodeProxies.createNonHAProxy(this.conf, nnAddr, this.xface, UserGroupInformation.getCurrentUser(), false).getProxy(), nnAddr.toString());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.nnProxyInfo;
    }

    public void performFailover(T currentProxy) {
    }

    public synchronized void close() throws IOException {
        if (this.nnProxyInfo == null) {
            return;
        }
        if (this.nnProxyInfo.proxy instanceof Closeable) {
            ((Closeable)this.nnProxyInfo.proxy).close();
        } else {
            RPC.stopProxy((Object)this.nnProxyInfo.proxy);
        }
    }

    @Override
    public boolean useLogicalURI() {
        return false;
    }
}

