/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.s3csvinput.Messages;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInputMeta;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.textfileinput.TextFileCSVImportProgressDialog;

public class S3CsvInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private S3CsvInputMeta inputMeta;
    private TextVar wAccessKey;
    private TextVar wSecretKey;
    private TextVar wBucket;
    private Button wbBucket;
    private TextVar wFilename;
    private CCombo wFilenameField;
    private Button wbbFilename;
    private Button wIncludeFilename;
    private TextVar wRowNumField;
    private Button wbDelimiter;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wMaxLineSize;
    private Button wLazyConversion;
    private Button wHeaderPresent;
    private TableView wFields;
    private boolean isReceivingInput;
    private Button wRunningInParallel;

    public S3CsvInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.inputMeta = (S3CsvInputMeta)((Object)in);
    }

    public String open() {
        FormData fdFilename;
        FormData fdlFilename;
        Label wlFilename;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.inputMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S3CsvInputDialog.this.inputMeta.setChanged();
            }
        };
        this.changed = this.inputMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(Messages.getString("S3CsvInputDialog.Shell.Title"));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(Messages.getString("S3CsvInputDialog.Stepname.Label"));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Text lastControl = this.wStepname;
        Label wlAccessKey = new Label((Composite)this.shell, 131072);
        wlAccessKey.setText(Messages.getString("S3CsvInputDialog.AccessKey.Label"));
        this.props.setLook((Control)wlAccessKey);
        FormData fdlAccessKey = new FormData();
        fdlAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdlAccessKey.left = new FormAttachment(0, 0);
        fdlAccessKey.right = new FormAttachment(middle, -margin);
        wlAccessKey.setLayoutData((Object)fdlAccessKey);
        this.wAccessKey = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wAccessKey);
        this.wAccessKey.addModifyListener(lsMod);
        FormData fdAccessKey = new FormData();
        fdAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdAccessKey.left = new FormAttachment(middle, 0);
        fdAccessKey.right = new FormAttachment(100, 0);
        this.wAccessKey.setLayoutData((Object)fdAccessKey);
        lastControl = this.wAccessKey;
        Label wlSecretKey = new Label((Composite)this.shell, 131072);
        wlSecretKey.setText(Messages.getString("S3CsvInputDialog.SecretKey.Label"));
        this.props.setLook((Control)wlSecretKey);
        FormData fdlSecretKey = new FormData();
        fdlSecretKey.top = new FormAttachment((Control)lastControl, margin);
        fdlSecretKey.left = new FormAttachment(0, 0);
        fdlSecretKey.right = new FormAttachment(middle, -margin);
        wlSecretKey.setLayoutData((Object)fdlSecretKey);
        this.wSecretKey = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSecretKey);
        this.wSecretKey.addModifyListener(lsMod);
        FormData fdSecretKey = new FormData();
        fdSecretKey.top = new FormAttachment((Control)lastControl, margin);
        fdSecretKey.left = new FormAttachment(middle, 0);
        fdSecretKey.right = new FormAttachment(100, 0);
        this.wSecretKey.setLayoutData((Object)fdSecretKey);
        lastControl = this.wSecretKey;
        Label wlBucket = new Label((Composite)this.shell, 131072);
        wlBucket.setText(Messages.getString("S3CsvInputDialog.Bucket.Label"));
        this.props.setLook((Control)wlBucket);
        FormData fdlBucket = new FormData();
        fdlBucket.top = new FormAttachment((Control)lastControl, margin);
        fdlBucket.left = new FormAttachment(0, 0);
        fdlBucket.right = new FormAttachment(middle, -margin);
        wlBucket.setLayoutData((Object)fdlBucket);
        this.wbBucket = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbBucket);
        this.wbBucket.setText(Messages.getString("S3CsvInputDialog.Bucket.Button"));
        FormData fdbBucket = new FormData();
        fdbBucket.top = new FormAttachment((Control)lastControl, margin);
        fdbBucket.right = new FormAttachment(100, 0);
        this.wbBucket.setLayoutData((Object)fdbBucket);
        this.wBucket = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBucket);
        this.wBucket.addModifyListener(lsMod);
        FormData fdBucket = new FormData();
        fdBucket.top = new FormAttachment((Control)lastControl, margin);
        fdBucket.left = new FormAttachment(middle, 0);
        fdBucket.right = new FormAttachment((Control)this.wbBucket, -margin);
        this.wBucket.setLayoutData((Object)fdBucket);
        lastControl = this.wBucket;
        boolean bl = this.isReceivingInput = this.transMeta.findNrPrevSteps(this.stepMeta) > 0;
        if (this.isReceivingInput) {
            RowMetaInterface previousFields;
            try {
                previousFields = this.transMeta.getPrevStepFields(this.stepMeta);
            }
            catch (KettleStepException e) {
                new ErrorDialog(this.shell, Messages.getString("S3CsvInputDialog.ErrorDialog.UnableToGetInputFields.Title"), Messages.getString("S3CsvInputDialog.ErrorDialog.UnableToGetInputFields.Message"), (Exception)((Object)e));
                previousFields = new RowMeta();
            }
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(Messages.getString("S3CsvInputDialog.FilenameField.Label"));
            this.props.setLook((Control)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilenameField = new CCombo((Composite)this.shell, 18436);
            this.wFilenameField.setItems(previousFields.getFieldNames());
            this.props.setLook((Control)this.wFilenameField);
            this.wFilenameField.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment(100, 0);
            this.wFilenameField.setLayoutData((Object)fdFilename);
            lastControl = this.wFilenameField;
            Label wlIncludeFilename = new Label((Composite)this.shell, 131072);
            wlIncludeFilename.setText(Messages.getString("S3CsvInputDialog.IncludeFilenameField.Label"));
            this.props.setLook((Control)wlIncludeFilename);
            FormData fdlIncludeFilename = new FormData();
            fdlIncludeFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlIncludeFilename.left = new FormAttachment(0, 0);
            fdlIncludeFilename.right = new FormAttachment(middle, -margin);
            wlIncludeFilename.setLayoutData((Object)fdlIncludeFilename);
            this.wIncludeFilename = new Button((Composite)this.shell, 32);
            this.props.setLook((Control)this.wIncludeFilename);
            this.wFilenameField.addModifyListener(lsMod);
            FormData fdIncludeFilename = new FormData();
            fdIncludeFilename.top = new FormAttachment((Control)lastControl, margin);
            fdIncludeFilename.left = new FormAttachment(middle, 0);
            fdIncludeFilename.right = new FormAttachment(100, 0);
            this.wIncludeFilename.setLayoutData((Object)fdIncludeFilename);
            lastControl = this.wIncludeFilename;
        } else {
            this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
            this.props.setLook((Control)this.wbbFilename);
            this.wbbFilename.setText(Messages.getString("System.Button.Browse"));
            this.wbbFilename.setToolTipText(Messages.getString("System.Tooltip.BrowseForFileOrDirAndAdd"));
            FormData fdbFilename = new FormData();
            fdbFilename.top = new FormAttachment((Control)lastControl, margin);
            fdbFilename.right = new FormAttachment(100, 0);
            this.wbbFilename.setLayoutData((Object)fdbFilename);
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(Messages.getString("S3CsvInputDialog.Filename.Label"));
            this.props.setLook((Control)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
            this.props.setLook((Control)this.wFilename);
            this.wFilename.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
            this.wFilename.setLayoutData((Object)fdFilename);
            lastControl = this.wFilename;
        }
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(Messages.getString("S3CsvInputDialog.Delimiter.Label"));
        this.props.setLook((Control)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wbDelimiter = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDelimiter);
        this.wbDelimiter.setText(Messages.getString("S3CsvInputDialog.Delimiter.Button"));
        FormData fdbDelimiter = new FormData();
        fdbDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdbDelimiter.right = new FormAttachment(100, 0);
        this.wbDelimiter.setLayoutData((Object)fdbDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.right = new FormAttachment((Control)this.wbDelimiter, -margin);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        lastControl = this.wDelimiter;
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(Messages.getString("S3CsvInputDialog.Enclosure.Label"));
        this.props.setLook((Control)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        lastControl = this.wEnclosure;
        Label wlMaxLineSize = new Label((Composite)this.shell, 131072);
        wlMaxLineSize.setText(Messages.getString("S3CsvInputDialog.MaxLineSize.Label"));
        this.props.setLook((Control)wlMaxLineSize);
        FormData fdlMaxLineSize = new FormData();
        fdlMaxLineSize.top = new FormAttachment((Control)lastControl, margin);
        fdlMaxLineSize.left = new FormAttachment(0, 0);
        fdlMaxLineSize.right = new FormAttachment(middle, -margin);
        wlMaxLineSize.setLayoutData((Object)fdlMaxLineSize);
        this.wMaxLineSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMaxLineSize);
        this.wMaxLineSize.addModifyListener(lsMod);
        FormData fdMaxLineSize = new FormData();
        fdMaxLineSize.top = new FormAttachment((Control)lastControl, margin);
        fdMaxLineSize.left = new FormAttachment(middle, 0);
        fdMaxLineSize.right = new FormAttachment(100, 0);
        this.wMaxLineSize.setLayoutData((Object)fdMaxLineSize);
        lastControl = this.wMaxLineSize;
        Label wlLazyConversion = new Label((Composite)this.shell, 131072);
        wlLazyConversion.setText(Messages.getString("S3CsvInputDialog.LazyConversion.Label"));
        this.props.setLook((Control)wlLazyConversion);
        FormData fdlLazyConversion = new FormData();
        fdlLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdlLazyConversion.left = new FormAttachment(0, 0);
        fdlLazyConversion.right = new FormAttachment(middle, -margin);
        wlLazyConversion.setLayoutData((Object)fdlLazyConversion);
        this.wLazyConversion = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLazyConversion);
        FormData fdLazyConversion = new FormData();
        fdLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdLazyConversion.left = new FormAttachment(middle, 0);
        fdLazyConversion.right = new FormAttachment(100, 0);
        this.wLazyConversion.setLayoutData((Object)fdLazyConversion);
        lastControl = this.wLazyConversion;
        Label wlHeaderPresent = new Label((Composite)this.shell, 131072);
        wlHeaderPresent.setText(Messages.getString("S3CsvInputDialog.HeaderPresent.Label"));
        this.props.setLook((Control)wlHeaderPresent);
        FormData fdlHeaderPresent = new FormData();
        fdlHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdlHeaderPresent.left = new FormAttachment(0, 0);
        fdlHeaderPresent.right = new FormAttachment(middle, -margin);
        wlHeaderPresent.setLayoutData((Object)fdlHeaderPresent);
        this.wHeaderPresent = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHeaderPresent);
        FormData fdHeaderPresent = new FormData();
        fdHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdHeaderPresent.left = new FormAttachment(middle, 0);
        fdHeaderPresent.right = new FormAttachment(100, 0);
        this.wHeaderPresent.setLayoutData((Object)fdHeaderPresent);
        lastControl = this.wHeaderPresent;
        Label wlRowNumField = new Label((Composite)this.shell, 131072);
        wlRowNumField.setText(Messages.getString("S3CsvInputDialog.RowNumField.Label"));
        this.props.setLook((Control)wlRowNumField);
        FormData fdlRowNumField = new FormData();
        fdlRowNumField.top = new FormAttachment((Control)lastControl, margin);
        fdlRowNumField.left = new FormAttachment(0, 0);
        fdlRowNumField.right = new FormAttachment(middle, -margin);
        wlRowNumField.setLayoutData((Object)fdlRowNumField);
        this.wRowNumField = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wRowNumField);
        this.wRowNumField.addModifyListener(lsMod);
        FormData fdRowNumField = new FormData();
        fdRowNumField.top = new FormAttachment((Control)lastControl, margin);
        fdRowNumField.left = new FormAttachment(middle, 0);
        fdRowNumField.right = new FormAttachment(100, 0);
        this.wRowNumField.setLayoutData((Object)fdRowNumField);
        lastControl = this.wRowNumField;
        Label wlRunningInParallel = new Label((Composite)this.shell, 131072);
        wlRunningInParallel.setText(Messages.getString("S3CsvInputDialog.RunningInParallel.Label"));
        this.props.setLook((Control)wlRunningInParallel);
        FormData fdlRunningInParallel = new FormData();
        fdlRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdlRunningInParallel.left = new FormAttachment(0, 0);
        fdlRunningInParallel.right = new FormAttachment(middle, -margin);
        wlRunningInParallel.setLayoutData((Object)fdlRunningInParallel);
        this.wRunningInParallel = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wRunningInParallel);
        FormData fdRunningInParallel = new FormData();
        fdRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdRunningInParallel.left = new FormAttachment(middle, 0);
        this.wRunningInParallel.setLayoutData((Object)fdRunningInParallel);
        lastControl = this.wRunningInParallel;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(Messages.getString("System.Button.OK"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(Messages.getString("System.Button.Cancel"));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(Messages.getString("System.Button.Preview"));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(Messages.getString("System.Button.GetFields"));
        this.wGet.setEnabled(!this.isReceivingInput);
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wPreview, this.wGet}, margin, null);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(Messages.getString("S3CsvInputDialog.NameColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.TypeColumn.Column"), 2, ValueMeta.getTypes(), true), new ColumnInfo(Messages.getString("S3CsvInputDialog.FormatColumn.Column"), 2, Const.getConversionFormats()), new ColumnInfo(Messages.getString("S3CsvInputDialog.LengthColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.PrecisionColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.CurrencyColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.DecimalColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.GroupColumn.Column"), 1, false), new ColumnInfo(Messages.getString("S3CsvInputDialog.TrimTypeColumn.Column"), 2, ValueMeta.trimTypeDesc)};
        colinf[2].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                int type = ValueMeta.getType((String)tableItem.getText(colNr - 1));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 65538, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                S3CsvInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                S3CsvInputDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                S3CsvInputDialog.this.preview();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                S3CsvInputDialog.this.getCSV();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                S3CsvInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        if (this.wFilename != null) {
            this.wFilename.addSelectionListener(this.lsDef);
        }
        if (this.wFilenameField != null) {
            this.wFilenameField.addSelectionListener((SelectionListener)this.lsDef);
        }
        this.wDelimiter.addSelectionListener(this.lsDef);
        this.wEnclosure.addSelectionListener(this.lsDef);
        this.wMaxLineSize.addSelectionListener(this.lsDef);
        this.wRowNumField.addSelectionListener(this.lsDef);
        this.wbDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Text t = S3CsvInputDialog.this.wDelimiter.getTextWidget();
                if (t != null) {
                    t.insert("\t");
                }
            }
        });
        this.wbBucket.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    S3CsvInputMeta meta = new S3CsvInputMeta();
                    S3CsvInputDialog.this.getInfo(meta);
                    S3Service service = meta.getS3Service((VariableSpace)S3CsvInputDialog.this.transMeta);
                    S3Bucket[] buckets = service.listAllBuckets();
                    String[] bucketNames = new String[buckets.length];
                    for (int i = 0; i < buckets.length; ++i) {
                        bucketNames[i] = buckets[i].getName();
                    }
                    EnterSelectionDialog dialog = new EnterSelectionDialog(S3CsvInputDialog.this.shell, bucketNames, Messages.getString("S3CsvInputDialog.Exception.SelectBucket.Title"), Messages.getString("S3CsvInputDialog.Exception.SelectBucket.Message"));
                    dialog.setMulti(false);
                    String bucketname = dialog.open();
                    if (bucketname != null) {
                        S3CsvInputDialog.this.wBucket.setText(bucketname);
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(S3CsvInputDialog.this.shell, Messages.getString("S3CsvInputDialog.Exception.UnableToGetBuckets.Title"), Messages.getString("S3CsvInputDialog.Exception.UnableToGetBuckets.Message"), e);
                }
            }
        });
        if (this.wbbFilename != null) {
            this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        String objectname;
                        int index;
                        S3CsvInputMeta meta = new S3CsvInputMeta();
                        S3CsvInputDialog.this.getInfo(meta);
                        S3Service service = meta.getS3Service((VariableSpace)S3CsvInputDialog.this.transMeta);
                        S3Bucket[] buckets = service.listAllBuckets();
                        S3Bucket bucket = null;
                        for (S3Bucket compare : buckets) {
                            if (!compare.getName().equals(meta.getBucket())) continue;
                            bucket = compare;
                        }
                        if (bucket == null) {
                            throw new Exception(Messages.getString("S3CsvInputDialog.Exception.UnableToFindBucket.Message", meta.getBucket()));
                        }
                        S3Object[] objects = service.listObjects(bucket);
                        String[] objectnames = new String[objects.length];
                        for (int i = 0; i < objects.length; ++i) {
                            objectnames[i] = objects[i].getKey();
                        }
                        EnterSelectionDialog dialog = new EnterSelectionDialog(S3CsvInputDialog.this.shell, objectnames, Messages.getString("S3CsvInputDialog.Exception.SelectObject.Title"), Messages.getString("S3CsvInputDialog.Exception.SelectObject.Message"));
                        dialog.setMulti(false);
                        if (!Utils.isEmpty((CharSequence)S3CsvInputDialog.this.wFilename.getText()) && (index = Const.indexOfString((String)S3CsvInputDialog.this.wFilename.getText(), (String[])objectnames)) >= 0) {
                            dialog.setSelectedNrs(new int[]{index});
                        }
                        if ((objectname = dialog.open()) != null) {
                            S3CsvInputDialog.this.wFilename.setText(objectname);
                        }
                    }
                    catch (Exception e) {
                        new ErrorDialog(S3CsvInputDialog.this.shell, Messages.getString("S3CsvInputDialog.Exception.UnableToGetFiles.Title"), Messages.getString("S3CsvInputDialog.Exception.UnableToGetFiles.Message"), e);
                    }
                }
            });
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                S3CsvInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.inputMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.getData(this.inputMeta);
    }

    public void getData(S3CsvInputMeta inputMeta) {
        this.wStepname.setText(this.stepname);
        this.wAccessKey.setText(Const.NVL((String)inputMeta.getAwsAccessKey(), (String)""));
        this.wSecretKey.setText(Const.NVL((String)inputMeta.getAwsSecretKey(), (String)""));
        this.wBucket.setText(Const.NVL((String)inputMeta.getBucket(), (String)""));
        if (this.isReceivingInput) {
            this.wFilenameField.setText(Const.NVL((String)inputMeta.getFilenameField(), (String)""));
            this.wIncludeFilename.setSelection(inputMeta.isIncludingFilename());
        } else {
            this.wFilename.setText(Const.NVL((String)inputMeta.getFilename(), (String)""));
        }
        this.wDelimiter.setText(Const.NVL((String)inputMeta.getDelimiter(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)inputMeta.getEnclosure(), (String)""));
        this.wMaxLineSize.setText(Const.NVL((String)inputMeta.getMaxLineSize(), (String)""));
        this.wLazyConversion.setSelection(inputMeta.isLazyConversionActive());
        this.wHeaderPresent.setSelection(inputMeta.isHeaderPresent());
        this.wRunningInParallel.setSelection(inputMeta.isRunningInParallel());
        this.wRowNumField.setText(Const.NVL((String)inputMeta.getRowNumField(), (String)""));
        for (int i = 0; i < inputMeta.getInputFields().length; ++i) {
            TextFileInputField field = inputMeta.getInputFields()[i];
            TableItem item = new TableItem(this.wFields.table, 0);
            int colnr = 1;
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getFormat(), (String)""));
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getCurrencySymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGroupSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getTrimTypeDesc(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.inputMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(S3CsvInputMeta inputMeta) {
        inputMeta.setAwsAccessKey(this.wAccessKey.getText());
        inputMeta.setAwsSecretKey(this.wSecretKey.getText());
        inputMeta.setBucket(this.wBucket.getText());
        if (this.isReceivingInput) {
            inputMeta.setFilenameField(this.wFilenameField.getText());
            inputMeta.setIncludingFilename(this.wIncludeFilename.getSelection());
        } else {
            inputMeta.setFilename(this.wFilename.getText());
        }
        inputMeta.setDelimiter(this.wDelimiter.getText());
        inputMeta.setEnclosure(this.wEnclosure.getText());
        inputMeta.setMaxLineSize(this.wMaxLineSize.getText());
        inputMeta.setLazyConversionActive(this.wLazyConversion.getSelection());
        inputMeta.setHeaderPresent(this.wHeaderPresent.getSelection());
        inputMeta.setRowNumField(this.wRowNumField.getText());
        inputMeta.setRunningInParallel(this.wRunningInParallel.getSelection());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        inputMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            inputMeta.getInputFields()[i] = new TextFileInputField();
            int colnr = 1;
            inputMeta.getInputFields()[i].setName(item.getText(colnr++));
            inputMeta.getInputFields()[i].setType(ValueMeta.getType((String)item.getText(colnr++)));
            inputMeta.getInputFields()[i].setFormat(item.getText(colnr++));
            inputMeta.getInputFields()[i].setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setCurrencySymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setDecimalSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setGroupSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setTrimType(ValueMeta.getTrimTypeByDesc((String)item.getText(colnr++)));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        inputMeta.setChanged();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.inputMeta);
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getCSV() {
        block33: {
            InputStream inputStream;
            block32: {
                int i;
                int samples;
                S3Bucket s3bucket;
                S3Service s3Service;
                int maxLineSize;
                String filename;
                S3CsvInputMeta meta;
                block31: {
                    String lineText;
                    inputStream = null;
                    meta = new S3CsvInputMeta();
                    this.getInfo(meta);
                    filename = this.transMeta.environmentSubstitute(meta.getFilename());
                    String bucketname = this.transMeta.environmentSubstitute(meta.getBucket());
                    maxLineSize = Const.toInt((String)this.transMeta.environmentSubstitute(meta.getMaxLineSize()), (int)2000);
                    this.wFields.table.removeAll();
                    s3Service = meta.getS3Service((VariableSpace)this.transMeta);
                    S3Bucket[] buckets = s3Service.listAllBuckets();
                    s3bucket = null;
                    for (S3Bucket bucket : buckets) {
                        if (!bucket.getName().equals(bucketname)) continue;
                        s3bucket = bucket;
                    }
                    if (s3bucket == null) {
                        throw new Exception("Unable to find specified bucket : [" + bucketname + "]");
                    }
                    String shellText = Messages.getString("S3CsvInputDialog.LinesToSample.DialogTitle");
                    EnterNumberDialog end = new EnterNumberDialog(this.shell, 100, shellText, lineText = Messages.getString("S3CsvInputDialog.LinesToSample.DialogMessage"));
                    samples = end.open();
                    if (samples >= 0) break block31;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.logError(this.stepname, new Object[]{"Error closing s3 data input stream", e});
                    }
                    return;
                }
                S3Object object = s3Service.getObject(s3bucket, filename, null, null, null, null, Long.valueOf(0L), Long.valueOf((long)samples * (long)maxLineSize));
                inputStream = object.getDataInputStream();
                InputStreamReader reader = new InputStreamReader(inputStream);
                String line = TextFileInput.getLine((LogChannelInterface)this.log, (InputStreamReader)reader, (int)2, (StringBuilder)new StringBuilder(1000));
                String[] fieldNames = Const.splitString((String)line, (String)meta.getDelimiter());
                if (!meta.isHeaderPresent()) {
                    DecimalFormat df = new DecimalFormat("000");
                    for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                        fieldNames[i2] = "Field_" + df.format(i2);
                    }
                } else if (!Utils.isEmpty((CharSequence)meta.getEnclosure())) {
                    for (int i3 = 0; i3 < fieldNames.length; ++i3) {
                        if (!fieldNames[i3].startsWith(meta.getEnclosure()) || !fieldNames[i3].endsWith(meta.getEnclosure()) || fieldNames[i3].length() <= 1) continue;
                        fieldNames[i3] = fieldNames[i3].substring(1, fieldNames[i3].length() - 1);
                    }
                }
                for (i = 0; i < fieldNames.length; ++i) {
                    fieldNames[i] = Const.trim((String)fieldNames[i]);
                }
                for (i = 0; i < fieldNames.length; ++i) {
                    TableItem item = new TableItem(this.wFields.table, 0);
                    item.setText(1, fieldNames[i]);
                    item.setText(2, ValueMeta.getTypeDesc((int)2));
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
                this.getInfo(meta);
                TextFileCSVImportProgressDialog pd = new TextFileCSVImportProgressDialog(this.shell, (InputFileMetaInterface)meta, this.transMeta, reader, samples, true);
                String message = pd.open();
                if (message == null) break block32;
                this.wFields.removeAll();
                this.getData(meta);
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
                EnterTextDialog etd = new EnterTextDialog(this.shell, Messages.getString("S3CsvInputDialog.ScanResults.DialogTitle"), Messages.getString("S3CsvInputDialog.ScanResults.DialogMessage"), message, true);
                etd.setReadOnly();
                etd.open();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block33;
            }
            catch (Exception e) {
                this.log.logError(this.stepname, new Object[]{"Error closing s3 data input stream", e});
            }
            break block33;
            catch (IOException e) {
                new ErrorDialog(this.shell, Messages.getString("S3CsvInputDialog.IOError.DialogTitle"), Messages.getString("S3CsvInputDialog.IOError.DialogMessage"), (Exception)e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block33;
                }
                catch (Exception e2) {
                    this.log.logError(this.stepname, new Object[]{"Error closing s3 data input stream", e2});
                }
                break block33;
            }
            catch (Exception e2) {
                new ErrorDialog(this.shell, Messages.getString("System.Dialog.Error.Title"), Messages.getString("S3CsvInputDialog.ErrorGettingFileDesc.DialogMessage"), e2);
                {
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (Exception e3) {
                            this.log.logError(this.stepname, new Object[]{"Error closing s3 data input stream", e3});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e4) {
                    this.log.logError(this.stepname, new Object[]{"Error closing s3 data input stream", e4});
                }
            }
        }
    }

    private void preview() {
        S3CsvInputMeta oneMeta = new S3CsvInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), Messages.getString("S3CsvInputDialog.PreviewSize.DialogTitle"), Messages.getString("S3CsvInputDialog.PreviewSize.DialogMessage"));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, Messages.getString("System.Dialog.PreviewError.Title"), Messages.getString("System.Dialog.PreviewError.Message"), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

