/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import java.util.ArrayList;
import java.util.List;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.s3csvinput.Messages;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInput;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInputData;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInputDialog;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="S3CSVINPUT", image="S3I.svg", i18nPackageName="org.pentaho.di.trans.steps.s3csvinput", name="S3CsvInput.Step.Name", description="S3CsvInput.Step.Description", categoryDescription="Input", documentationUrl="http://wiki.pentaho.com/display/EAI/S3+CSV+Input")
@InjectionSupported(localizationPrefix="S3CsvInput.Injection.", groups={"INPUT_FIELDS"})
public class S3CsvInputMeta
extends BaseStepMeta
implements StepMetaInterface,
InputFileMetaInterface {
    @Injection(name="BUCKET")
    private String bucket;
    @Injection(name="FILENAME")
    private String filename;
    @Injection(name="FILENAME_FIELD")
    private String filenameField;
    @Injection(name="INCLUDE_FILENAME")
    private boolean includingFilename;
    @Injection(name="ROW_NUMBER_FIELD")
    private String rowNumField;
    @Injection(name="HEADER_PRESENT")
    private boolean headerPresent;
    @Injection(name="SEPARATOR")
    private String delimiter;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="MAX_LINE_SIZE")
    private String maxLineSize;
    @Injection(name="LAZY_CONVERSION_ACTIVE")
    private boolean lazyConversionActive;
    @InjectionDeep
    private TextFileInputField[] inputFields;
    @Injection(name="RUNNING_IN_PARALLEL")
    private boolean runningInParallel;
    @Injection(name="AWS_ACCESS_KEY")
    private String awsAccessKey;
    @Injection(name="AWS_SECRET_KEY")
    private String awsSecretKey;

    public S3CsvInputMeta() {
        this.allocate(0);
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.delimiter = ",";
        this.enclosure = "\"";
        this.headerPresent = true;
        this.lazyConversionActive = true;
        this.maxLineSize = "5000";
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.awsAccessKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"aws_access_key"));
            this.awsSecretKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"aws_secret_key"));
            this.bucket = XMLHandler.getTagValue((Node)stepnode, (String)"bucket");
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_field");
            this.rowNumField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.includingFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_filename"));
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.maxLineSize = XMLHandler.getTagValue((Node)stepnode, (String)"max_line_size");
            this.headerPresent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.lazyConversionActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"lazy_conversion"));
            this.runningInParallel = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"parallel"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.inputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.inputFields = new TextFileInputField[nrFields];
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"aws_access_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.awsAccessKey)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"aws_secret_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.awsSecretKey)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bucket", (String)this.bucket));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_filename", (boolean)this.includingFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"separator", (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerPresent));
        retval.append("    ").append(XMLHandler.addTagValue((String)"max_line_size", (String)this.maxLineSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lazy_conversion", (boolean)this.lazyConversionActive));
        retval.append("    ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.runningInParallel));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)field.getType())));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMetaString.getTrimTypeCode((int)field.getTrimType())));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.awsAccessKey = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "aws_access_key"));
            this.awsSecretKey = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "aws_secret_key"));
            this.bucket = rep.getStepAttributeString(id_step, "bucket");
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.filenameField = rep.getStepAttributeString(id_step, "filename_field");
            this.rowNumField = rep.getStepAttributeString(id_step, "rownum_field");
            this.includingFilename = rep.getStepAttributeBoolean(id_step, "include_filename");
            this.delimiter = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.headerPresent = rep.getStepAttributeBoolean(id_step, "header");
            this.maxLineSize = rep.getStepAttributeString(id_step, "max_line_size");
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, "lazy_conversion");
            this.runningInParallel = rep.getStepAttributeBoolean(id_step, "parallel");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                this.inputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                this.inputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.inputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.inputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.inputFields[i].setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.inputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.inputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.inputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "aws_secret_key", Encr.encryptPasswordIfNotUsingVariables((String)this.awsSecretKey));
            rep.saveStepAttribute(id_transformation, id_step, "aws_access_key", Encr.encryptPasswordIfNotUsingVariables((String)this.awsAccessKey));
            rep.saveStepAttribute(id_transformation, id_step, "bucket", this.bucket);
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "filename_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumField);
            rep.saveStepAttribute(id_transformation, id_step, "include_filename", this.includingFilename);
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "max_line_size", this.maxLineSize);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerPresent);
            rep.saveStepAttribute(id_transformation, id_step, "lazy_conversion", this.lazyConversionActive);
            rep.saveStepAttribute(id_transformation, id_step, "parallel", this.runningInParallel);
            for (int i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMetaFactory.getValueMetaName((int)field.getType()));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", (long)field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", ValueMetaString.getTrimTypeCode((int)field.getTrimType()));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        rowMeta.clear();
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            ValueMeta valueMeta = new ValueMeta(field.getName(), field.getType());
            valueMeta.setConversionMask(field.getFormat());
            valueMeta.setLength(field.getLength());
            valueMeta.setPrecision(field.getPrecision());
            valueMeta.setConversionMask(field.getFormat());
            valueMeta.setDecimalSymbol(field.getDecimalSymbol());
            valueMeta.setGroupingSymbol(field.getGroupSymbol());
            valueMeta.setCurrencySymbol(field.getCurrencySymbol());
            valueMeta.setTrimType(field.getTrimType());
            if (this.lazyConversionActive) {
                valueMeta.setStorageType(1);
            }
            ValueMetaInterface storageMetadata = valueMeta.clone();
            storageMetadata.setType(2);
            storageMetadata.setStorageType(0);
            storageMetadata.setLength(-1, -1);
            valueMeta.setStorageMetadata(storageMetadata);
            valueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        }
        if (!Utils.isEmpty((CharSequence)this.filenameField) && this.includingFilename) {
            ValueMetaString filenameMeta = new ValueMetaString(this.filenameField);
            filenameMeta.setOrigin(origin);
            if (this.lazyConversionActive) {
                filenameMeta.setStorageType(1);
                filenameMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString(this.filenameField));
            }
            rowMeta.addValueMeta((ValueMetaInterface)filenameMeta);
        }
        if (!Utils.isEmpty((CharSequence)this.rowNumField)) {
            ValueMetaInteger rowNumMeta = new ValueMetaInteger(this.rowNumField);
            rowNumMeta.setLength(10);
            rowNumMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)rowNumMeta);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.getFields(rowMeta, origin, info, nextStep, space, null, null);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, Messages.getString("S3CsvInputMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("S3CsvInputMeta.eckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, Messages.getString("S3CsvInputMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("S3CsvInputMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getDialogClassName() {
        return S3CsvInputDialog.class.getName();
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new S3CsvInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new S3CsvInputData();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMaxLineSize() {
        return this.maxLineSize;
    }

    public void setMaxLineSize(String maxLineSize) {
        this.maxLineSize = maxLineSize;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference((ResourceHolderInterface)stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            reference.getEntries().add(new ResourceEntry(transMeta.environmentSubstitute(this.filename), ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public int getFileFormatTypeNr() {
        return 2;
    }

    public String[] getFilePaths(VariableSpace space) {
        return new String[]{space.environmentSubstitute(this.filename)};
    }

    public int getNrHeaderLines() {
        return 1;
    }

    public boolean hasHeader() {
        return this.isHeaderPresent();
    }

    public String getErrorCountField() {
        return null;
    }

    public String getErrorFieldsField() {
        return null;
    }

    public String getErrorTextField() {
        return null;
    }

    public String getEscapeCharacter() {
        return null;
    }

    public String getFileType() {
        return "CSV";
    }

    public String getSeparator() {
        return this.delimiter;
    }

    public boolean includeFilename() {
        return false;
    }

    public boolean includeRowNumber() {
        return false;
    }

    public boolean isErrorIgnored() {
        return false;
    }

    public boolean isErrorLineSkipped() {
        return false;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludingFilename() {
        return this.includingFilename;
    }

    public void setIncludingFilename(boolean includingFilename) {
        this.includingFilename = includingFilename;
    }

    public String getRowNumField() {
        return this.rowNumField;
    }

    public void setRowNumField(String rowNumField) {
        this.rowNumField = rowNumField;
    }

    public boolean isRunningInParallel() {
        return this.runningInParallel;
    }

    public void setRunningInParallel(boolean runningInParallel) {
        this.runningInParallel = runningInParallel;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public S3Service getS3Service(VariableSpace space) throws S3ServiceException {
        String accessKey = Encr.decryptPasswordOptionallyEncrypted((String)space.environmentSubstitute(this.awsAccessKey));
        String secretKey = Encr.decryptPasswordOptionallyEncrypted((String)space.environmentSubstitute(this.awsSecretKey));
        AWSCredentials awsCredentials = new AWSCredentials(accessKey, secretKey);
        RestS3Service s3service = new RestS3Service(awsCredentials);
        return s3service;
    }
}

