/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public abstract class StatusTransitXCommand
extends XCommand<Void> {
    public StatusTransitXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    @Override
    protected final long getLockTimeOut() {
        return 0L;
    }

    @Override
    protected final boolean isReQueueRequired() {
        return false;
    }

    @Override
    protected final boolean isLockRequired() {
        return true;
    }

    @Override
    protected Void execute() throws CommandException {
        Job.Status jobStatus = this.getJobStatus();
        try {
            if (jobStatus != null) {
                this.updateJobStatus(jobStatus);
            }
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        return null;
    }

    protected Job.Status getJobStatus() throws CommandException {
        if (this.isTerminalState()) {
            return this.getTerminalStatus();
        }
        if (this.isPausedState()) {
            return this.getPausedState();
        }
        if (this.isSuspendedState()) {
            return this.getSuspendedStatus();
        }
        if (this.isRunningState()) {
            return this.getRunningState();
        }
        return null;
    }

    protected abstract boolean isTerminalState();

    protected abstract Job.Status getTerminalStatus();

    protected abstract boolean isPausedState();

    protected abstract Job.Status getPausedState();

    protected abstract boolean isSuspendedState();

    protected abstract Job.Status getSuspendedStatus();

    protected abstract boolean isRunningState();

    protected abstract Job.Status getRunningState();

    protected abstract void updateJobStatus(Job.Status var1) throws JPAExecutorException, CommandException;
}

