/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordSLAAlertsXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordSLAChangeXCommand
extends CoordSLAAlertsXCommand {
    Map<String, String> newParams;

    public CoordSLAChangeXCommand(String jobId, String actions, String dates, Map<String, String> newParams) {
        super(jobId, "SLA.alerts.change", "SLA.alerts.change", actions, dates);
        this.newParams = newParams;
    }

    @Override
    protected boolean executeSlaCommand() throws ServiceException, CommandException {
        try {
            ArrayList<Pair<String, Map<String, String>>> idSlaDefinitionList = new ArrayList<Pair<String, Map<String, String>>>();
            List<CoordinatorActionBean> coordinatorActionBeanList = this.getNotTerminatedActions();
            XConfiguration conf = this.getJobConf();
            for (CoordinatorActionBean coordAction : coordinatorActionBeanList) {
                HashMap<String, String> slaDefinitionMap = new HashMap<String, String>(this.newParams);
                for (String key : slaDefinitionMap.keySet()) {
                    Element eAction = XmlUtils.parseXml(coordAction.getActionXml().toString());
                    ELEvaluator evalSla = CoordELEvaluator.createSLAEvaluator(eAction, coordAction, conf);
                    String updateValue = CoordELFunctions.evalAndWrap(evalSla, (String)slaDefinitionMap.get(key));
                    slaDefinitionMap.put(key, updateValue);
                }
                idSlaDefinitionList.add(new Pair<String, HashMap<String, String>>(coordAction.getId(), slaDefinitionMap));
            }
            return Services.get().get(SLAService.class).changeDefinition(idSlaDefinitionList);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1027, e.getMessage(), e);
        }
    }

    @Override
    protected void updateJob() throws CommandException {
        if (this.isJobRequest()) {
            this.updateJobSLA(this.newParams);
        }
    }

    private List<CoordinatorActionBean> getNotTerminatedActions() throws JPAExecutorException {
        if (this.isJobRequest()) {
            return CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_ACTIVE_ACTIONS_JOBID_FOR_SLA_CHANGE, this.getJobId());
        }
        return CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_ACTIVE_ACTIONS_IDS_FOR_SLA_CHANGE, this.getActionList());
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.validateSLAChangeParam(this.newParams);
    }
}

