/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class BundleJobsDeleteJPAExecutor
implements JPAExecutor<Integer> {
    private Collection<String> deleteList;

    public BundleJobsDeleteJPAExecutor(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    public BundleJobsDeleteJPAExecutor() {
    }

    public void setDeleteList(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    @Override
    public String getName() {
        return "BundleJobsDeleteJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted = 0;
        try {
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.deleteList != null && !this.deleteList.isEmpty()) {
                Query q = em.createNamedQuery("DELETE_BUNDLE_JOB");
                q.setParameter("id", this.deleteList);
                q.executeUpdate();
                Query g = em.createNamedQuery("DELETE_ACTIONS_FOR_BUNDLE");
                g.setParameter("bundleId", this.deleteList);
                actionsDeleted = g.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return actionsDeleted;
    }
}

