/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.util.Properties;
import org.apache.oozie.util.XLog;

public class JMSConnectionInfo {
    private String jndiPropertiesString;
    private Properties props;

    public JMSConnectionInfo(String jndiPropertiesString) {
        this.jndiPropertiesString = jndiPropertiesString;
        this.initializeProps();
    }

    private void initializeProps() {
        String[] propArr;
        this.props = new Properties();
        for (String pair : propArr = this.jndiPropertiesString.split(";")) {
            String[] kV = pair.split("#");
            if (kV.length > 1) {
                this.props.put(kV[0].trim(), kV[1].trim());
                continue;
            }
            XLog.getLog(this.getClass()).warn("Unformatted properties. Expected key#value : " + pair);
            this.props = null;
        }
        if (this.props.isEmpty()) {
            this.props = null;
        }
    }

    public Properties getJNDIProperties() {
        return this.props;
    }

    public String getJNDIPropertiesString() {
        return this.jndiPropertiesString;
    }

    public int hashCode() {
        return 31 + (this.jndiPropertiesString == null ? 0 : this.jndiPropertiesString.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JMSConnectionInfo other = (JMSConnectionInfo)obj;
        return !(this.jndiPropertiesString == null ? other.jndiPropertiesString != null : !this.jndiPropertiesString.equals(other.jndiPropertiesString));
    }

    public String toString() {
        return "JMSConnectionInfo [jndiProperties=" + this.jndiPropertiesString + "]";
    }
}

