/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;

public class XLogCopyService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.XLogCopyService.";
    public static final String CONF_SERVICE_INTERVAL = "oozie.service.XLogCopyService.interval";
    public static final String CONF_HDFS_LOG_DIR = "oozie.service.XLogCopyService.hdfs.log.dir";
    public static final String CONF_LOG_PURGE = "oozie.service.XLogCopyService.purge.enable";
    public static String HDFS_LOG_DIR;
    public static int CURRENT_LINE_NUMBER;
    public static String LAST_COMPLETE_LOG_FILE_NAME;
    public static String OOZIE_INSTANCE_ID;
    public static HashMap<String, String> jdbcConf;
    public static String LOGPROGRESS_GET_QUERY;
    public static String LOGPROGRESS_UPDATE_QUERY;
    public static String LOGPROGRESS_UPDATE_QUERY_WHERE_CLAUSE;
    public static String LOGPROGRESS_INSERT_QUERY;
    public static Boolean IS_LOG_PURGING_ENABLED;
    private final XLog log = XLog.getLog(this.getClass());

    private static long getLastModifiedTime(String directory, String file) {
        return new File(directory, file).lastModified();
    }

    @Override
    public void init(Services services) throws ServiceException {
        Configuration conf = services.getConf();
        int interval = conf.getInt(CONF_SERVICE_INTERVAL, 300);
        HDFS_LOG_DIR = conf.get(CONF_HDFS_LOG_DIR);
        if (HDFS_LOG_DIR == null || HDFS_LOG_DIR.isEmpty()) {
            throw new ServiceException(ErrorCode.E0307, "hdfs log directory not specified");
        }
        IS_LOG_PURGING_ENABLED = conf.getBoolean(CONF_LOG_PURGE, false);
        OOZIE_INSTANCE_ID = System.getenv("OOZIE_INSTANCE_ID");
        LOGPROGRESS_GET_QUERY = LOGPROGRESS_GET_QUERY + OOZIE_INSTANCE_ID + ".logprogress'";
        LOGPROGRESS_UPDATE_QUERY_WHERE_CLAUSE = LOGPROGRESS_UPDATE_QUERY_WHERE_CLAUSE + OOZIE_INSTANCE_ID + ".logprogress'";
        LOGPROGRESS_INSERT_QUERY = LOGPROGRESS_INSERT_QUERY + "('" + OOZIE_INSTANCE_ID + ".logprogress', '" + CURRENT_LINE_NUMBER + "," + LAST_COMPLETE_LOG_FILE_NAME + "')";
        jdbcConf.put("driver", conf.get("oozie.service.JPAService.jdbc.driver"));
        String url = conf.get("oozie.service.JPAService.jdbc.url");
        jdbcConf.put("url", url);
        jdbcConf.put("user", conf.get("oozie.service.JPAService.jdbc.username"));
        jdbcConf.put("password", services.get(HadoopAccessorService.class).getPasswordFromHadoopConf(conf, "oozie.service.JPAService.jdbc.password"));
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new RuntimeException("Invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        jdbcConf.put("dbtype", dbType);
        XLogCopyService.initLogProgress();
        XLogCopyRunnable runnable = new XLogCopyRunnable(new Path(HDFS_LOG_DIR, OOZIE_INSTANCE_ID).toString());
        services.get(SchedulerService.class).schedule(runnable, 10L, (long)interval, SchedulerService.Unit.SEC);
        this.log.info("XLogCopyService is initialized");
    }

    @Override
    public Class<? extends Service> getInterface() {
        return XLogCopyService.class;
    }

    @Override
    public void destroy() {
        XLogCopyService.updateLogProgress(CURRENT_LINE_NUMBER + "," + LAST_COMPLETE_LOG_FILE_NAME);
    }

    public String getConfHdfsLogDir() {
        return HDFS_LOG_DIR;
    }

    private static void initLogProgress() throws ServiceException {
        Statement st;
        Connection conn;
        String logProgress = "";
        XLog log = XLog.getLog(XLogCopyService.class);
        try {
            Class.forName(jdbcConf.get("driver")).newInstance();
            conn = DriverManager.getConnection(jdbcConf.get("url"), jdbcConf.get("user"), jdbcConf.get("password"));
            try {
                log.info("execute query: " + LOGPROGRESS_GET_QUERY);
                st = conn.createStatement();
                ResultSet rs = st.executeQuery(LOGPROGRESS_GET_QUERY);
                if (rs.next()) {
                    logProgress = rs.getString(1);
                }
                rs.close();
                st.close();
            }
            catch (SQLException ex) {
                throw new ServiceException(ErrorCode.E0170, "cannot query OOZIE_SYS table", ex);
            }
        }
        catch (SQLException ex) {
            throw new ServiceException(ErrorCode.E0600, ex);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0307, ex);
        }
        if (!logProgress.isEmpty()) {
            String[] progressRecord = logProgress.trim().split(",");
            try {
                CURRENT_LINE_NUMBER = Integer.parseInt(progressRecord[0].trim());
            }
            catch (NumberFormatException ex) {
                log.warn("Can not retrieve line number from log progress file, default it to 0");
            }
            LAST_COMPLETE_LOG_FILE_NAME = progressRecord[1].trim();
        } else {
            try {
                Class.forName(jdbcConf.get("driver")).newInstance();
                conn = DriverManager.getConnection(jdbcConf.get("url"), jdbcConf.get("user"), jdbcConf.get("password"));
                try {
                    log.info("insert query is " + LOGPROGRESS_INSERT_QUERY);
                    st = conn.createStatement();
                    st.executeUpdate(LOGPROGRESS_INSERT_QUERY);
                    st.close();
                }
                catch (SQLException ex) {
                    throw new ServiceException(ErrorCode.E0170, "cannot insert into OOZIE_SYS table", ex);
                }
            }
            catch (SQLException ex) {
                throw new ServiceException(ErrorCode.E0600, ex);
            }
            catch (Exception ex) {
                throw new ServiceException(ErrorCode.E0307, ex);
            }
        }
    }

    private static void updateLogProgress(String logProgress) {
        XLog log = XLog.getLog(XLogCopyService.class);
        try {
            Class.forName(jdbcConf.get("driver")).newInstance();
            Connection conn = DriverManager.getConnection(jdbcConf.get("url"), jdbcConf.get("user"), jdbcConf.get("password"));
            try {
                String updateQuery = LOGPROGRESS_UPDATE_QUERY + logProgress + LOGPROGRESS_UPDATE_QUERY_WHERE_CLAUSE;
                log.info("execute query; " + updateQuery);
                Statement st = conn.createStatement();
                st.executeUpdate(updateQuery);
                st.close();
            }
            catch (SQLException ex) {
                log.error("Cannot update logProgress in OOZIE_SYS table: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            log.error("run time error " + ex.getMessage());
        }
    }

    static {
        CURRENT_LINE_NUMBER = 0;
        LAST_COMPLETE_LOG_FILE_NAME = "oozie.log";
        OOZIE_INSTANCE_ID = "";
        jdbcConf = new HashMap();
        LOGPROGRESS_GET_QUERY = "select data from OOZIE_SYS where name = '";
        LOGPROGRESS_UPDATE_QUERY = "update OOZIE_SYS set data = '";
        LOGPROGRESS_UPDATE_QUERY_WHERE_CLAUSE = "' where name = '";
        LOGPROGRESS_INSERT_QUERY = "insert into OOZIE_SYS (name, data) values ";
        IS_LOG_PURGING_ENABLED = false;
    }

    static class XLogCopyRunnable
    implements Runnable {
        private final String hdfsDir;

        public XLogCopyRunnable(String hdfsDir) {
            this.hdfsDir = hdfsDir;
        }

        @Override
        public void run() {
            String[] children;
            XLogService xls = Services.get().get(XLogService.class);
            String oozieLogPath = xls.getOozieLogPath();
            String oozieLogName = xls.getOozieLogName();
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            log.info("hdfs log dir is " + this.hdfsDir);
            if (oozieLogPath != null && oozieLogName != null && (children = new File(oozieLogPath).list()) != null) {
                ArrayList<String> rolloveredFiles = new ArrayList<String>();
                if (oozieLogName.equals(LAST_COMPLETE_LOG_FILE_NAME)) {
                    for (String child : children) {
                        if (!child.startsWith(oozieLogName) || child.equals(oozieLogName)) continue;
                        rolloveredFiles.add(child);
                    }
                } else {
                    long lastFileModifyTime = new File(oozieLogPath, LAST_COMPLETE_LOG_FILE_NAME).lastModified();
                    for (String child : children) {
                        if (child.equals(oozieLogName) || !child.startsWith(oozieLogName) || lastFileModifyTime >= XLogCopyService.getLastModifiedTime(oozieLogPath, child)) continue;
                        rolloveredFiles.add(child);
                    }
                }
                if (!rolloveredFiles.isEmpty()) {
                    String earliestFile = (String)rolloveredFiles.get(0);
                    long earliestTime = XLogCopyService.getLastModifiedTime(oozieLogPath, earliestFile);
                    String latestFile = earliestFile;
                    long latestTime = earliestTime;
                    int earliestIndex = 0;
                    for (int i = 0; i < rolloveredFiles.size(); ++i) {
                        String file = (String)rolloveredFiles.get(i);
                        if (earliestTime > XLogCopyService.getLastModifiedTime(oozieLogPath, file)) {
                            earliestTime = XLogCopyService.getLastModifiedTime(oozieLogPath, file);
                            earliestFile = file;
                            earliestIndex = i;
                        }
                        if (latestTime >= XLogCopyService.getLastModifiedTime(oozieLogPath, file)) continue;
                        latestTime = XLogCopyService.getLastModifiedTime(oozieLogPath, file);
                        latestFile = file;
                    }
                    rolloveredFiles.remove(earliestIndex);
                    this.writeToHdfs(CURRENT_LINE_NUMBER, new File(oozieLogPath, earliestFile));
                    for (String file : rolloveredFiles) {
                        this.writeToHdfs(0, new File(oozieLogPath, file));
                    }
                    LAST_COMPLETE_LOG_FILE_NAME = latestFile;
                    CURRENT_LINE_NUMBER = this.writeToHdfs(0, new File(oozieLogPath, oozieLogName));
                } else {
                    CURRENT_LINE_NUMBER = this.writeToHdfs(CURRENT_LINE_NUMBER, new File(oozieLogPath, oozieLogName));
                }
            }
            XLogCopyService.updateLogProgress(CURRENT_LINE_NUMBER + "," + LAST_COMPLETE_LOG_FILE_NAME);
        }

        private int writeToHdfs(int lineNumber, File file) {
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = new Path(this.hdfsDir).toUri();
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = null;
            HashMap<String, StringBuilder> logMap = new HashMap<String, StringBuilder>();
            Pattern splitterPattern = XLogFilter.getSplitterPattern();
            try {
                BufferedReader br = new BufferedReader(new FileReader(file));
                String currentLine = "";
                Pattern pattern = Pattern.compile("JOB\\[(.*?)\\]");
                for (int i = 0; i < lineNumber; ++i) {
                    br.readLine();
                }
                String jobId = "";
                while ((currentLine = br.readLine()) != null) {
                    Matcher splitter = splitterPattern.matcher(currentLine);
                    if (splitter.matches()) {
                        jobId = "";
                        Matcher matcher = pattern.matcher(currentLine);
                        if (matcher.find()) {
                            jobId = matcher.group(1);
                        }
                    }
                    if (!jobId.trim().equals("-") && !jobId.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        if (logMap.containsKey(jobId)) {
                            sb = (StringBuilder)logMap.get(jobId);
                        }
                        sb.append(currentLine).append("\n");
                        logMap.put(jobId, sb);
                    }
                    ++lineNumber;
                }
                br.close();
                try {
                    fs = has.createFileSystem(System.getProperty("user.name"), uri, (Configuration)fsConf);
                }
                catch (Exception ex) {
                    log.error((Object)"user has to be specified to access hdfs", new HadoopAccessorException(ErrorCode.E0902, "user has to be specified to access FileSystem"));
                }
                for (String id : logMap.keySet()) {
                    Path p = new Path(this.hdfsDir, id + ".log");
                    FSDataOutputStream os = null;
                    os = !fs.exists(p) ? fs.create(p) : fs.append(p);
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
                    bw.write(((StringBuilder)logMap.get(id)).toString());
                    bw.close();
                }
                fs.close();
            }
            catch (FileNotFoundException ex) {
                log.error((Object)(file + " does not exist"), new HadoopAccessorException(ErrorCode.E0902, "cannot locate file: " + file + " on hdfs"));
            }
            catch (IOException ex) {
                log.warn("log copy failed with exception: " + ex.getMessage());
            }
            return lineNumber;
        }
    }
}

