/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.Serializable;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JVMInfo
implements Serializable {
    private static Map<Thread.State, Integer> threadStateOrdering = new HashMap<Thread.State, Integer>();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private List<JThreadInfo> jThreadInfos;
    private String threadSortOrder;
    private Integer cpuMonitorTime = 0;
    private int blockedThreads = 0;
    private int runnableThreads = 0;
    private int waitingThreads = 0;
    private int timedWaitingThreads = 0;
    private int newThreads = 0;
    private int terminatedThreads = 0;

    public String getThreadSortOrder() {
        return this.threadSortOrder;
    }

    public void setThreadSortOrder(String threadSortOrder) {
        this.threadSortOrder = threadSortOrder;
    }

    public String getCpuMonitorTime() {
        return this.cpuMonitorTime.toString();
    }

    public void setCpuMonitorTime(String sleepTime) {
        if (sleepTime != null) {
            this.cpuMonitorTime = Integer.parseInt(sleepTime);
        }
    }

    public String getHeapMemoryUsage() {
        MemoryUsage hmu = this.memoryMXBean.getHeapMemoryUsage();
        StringBuffer sb = new StringBuffer(60);
        sb.append("INIT=").append(hmu.getInit());
        sb.append("&nbsp;&nbsp;USED=").append(hmu.getUsed());
        sb.append("&nbsp;&nbsp;COMMITTED=").append(hmu.getCommitted());
        sb.append("&nbsp;&nbsp;MAX=").append(hmu.getMax());
        return sb.toString();
    }

    public String getNonHeapMemoryUsage() {
        MemoryUsage nhmu = this.memoryMXBean.getNonHeapMemoryUsage();
        StringBuffer sb = new StringBuffer(60);
        sb.append("INIT=").append(nhmu.getInit());
        sb.append("&nbsp;&nbsp;USED=").append(nhmu.getUsed());
        sb.append("&nbsp;&nbsp;COMMITTED=").append(nhmu.getCommitted());
        sb.append("&nbsp;&nbsp;MAX=").append(nhmu.getMax());
        return sb.toString();
    }

    public String getClassLoadingInfo() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("Total Loaded Classes=").append(this.classLoadingMXBean.getTotalLoadedClassCount());
        sb.append("&nbsp;&nbsp;Loaded Classes=").append(this.classLoadingMXBean.getLoadedClassCount());
        sb.append("&nbsp;&nbsp;Unloaded Classes=").append(this.classLoadingMXBean.getUnloadedClassCount());
        return sb.toString();
    }

    public String getThreadInfo() throws InterruptedException {
        this.getThreads();
        StringBuffer sb = new StringBuffer(150);
        sb.append("Thread Count=").append(this.threadMXBean.getThreadCount());
        sb.append("&nbsp;&nbsp;Peak Thread Count=").append(this.threadMXBean.getPeakThreadCount());
        sb.append("&nbsp;&nbsp;Total Started Threads=").append(this.threadMXBean.getTotalStartedThreadCount());
        sb.append("&nbsp;&nbsp;Deamon Threads=").append(this.threadMXBean.getDaemonThreadCount());
        sb.append("<br /> &nbsp;&nbsp;&nbsp;&nbsp;RUNNABLE=").append(this.runnableThreads);
        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;BLOCKED=").append(this.blockedThreads);
        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;WAITING=").append(this.waitingThreads);
        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;TIMED_WAITING=").append(this.timedWaitingThreads);
        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;NEW=").append(this.newThreads);
        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;TERMINATED=").append(this.terminatedThreads);
        sb.append("<br /> &nbsp;&nbsp;&nbsp;&nbsp;Time of Thread Dump=").append(new Date().toString());
        return sb.toString();
    }

    public Collection<JThreadInfo> getThreads() throws InterruptedException {
        if (this.jThreadInfos == null) {
            this.jThreadInfos = this.getThreadInfos();
            Collections.sort(this.jThreadInfos, new ThreadComparator(this.threadSortOrder));
        }
        return this.jThreadInfos;
    }

    private List<JThreadInfo> getThreadInfos() throws InterruptedException {
        ThreadInfo[] threads = this.threadMXBean.dumpAllThreads(false, false);
        HashMap<Long, JThreadInfo> oldThreadInfoMap = new HashMap<Long, JThreadInfo>();
        for (ThreadInfo thread : threads) {
            long cpuTime = -1L;
            long userTime = -1L;
            long threadId = thread.getThreadId();
            if (this.threadMXBean.isThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled()) {
                cpuTime = this.threadMXBean.getThreadCpuTime(threadId);
                userTime = this.threadMXBean.getThreadUserTime(threadId);
            }
            oldThreadInfoMap.put(thread.getThreadId(), new JThreadInfo(cpuTime, userTime, thread));
        }
        Thread.sleep(this.cpuMonitorTime.intValue());
        ThreadInfo[] threadInfos = this.threadMXBean.dumpAllThreads(false, false);
        ArrayList<JThreadInfo> jThreadInfos = new ArrayList<JThreadInfo>(threadInfos.length);
        block9: for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo threadInfo = threadInfos[i];
            long threadId = threadInfo.getThreadId();
            long cpuTime = -1L;
            long userTime = -1L;
            if (this.threadMXBean.isThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled()) {
                JThreadInfo oldThread = (JThreadInfo)oldThreadInfoMap.get(threadInfo.getThreadId());
                if (oldThread == null) {
                    cpuTime = this.threadMXBean.getThreadCpuTime(threadId);
                    userTime = this.threadMXBean.getThreadUserTime(threadId);
                } else {
                    cpuTime = this.threadMXBean.getThreadCpuTime(threadId) - oldThread.getCpuTime();
                    userTime = this.threadMXBean.getThreadUserTime(threadId) - oldThread.getUserTime();
                }
            }
            jThreadInfos.add(new JThreadInfo(cpuTime, userTime, threadInfo));
            switch (threadInfo.getThreadState()) {
                case RUNNABLE: {
                    ++this.runnableThreads;
                    continue block9;
                }
                case BLOCKED: {
                    ++this.blockedThreads;
                    continue block9;
                }
                case WAITING: {
                    ++this.waitingThreads;
                    continue block9;
                }
                case TIMED_WAITING: {
                    ++this.timedWaitingThreads;
                    continue block9;
                }
                case NEW: {
                    ++this.newThreads;
                    continue block9;
                }
                case TERMINATED: {
                    ++this.terminatedThreads;
                }
            }
        }
        return jThreadInfos;
    }

    static {
        threadStateOrdering.put(Thread.State.RUNNABLE, 1);
        threadStateOrdering.put(Thread.State.BLOCKED, 2);
        threadStateOrdering.put(Thread.State.WAITING, 3);
        threadStateOrdering.put(Thread.State.TIMED_WAITING, 4);
        threadStateOrdering.put(Thread.State.NEW, 5);
        threadStateOrdering.put(Thread.State.TERMINATED, 6);
    }

    private static final class ThreadComparator
    implements Comparator<JThreadInfo> {
        private String threadSortOrder;

        public ThreadComparator(String threadSortOrder) {
            this.threadSortOrder = threadSortOrder;
        }

        @Override
        public int compare(JThreadInfo jt1, JThreadInfo jt2) {
            ThreadInfo o1 = jt1.getThreadInfo();
            ThreadInfo o2 = jt2.getThreadInfo();
            if ("cpu".equals(this.threadSortOrder)) {
                int result = (int)(jt2.getCpuTime() - jt1.getCpuTime());
                if (result == 0) {
                    return this.compareId(o1, o2);
                }
                return result;
            }
            if ("name".equals(this.threadSortOrder)) {
                return this.compareName(o1, o2);
            }
            if (o1.getThreadState().equals((Object)o2.getThreadState())) {
                return this.compareName(o1, o2);
            }
            return (Integer)threadStateOrdering.get((Object)o1.getThreadState()) - (Integer)threadStateOrdering.get((Object)o2.getThreadState());
        }

        private int compareId(ThreadInfo o1, ThreadInfo o2) {
            Long id1 = o1.getThreadId();
            Long id2 = o2.getThreadId();
            return id1.compareTo(id2);
        }

        private int compareName(ThreadInfo o1, ThreadInfo o2) {
            int result = o1.getThreadName().compareTo(o2.getThreadName());
            if (result == 0) {
                Long id1 = o1.getThreadId();
                Long id2 = o2.getThreadId();
                return id1.compareTo(id2);
            }
            return result;
        }
    }

    public static final class JThreadInfo {
        private long cpuTime;
        private long userTime;
        private ThreadInfo threadInfo;

        public JThreadInfo(long cpuTime, long userTime, ThreadInfo threadInfo) {
            this.cpuTime = cpuTime;
            this.userTime = userTime;
            this.threadInfo = threadInfo;
        }

        public long getCpuTime() {
            return this.cpuTime;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public ThreadInfo getThreadInfo() {
            return this.threadInfo;
        }
    }
}

