/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.TypeMismatchException;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.IndexImmutSet;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.TypedCollection;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class AssocEndIndexSet
extends IndexImmutSet
implements TypedCollection {
    protected final MOFID metaMofId;
    protected final MOFID metaMofIdOther;
    protected final Class type;
    protected final int maxSize;
    protected final StorableAssociation storable;
    protected final Index secondIndex;
    protected final boolean mutable;
    protected final boolean isAggregate;
    protected final boolean isAggregateOther;
    protected final boolean isIndexed;
    protected final boolean isIndexedOther;
    protected final StorableObject keyObject;

    protected AssocEndIndexSet(StorableAssociation storable, MOFID metaMofId, MOFID metaMofIdOther, MultivaluedIndex index, Object indexKey, Index secondIndex, Class type, int max, boolean mutable, boolean isAggregate, boolean isAggregateOther, boolean isIndexed, boolean isIndexedOther) {
        super(storable.getMdrStorage(), index, indexKey);
        this.metaMofId = metaMofId;
        this.metaMofIdOther = metaMofIdOther;
        this.type = type;
        this.maxSize = max;
        this.storable = storable;
        this.secondIndex = secondIndex;
        this.mutable = mutable;
        this.isAggregate = isAggregate;
        this.isAggregateOther = isAggregateOther;
        this.isIndexed = isIndexed;
        this.isIndexedOther = isIndexedOther;
        if (isAggregate || isAggregateOther || isIndexed) {
            try {
                this.keyObject = (StorableObject)this.storage.getObject((MOFID)indexKey);
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        } else {
            this.keyObject = null;
        }
    }

    public void checkType(Object obj) {
        if (!this.mutable) {
            throw new UnsupportedOperationException();
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!this.type.isInstance(obj)) {
            throw new TypeMismatchException(this.type, obj, this.getMetaElement());
        }
    }

    protected void checkMaxSize(int size) {
        if (this.type == null) {
            throw new UnsupportedOperationException();
        }
        if (this.maxSize != -1 && this.maxSize < size + this.size()) {
            throw new WrongSizeException(this.getMetaElement());
        }
    }

    protected RefObject getMetaElement() {
        try {
            return (RefObject)this.storage.getRepository().getHandler(this.storage.getObject(this.metaMofId));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Iterator iterator() {
        return new IndexIterator(this.getObjects().iterator());
    }

    public boolean remove(Object o) {
        try {
            boolean result;
            StorableObject so = null;
            if (this.isAggregate) {
                this.keyObject.clearComposite();
            } else if (this.isAggregateOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)o);
                }
                so.clearComposite();
            }
            if (this.isIndexed) {
                this.keyObject.removeFromIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)o);
                }
                so.removeFromIndex(this.metaMofIdOther);
            }
            if (result = this.index.remove(this.indexKey, o)) {
                if (this.secondIndex instanceof SinglevaluedIndex) {
                    this.secondIndex.remove(o);
                } else {
                    ((MultivaluedIndex)this.secondIndex).remove(o, this.indexKey);
                }
            }
            if (this.isIndexed) {
                this.keyObject.addToIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                so.addToIndex(this.metaMofIdOther);
            }
            return result;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public boolean add(Object obj) {
        this.checkMaxSize(1);
        try {
            StorableObject so = null;
            if (this.isAggregate) {
                this.keyObject.setComposite((MOFID)obj, (MOFID)obj, this.metaMofId);
            } else if (this.isAggregateOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)obj);
                }
                so.setComposite(this.keyObject, (MOFID)obj, this.metaMofId);
            }
            if (this.isIndexed) {
                this.keyObject.removeFromIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)obj);
                }
                so.removeFromIndex(this.metaMofIdOther);
            }
            this.index.add(this.indexKey, obj);
            this.secondIndex.add(obj, this.indexKey);
            if (this.isIndexed) {
                this.keyObject.addToIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                so.addToIndex(this.metaMofIdOther);
            }
            return true;
        }
        catch (StorageBadRequestException e) {
            return false;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public boolean removeAll(Collection collection) {
        throw new DebugException();
    }

    public boolean addAll(Collection collection) {
        throw new DebugException();
    }

    public boolean retainAll(Collection collection) {
        throw new DebugException();
    }

    public void clear() {
        throw new DebugException();
    }

    protected class IndexIterator
    extends IndexImmutSet.IndexImmutIterator {
        protected Object lastRead = null;

        protected IndexIterator(Iterator innerIterator) {
            super(innerIterator);
        }

        public Object next() {
            this.lastRead = super.next();
            return this.lastRead;
        }

        public void remove() {
            this.innerIterator.remove();
            try {
                if (AssocEndIndexSet.this.isAggregate) {
                    AssocEndIndexSet.this.keyObject.clearComposite();
                } else if (AssocEndIndexSet.this.isAggregateOther) {
                    ((StorableObject)this.lastRead).clearComposite();
                }
                if (AssocEndIndexSet.this.isIndexed) {
                    AssocEndIndexSet.this.keyObject.removeFromIndex(AssocEndIndexSet.this.metaMofId);
                }
                if (AssocEndIndexSet.this.isIndexedOther) {
                    ((StorableObject)this.lastRead).removeFromIndex(AssocEndIndexSet.this.metaMofIdOther);
                }
                MOFID key = ((StorableBaseObject)this.lastRead).getMofId();
                if (AssocEndIndexSet.this.secondIndex instanceof MultivaluedIndex) {
                    ((MultivaluedIndex)AssocEndIndexSet.this.secondIndex).remove(key, AssocEndIndexSet.this.indexKey);
                } else {
                    AssocEndIndexSet.this.secondIndex.remove(key);
                }
                if (AssocEndIndexSet.this.isIndexed) {
                    AssocEndIndexSet.this.keyObject.addToIndex(AssocEndIndexSet.this.metaMofId);
                }
                if (AssocEndIndexSet.this.isIndexedOther) {
                    ((StorableObject)this.lastRead).addToIndex(AssocEndIndexSet.this.metaMofIdOther);
                }
            }
            catch (StorageException e) {
                throw new DebugException();
            }
        }
    }
}

