/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.TypeMismatchException;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.AssocEndIndexSet;
import org.netbeans.mdr.storagemodel.AssocEndIndexUList;
import org.netbeans.mdr.storagemodel.AssociationLink;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorableAssociation
extends StorableBaseObject
implements Streamable {
    private transient Index aIndex;
    private transient Index bIndex;
    private String endA;
    private String endB;
    private MOFID endAId;
    private MOFID endBId;
    private transient boolean multiValuedA;
    private transient boolean multiValuedB;
    private int minA;
    private int maxA;
    private int minB;
    private int maxB;
    private transient Class typeA;
    private transient Class typeB;
    private int typeANameIndex;
    private int typeBNameIndex;
    private boolean orderedA;
    private boolean orderedB;
    private boolean aggrA;
    private boolean aggrB;
    private boolean indexedA;
    private boolean indexedB;
    private Class associationSuperclass = null;
    private final Object superclassMutex = new Object();
    static /* synthetic */ Class class$0;

    public StorableAssociation() {
    }

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        this.endAId = (MOFID)table.get(this.endAId);
        this.endBId = (MOFID)table.get(this.endBId);
        this.objectChanged();
    }

    public StorableAssociation(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, String endA, MOFID endAId, String endB, MOFID endBId, Class typeA, Class typeB, int minA, int maxA, int minB, int maxB, boolean orderedA, boolean orderedB, boolean uniqueA, boolean uniqueB, boolean aggrA, boolean aggrB, boolean indexedA, boolean indexedB) throws StorageException {
        super(mdrStorage, immediatePackage, meta);
        this.endA = endA;
        this.endB = endB;
        this.endAId = endAId;
        this.endBId = endBId;
        this.orderedA = orderedA;
        this.orderedB = orderedB;
        this.multiValuedA = maxA != 1;
        this.multiValuedB = maxB != 1;
        this.aggrA = aggrA;
        this.aggrB = aggrB;
        this.minA = minA;
        this.minB = minB;
        this.maxA = maxA;
        this.maxB = maxB;
        this.typeA = typeA;
        this.typeB = typeB;
        this.indexedA = indexedA;
        this.indexedB = indexedB;
        this.typeANameIndex = mdrStorage.values(this.getMofId()).store(typeA.getName());
        this.typeBNameIndex = mdrStorage.values(this.getMofId()).store(typeB.getName());
        this.aIndex = this.createIndex(this.multiValuedA, orderedA, uniqueA, 1);
        this.bIndex = this.createIndex(this.multiValuedB, orderedB, uniqueB, 2);
        this.getMdrStorage().addObject(this);
        this.initFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAssociationSuperclass() throws StorageException, ClassNotFoundException {
        if (this.associationSuperclass == null) {
            Object object = this.superclassMutex;
            synchronized (object) {
                if (this.associationSuperclass == null) {
                    this.objectWillChange();
                    this.associationSuperclass = this.resolveAssociationSuperclass();
                    this.objectChanged();
                }
            }
        }
        return this.associationSuperclass;
    }

    private Class resolveAssociationSuperclass() throws StorageException, ClassNotFoundException {
        try {
            return BaseObjectHandler.resolveImplementation(TagSupport.getImplFullName(this.getMetaObject(), 0));
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.netbeans.mdr.handlers.AssociationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    public Class getAssociationCustomImpl() {
        try {
            Class sup = this.getAssociationSuperclass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.netbeans.mdr.handlers.AssociationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return sup == clazz ? null : sup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isMultivaluedA() {
        return this.multiValuedA;
    }

    public boolean isMultivaluedB() {
        return this.multiValuedB;
    }

    public boolean isOrderedA() {
        return this.orderedA;
    }

    public boolean isOrderedB() {
        return this.orderedB;
    }

    public boolean isAggregateA() {
        return this.aggrA;
    }

    public boolean isAggregateB() {
        return this.aggrB;
    }

    public boolean isIndexedA() {
        return this.indexedA;
    }

    public boolean isIndexedB() {
        return this.indexedB;
    }

    public String getEnd1Name() {
        return this.endA;
    }

    public String getEnd2Name() {
        return this.endB;
    }

    public MOFID getEnd1Id() {
        return this.endAId;
    }

    public MOFID getEnd2Id() {
        return this.endBId;
    }

    public boolean linkExists(MOFID a, MOFID b) throws StorageException {
        if (this.isMultivaluedB()) {
            return ((MultivaluedIndex)this.bIndex).getItems(a).contains(b);
        }
        return b.equals(((SinglevaluedIndex)this.bIndex).getIfExists(a));
    }

    public Collection getAllLinks() throws StorageException {
        return new LinkSetCollection();
    }

    public Object queryObjects(String endName, MOFID obj) throws StorageException {
        boolean otherAggr;
        boolean isOtherIndexed;
        boolean isIndexed;
        MOFID otherEndId;
        MOFID endId;
        int max;
        boolean isEndA = endName.equals(this.endB);
        boolean multi = isEndA ? this.multiValuedA : this.multiValuedB;
        boolean order = isEndA ? this.orderedA : this.orderedB;
        Index index = isEndA ? this.aIndex : this.bIndex;
        Index secondIndex = isEndA ? this.bIndex : this.aIndex;
        Class type = isEndA ? this.typeA : this.typeB;
        int n = max = isEndA ? this.maxA : this.maxB;
        if (isEndA) {
            endId = this.endAId;
            otherEndId = this.endBId;
            isIndexed = this.indexedA;
            isOtherIndexed = this.indexedB;
        } else {
            endId = this.endBId;
            otherEndId = this.endAId;
            isIndexed = this.indexedB;
            isOtherIndexed = this.indexedA;
        }
        boolean aggr = isEndA ? this.aggrA : this.aggrB;
        boolean bl = otherAggr = isEndA ? this.aggrB : this.aggrA;
        if (obj == null) {
            throw new NullPointerException();
        }
        Object result = multi ? (order ? new AssocEndIndexUList(this, endId, otherEndId, (MultivaluedOrderedIndex)index, (Object)obj, secondIndex, type, max, true, aggr, otherAggr, isIndexed, isOtherIndexed) : new AssocEndIndexSet(this, endId, otherEndId, (MultivaluedIndex)index, obj, secondIndex, type, max, true, aggr, otherAggr, isIndexed, isOtherIndexed)) : this.getMdrStorage().getObjectFromIndexIfExists((SinglevaluedIndex)index, obj);
        return result;
    }

    public void verify(Collection violations) throws StorageException {
        try {
            Class clazz = this.getAssociationSuperclass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.netbeans.mdr.handlers.AssociationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                Iterator it = this.aIndex.keySet().iterator();
                while (it.hasNext()) {
                    this.verifyEnd(violations, this.endB, (MOFID)it.next());
                }
                it = this.bIndex.keySet().iterator();
                while (it.hasNext()) {
                    this.verifyEnd(violations, this.endA, (MOFID)it.next());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public void verifyEnd(Collection violations, String end, MOFID object) throws StorageException {
        try {
            Class clazz = this.getAssociationSuperclass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.netbeans.mdr.handlers.AssociationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                int min = end.equals(this.endB) ? this.minA : this.minB;
                MOFID endId = end.equals(this.endB) ? this.endAId : this.endBId;
                Object result = this.queryObjects(end, object);
                if (result == null && min > 0 || result instanceof Collection && ((Collection)result).size() < min) {
                    violations.add(new WrongSizeException((RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(endId)), "Not enough objects linked to " + object + " at end '" + end + "'."));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public void checkType(Object endA, Object endB) {
        try {
            if (endA != null && !this.typeA.isInstance(endA)) {
                throw new TypeMismatchException(this.typeB, endB, (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(this.endBId)));
            }
            if (endB != null && !this.typeB.isInstance(endB)) {
                throw new TypeMismatchException(this.typeB, endB, (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(this.endBId)));
            }
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        throw new DebugException();
    }

    public boolean addLink(MOFID a, MOFID b) throws StorageException {
        if (this.multiValuedA) {
            return ((Collection)this.queryObjects(this.endB, b)).add(a);
        }
        if (this.multiValuedB) {
            return ((Collection)this.queryObjects(this.endA, a)).add(b);
        }
        try {
            StorableObject oA = null;
            StorableObject oB = null;
            oA = (StorableObject)this.getMdrStorage().getObject(a);
            oB = (StorableObject)this.getMdrStorage().getObject(b);
            if (this.indexedA) {
                oB.removeFromIndex(this.endAId);
            }
            if (this.indexedB) {
                oA.removeFromIndex(this.endBId);
            }
            if (this.aggrA) {
                oB.setComposite(oA, a, this.endAId);
            } else if (this.aggrB) {
                oA.setComposite(oB, b, this.endBId);
            }
            this.aIndex.add(b, a);
            this.bIndex.add(a, b);
            if (this.indexedA) {
                oB.addToIndex(this.endAId);
            }
            if (this.indexedB) {
                oA.addToIndex(this.endBId);
            }
            return true;
        }
        catch (StorageBadRequestException e) {
            return false;
        }
    }

    public boolean removeLink(MOFID a, MOFID b) throws StorageException {
        try {
            StorableObject oA = null;
            StorableObject oB = null;
            oA = (StorableObject)this.getMdrStorage().getObject(a);
            oB = (StorableObject)this.getMdrStorage().getObject(b);
            if (this.indexedA) {
                oB.removeFromIndex(this.endAId);
            }
            if (this.indexedB) {
                oA.removeFromIndex(this.endBId);
            }
            if (this.aggrA) {
                oB.clearComposite();
            } else if (this.aggrB) {
                oA.clearComposite();
            }
            this.removeLinkEnd(b, a, this.aIndex, this.multiValuedA);
            this.removeLinkEnd(a, b, this.bIndex, this.multiValuedB);
            if (this.indexedA) {
                oB.addToIndex(this.endAId);
            }
            if (this.indexedB) {
                oA.addToIndex(this.endBId);
            }
            return true;
        }
        catch (StorageBadRequestException e) {
            return false;
        }
    }

    protected Index getIndex(String end) throws StorageException {
        if (end.equals(this.endA)) {
            return this.aIndex;
        }
        if (end.equals(this.endB)) {
            return this.bIndex;
        }
        return null;
    }

    protected Index findIndex(int end) throws StorageException {
        return this.getMdrStorage().getIndex(this.getOutermostPackageId(), this.getMofId(), end);
    }

    private void removeLinkEnd(MOFID a, MOFID b, Index index, boolean multi) throws StorageException {
        if (multi) {
            ((MultivaluedIndex)index).remove(a, b);
        } else {
            ((SinglevaluedIndex)index).remove(a);
        }
    }

    protected Index createIndex(boolean multi, boolean ordered, boolean unique, int end) throws StorageException {
        if (multi) {
            if (ordered) {
                return this.getMdrStorage().createMultivaluedOrderedIndex(this.getOutermostPackageId(), this.getMofId(), end, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique);
            }
            return this.getMdrStorage().createMultivaluedIndex(this.getOutermostPackageId(), this.getMofId(), end, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique);
        }
        return this.getMdrStorage().createSinglevaluedIndex(this.getOutermostPackageId(), this.getMofId(), end, Storage.EntryType.MOFID, Storage.EntryType.MOFID);
    }

    protected void deleteIndex(MOFID opkgId, MOFID mofId, int index) throws StorageException {
        this.getMdrStorage().dropIndex(opkgId, mofId, index);
    }

    protected void deleteRecursive() throws StorageException {
        this.deleteIndex(this.getOutermostPackageId(), this.getMofId(), 1);
        this.deleteIndex(this.getOutermostPackageId(), this.getMofId(), 2);
        super.deleteRecursive();
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.meta, this);
            IOUtils.write(outputStream, this.immediatePackage, this);
            IOUtils.writeString(outputStream, this.endA);
            IOUtils.writeString(outputStream, this.endB);
            IOUtils.write(outputStream, this.endAId, this);
            IOUtils.write(outputStream, this.endBId, this);
            IOUtils.writeInt(outputStream, this.minA);
            IOUtils.writeInt(outputStream, this.maxA);
            IOUtils.writeInt(outputStream, this.minB);
            IOUtils.writeInt(outputStream, this.maxB);
            IOUtils.writeBoolean(outputStream, this.aggrA);
            IOUtils.writeBoolean(outputStream, this.aggrB);
            IOUtils.writeBoolean(outputStream, this.orderedA);
            IOUtils.writeBoolean(outputStream, this.orderedB);
            IOUtils.writeInt(outputStream, this.typeANameIndex);
            IOUtils.writeInt(outputStream, this.typeBNameIndex);
            IOUtils.writeBoolean(outputStream, this.indexedA);
            IOUtils.writeBoolean(outputStream, this.indexedB);
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            this.meta = (MOFID)IOUtils.read(inputStream, this);
            this.immediatePackage = (MOFID)IOUtils.read(inputStream, this);
            this.endA = IOUtils.readString(inputStream);
            this.endB = IOUtils.readString(inputStream);
            this.endAId = (MOFID)IOUtils.read(inputStream, this);
            this.endBId = (MOFID)IOUtils.read(inputStream, this);
            this.minA = IOUtils.readInt(inputStream);
            this.maxA = IOUtils.readInt(inputStream);
            this.minB = IOUtils.readInt(inputStream);
            this.maxB = IOUtils.readInt(inputStream);
            this.multiValuedA = this.maxA != 1;
            this.multiValuedB = this.maxB != 1;
            this.aggrA = IOUtils.readBoolean(inputStream);
            this.aggrB = IOUtils.readBoolean(inputStream);
            this.orderedA = IOUtils.readBoolean(inputStream);
            this.orderedB = IOUtils.readBoolean(inputStream);
            this.typeANameIndex = IOUtils.readInt(inputStream);
            this.typeBNameIndex = IOUtils.readInt(inputStream);
            this.aIndex = this.findIndex(1);
            this.bIndex = this.findIndex(2);
            this.typeA = BaseObjectHandler.resolveInterface((String)this.getMdrStorage().values(this.getMofId()).resolve(this.typeANameIndex));
            this.typeB = BaseObjectHandler.resolveInterface((String)this.getMdrStorage().values(this.getMofId()).resolve(this.typeBNameIndex));
            this.indexedA = IOUtils.readBoolean(inputStream);
            this.indexedB = IOUtils.readBoolean(inputStream);
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (StorageException ex) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)ex);
        }
        catch (ClassNotFoundException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    protected class LinkSetCollection
    extends AbstractCollection {
        protected LinkSetCollection() {
        }

        public Iterator iterator() {
            return new LinkSetIterator();
        }

        public int size() {
            try {
                int size = 0;
                Iterator as = StorableAssociation.this.bIndex.keySet().iterator();
                while (as.hasNext()) {
                    MOFID aID = (MOFID)as.next();
                    if (StorableAssociation.this.isMultivaluedB()) {
                        size += StorableAssociation.this.getMdrStorage().getObjectsFromIndex((MultivaluedIndex)StorableAssociation.this.bIndex, aID).size();
                        continue;
                    }
                    ++size;
                }
                return size;
            }
            catch (StorageException se) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)se);
            }
        }
    }

    protected class LinkSetIterator
    implements Iterator {
        boolean initialized = false;
        Iterator as = null;
        MOFID aID = null;
        StorableObject a = null;
        Iterator bs = null;
        StorableObject b = null;

        protected LinkSetIterator() {
        }

        private void initCheck() {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    this.as = StorableAssociation.this.bIndex.keySet().iterator();
                }
                catch (StorageException se) {
                    this.as = null;
                }
                this.fetchNext();
            }
        }

        /*
         * Exception decompiling
         */
        private void fetchNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean hasNext() {
            this.initCheck();
            return this.b != null;
        }

        public Object next() {
            this.initCheck();
            if (this.b == null) {
                throw new NoSuchElementException();
            }
            if (this.a == null) {
                try {
                    this.a = (StorableObject)StorableAssociation.this.getMdrStorage().getObject(this.aID);
                }
                catch (StorageException se) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)se);
                }
            }
            AssociationLink link = new AssociationLink(this.a, this.b);
            this.fetchNext();
            return link;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

