/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.mapreduce.ExportCallOutputFormat;
import org.apache.sqoop.mapreduce.JdbcExportJob;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DBOutputFormat;

public class JdbcCallExportJob
extends JdbcExportJob {
    public static final String SQOOP_EXPORT_CALL_KEY = "sqoop.export.call";
    public static final Log LOG = LogFactory.getLog((String)JdbcCallExportJob.class.getName());

    public JdbcCallExportJob(ExportJobContext context) {
        super(context, null, null, ExportCallOutputFormat.class);
    }

    public JdbcCallExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        super.propagateOptionsToJob(job);
        job.getConfiguration().set(SQOOP_EXPORT_CALL_KEY, this.options.getCall());
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws IOException {
        String procedureName = job.getConfiguration().get(SQOOP_EXPORT_CALL_KEY);
        ConnManager mgr = this.context.getConnManager();
        try {
            if (Strings.isNullOrEmpty((String)this.options.getUsername())) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getConnectionParams());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getUsername(), this.options.getPassword(), this.options.getConnectionParams());
            }
            String[] colNames = this.options.getColumns();
            if (null == colNames) {
                colNames = mgr.getColumnNamesForProcedure(procedureName);
            }
            DBOutputFormat.setOutput(job, mgr.escapeTableName(procedureName), mgr.escapeColNames(colNames));
            job.setOutputFormatClass(this.getOutputFormatClass());
            job.getConfiguration().set("sqoop.mapreduce.export.table.class", tableClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load OutputFormat", cnfe);
        }
    }
}

