/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.validation.AbortOnFailureHandler;
import org.apache.sqoop.validation.AbsoluteValidationThreshold;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;
import org.apache.sqoop.validation.ValidationFailureHandler;
import org.apache.sqoop.validation.ValidationThreshold;
import org.apache.sqoop.validation.Validator;

public class RowCountValidator
implements Validator {
    public static final Log LOG = LogFactory.getLog((String)RowCountValidator.class.getName());

    @Override
    public boolean validate(ValidationContext context) throws ValidationException {
        return this.validate(context, AbsoluteValidationThreshold.INSTANCE, AbortOnFailureHandler.INSTANCE);
    }

    @Override
    public boolean validate(ValidationContext validationContext, ValidationThreshold validationThreshold, ValidationFailureHandler validationFailureHandler) throws ValidationException {
        LOG.debug((Object)("Validating data using row counts: Source [" + validationContext.getSourceRowCount() + "] with Target[" + validationContext.getTargetRowCount() + "]"));
        if (validationThreshold.compare(Long.valueOf(validationContext.getSourceRowCount()), Long.valueOf(validationContext.getTargetRowCount()))) {
            LOG.info((Object)"Data successfully validated");
            return true;
        }
        validationContext.setMessage(this.getClass().getSimpleName());
        validationContext.setReason("The expected counter value was " + validationContext.getSourceRowCount() + " but the actual value was " + validationContext.getTargetRowCount());
        return validationFailureHandler.handle(validationContext);
    }
}

