/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.ClassConstants;
import org.datanucleus.identity.OID;
import org.datanucleus.util.Localiser;

public class OIDImplKodo
implements Serializable,
OID,
Comparable {
    protected static final transient Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static final transient String oidSeparator = "-";
    public final Object oid;
    public final String pcClass;
    public final String toString;
    public final int hashCode;

    public OIDImplKodo() {
        this.oid = null;
        this.pcClass = null;
        this.toString = null;
        this.hashCode = -1;
    }

    public OIDImplKodo(String pcClass, Object object) {
        this.pcClass = pcClass;
        this.oid = object;
        StringBuilder s = new StringBuilder();
        s.append(this.pcClass);
        s.append(oidSeparator);
        s.append(this.oid.toString());
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public OIDImplKodo(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        int separatorPosition = str.indexOf(oidSeparator);
        this.pcClass = str.substring(0, separatorPosition);
        String oidStr = str.substring(separatorPosition + 1);
        Object oidValue = null;
        try {
            oidValue = Long.valueOf(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.oid = oidValue;
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    @Override
    public Object getKeyValue() {
        return this.oid;
    }

    @Override
    public String getPcClass() {
        return this.pcClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(OIDImplKodo.class.getName())) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((OID)obj).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof OIDImplKodo) {
            OIDImplKodo c = (OIDImplKodo)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

