/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.cluster.service.locator.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.api.initializer.ClusterInitializer;

public class NamedClusterServiceLocatorImpl
implements NamedClusterServiceLocator {
    public static final String SERVICE_RANKING = "service.ranking";
    private final Multimap<Class<?>, ServiceFactoryAndRanking<?>> serviceFactoryMap;
    private final ReadWriteLock readWriteLock;
    private final ClusterInitializer clusterInitializer;

    public NamedClusterServiceLocatorImpl(ClusterInitializer clusterInitializer) {
        this.clusterInitializer = clusterInitializer;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.serviceFactoryMap = Multimaps.newSortedSetMultimap(new HashMap(), (Supplier)new Supplier<SortedSet<ServiceFactoryAndRanking<?>>>(){

            public SortedSet<ServiceFactoryAndRanking<?>> get() {
                return new TreeSet(new Comparator<ServiceFactoryAndRanking<?>>(){

                    @Override
                    public int compare(ServiceFactoryAndRanking<?> o1, ServiceFactoryAndRanking<?> o2) {
                        if (o1.ranking == o2.ranking) {
                            return o1.namedClusterServiceFactory.toString().compareTo(o2.namedClusterServiceFactory.toString());
                        }
                        return o2.ranking - o1.ranking;
                    }
                });
            }
        });
    }

    @VisibleForTesting
    Multimap<Class<?>, ServiceFactoryAndRanking<?>> getServiceFactoryMap() {
        return this.serviceFactoryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void factoryAdded(NamedClusterServiceFactory<?> namedClusterServiceFactory, Map properties) {
        if (namedClusterServiceFactory == null) {
            return;
        }
        Class<?> serviceClass = namedClusterServiceFactory.getServiceClass();
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            this.serviceFactoryMap.get(serviceClass).add(new ServiceFactoryAndRanking((Integer)properties.get(SERVICE_RANKING), namedClusterServiceFactory));
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void factoryRemoved(NamedClusterServiceFactory<?> namedClusterServiceFactory, Map properties) {
        if (namedClusterServiceFactory == null) {
            return;
        }
        Class<?> serviceClass = namedClusterServiceFactory.getServiceClass();
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            this.serviceFactoryMap.remove(serviceClass, new ServiceFactoryAndRanking((Integer)properties.get(SERVICE_RANKING), namedClusterServiceFactory));
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getService(NamedCluster namedCluster, Class<T> serviceClass) throws ClusterInitializationException {
        block5: {
            this.clusterInitializer.initialize(namedCluster);
            Lock readLock = this.readWriteLock.readLock();
            try {
                readLock.lock();
                Collection serviceFactoryAndRankings = this.serviceFactoryMap.get(serviceClass);
                if (serviceFactoryAndRankings == null) break block5;
                for (ServiceFactoryAndRanking serviceFactoryAndRanking : serviceFactoryAndRankings) {
                    if (!serviceFactoryAndRanking.namedClusterServiceFactory.canHandle(namedCluster)) continue;
                    T t = serviceClass.cast(serviceFactoryAndRanking.namedClusterServiceFactory.create(namedCluster));
                    return t;
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }

    static class ServiceFactoryAndRanking<T> {
        final int ranking;
        final NamedClusterServiceFactory<T> namedClusterServiceFactory;

        ServiceFactoryAndRanking(Integer ranking, NamedClusterServiceFactory<T> namedClusterServiceFactory) {
            this.ranking = ranking == null ? 0 : ranking;
            this.namedClusterServiceFactory = namedClusterServiceFactory;
        }
    }
}

