/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Matcher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount;
    int cbtHook;
    String[] items = new String[0];
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.SendMessage(this.handle, 323, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n || n > n3) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 330, n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n2 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        int n = -1;
        if (!this.noSelection) {
            n = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n != -1) {
            OS.SendMessage(this.handle, 334, n, 0);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    void applyEditSegments() {
        int n;
        int n2;
        if (--this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) {
            return;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        int n4 = OS.GetWindowTextLength(n3);
        int n5 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n5, n4 + 1);
        if (n4 > 0) {
            OS.GetWindowText(n3, tCHAR, n4 + 1);
        }
        String string = tCHAR.toString(0, n4);
        this.segments = null;
        Event event = this.getSegments(string);
        if (event == null || event.segments == null) {
            return;
        }
        this.segments = event.segments;
        int n6 = this.segments.length;
        if (n6 == 0) {
            return;
        }
        char[] cArray = event.segmentsChars;
        int n7 = OS.SendMessage(n3, 213, 0, 0) & Integer.MAX_VALUE;
        OS.SendMessage(n3, 197, n7 + Math.min(n6, LIMIT - n7), 0);
        char[] cArray2 = new char[(n4 += n6) + 1];
        int n8 = 0;
        int n9 = 0;
        int n10 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n8 < n4) {
            if (n9 < n6 && n8 - n9 == this.segments[n9]) {
                n = cArray != null && cArray.length > n9 ? cArray[n9] : n2;
                cArray2[n8++] = n;
                ++n9;
                continue;
            }
            if (string == null) continue;
            cArray2[n8] = string.charAt(n8++ - n9);
        }
        while (n9 < n6) {
            this.segments[n9] = n8 - n9;
            n = cArray != null && cArray.length > n9 ? cArray[n9] : n2;
            cArray2[n8++] = n;
            ++n9;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(n3, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        boolean bl = this.ignoreCharacter;
        boolean bl2 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        cArray2[n4] = '\u0000';
        tCHAR = new TCHAR(n5, cArray2, false);
        OS.SendMessage(n3, 177, 0, -1);
        int n11 = OS.SendMessage(n3, 198, 0, 0);
        OS.SendMessage(n3, 194, n11, tCHAR);
        nArray[0] = this.translateOffset(nArray[0]);
        nArray2[0] = this.translateOffset(nArray2[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        if (cArray != null && cArray.length > 0) {
            int n12 = this.state & 0x400000;
            if (cArray[0] == '\u202b') {
                super.updateTextDirection(0x4000000);
            } else if (cArray[0] == '\u202a') {
                super.updateTextDirection(0x2000000);
            }
            this.state |= n12;
        }
        OS.SendMessage(n3, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl;
        this.ignoreModify = bl2;
    }

    void applyListSegments() {
        boolean bl;
        int n = OS.SendMessage(this.handle, 326, 0, 0);
        if (n == -1) {
            return;
        }
        boolean bl2 = bl = this.items.length != n;
        if (bl) {
            this.items = new String[n];
        }
        int n2 = this.items.length;
        int n3 = -1;
        int n4 = this.getCodePage();
        if (!this.noSelection) {
            n3 = OS.SendMessage(this.handle, 327, 0, 0);
        }
        while (n2-- > 0) {
            String string;
            TCHAR tCHAR = null;
            if (bl) {
                int n5 = OS.SendMessage(this.handle, 329, n2, 0);
                if (n5 == -1) {
                    this.error(1);
                }
                if (OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(n4, n5 + 1)) == -1) {
                    return;
                }
                this.items[n2] = string = tCHAR.toString(0, n5);
            } else {
                string = this.items[n2];
            }
            if (OS.SendMessage(this.handle, 324, n2, 0) == -1) {
                return;
            }
            if (tCHAR == null) {
                tCHAR = new TCHAR(n4, string, true);
            }
            if (OS.SendMessage(this.handle, 330, n2, tCHAR) != -1) continue;
            return;
        }
        if (n3 != -1) {
            OS.SendMessage(this.handle, 334, n3, 0);
        }
    }

    @Override
    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.handle) {
            switch (n2) {
                case 5: {
                    this.ignoreResize = true;
                    boolean bl = this.lockText;
                    if ((this.style & 8) == 0) {
                        this.lockText = true;
                    }
                    int n5 = OS.CallWindowProc(ComboProc, n, n2, n3, n4);
                    if ((this.style & 8) == 0) {
                        this.lockText = bl;
                    }
                    this.ignoreResize = false;
                    return n5;
                }
            }
            return OS.CallWindowProc(ComboProc, n, n2, n3, n4);
        }
        int n6 = OS.GetDlgItem(this.handle, 1001);
        if (n == n6) {
            if (this.lockText && n2 == 12) {
                int n7 = OS.GetProcessHeap();
                int n8 = OS.GetWindowTextLength(this.handle);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n8 + 1);
                OS.GetWindowText(this.handle, tCHAR, n8 + 1);
                int n9 = tCHAR.length() * TCHAR.sizeof;
                int n10 = OS.HeapAlloc(n7, 8, n9);
                OS.MoveMemory(n10, tCHAR, n9);
                int n11 = OS.CallWindowProc(EditProc, n6, n2, n3, n10);
                OS.HeapFree(n7, 0, n10);
                return n11;
            }
            return OS.CallWindowProc(EditProc, n, n2, n3, n4);
        }
        int n12 = OS.GetDlgItem(this.handle, 1000);
        if (n == n12) {
            return OS.CallWindowProc(ListProc, n, n2, n3, n4);
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    int CBTProc(int n, int n2, int n3) {
        if (n == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n2, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n4 = OS.GetWindowLong(n2, -16);
                OS.SetWindowLong(n2, -16, n4 & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, n, n2, n3);
    }

    @Override
    boolean checkHandle(int n) {
        return n == this.handle || n == OS.GetDlgItem(this.handle, 1001) || n == OS.GetDlgItem(this.handle, 1000);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    void clearSegments(boolean bl) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        int n3 = OS.SendMessage(n2, 213, 0, 0) & Integer.MAX_VALUE;
        if (n3 < LIMIT) {
            OS.SendMessage(n2, 197, Math.max(1, n3 - n), 0);
        }
        if (!bl) {
            this.segments = null;
            return;
        }
        boolean bl2 = this.ignoreCharacter;
        boolean bl3 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int n4 = OS.GetWindowTextLength(n2);
        int n5 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n5, n4 + 1);
        if (n4 > 0) {
            OS.GetWindowText(n2, tCHAR, n4 + 1);
        }
        tCHAR = this.deprocessText(tCHAR, 0, -1, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(n2, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        nArray[0] = this.untranslateOffset(nArray[0]);
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        this.segments = null;
        OS.SendMessage(n2, 177, 0, -1);
        int n6 = OS.SendMessage(n2, 198, 0, 0);
        OS.SendMessage(n2, 194, n6, tCHAR);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(n2, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl2;
        this.ignoreModify = bl3;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        if (n == -1) {
            n5 = 0;
            n4 = OS.GetDC(this.handle);
            n3 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n3 != 0) {
                n5 = OS.SelectObject(n4, n3);
            }
            int n8 = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rECT = new RECT();
            int n9 = 3072;
            if ((this.style & 8) == 0) {
                n9 |= 0x2000;
            }
            int n10 = OS.GetWindowTextLength(this.handle);
            int n11 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n11, n10 + 1);
            OS.GetWindowText(this.handle, tCHAR, n10 + 1);
            OS.DrawText(n4, tCHAR, n10, rECT, n9);
            n6 = Math.max(n6, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n6 = Math.max(n6, this.scrollWidth);
            } else {
                for (int i = 0; i < n8; ++i) {
                    int n12;
                    n10 = OS.SendMessage(this.handle, 329, i, 0);
                    if (n10 == -1) continue;
                    if (n10 + 1 > tCHAR.length()) {
                        tCHAR = new TCHAR(n11, n10 + 1);
                    }
                    if ((n12 = OS.SendMessage(this.handle, 328, i, tCHAR)) == -1) continue;
                    OS.DrawText(n4, tCHAR, n10, rECT, n9);
                    n6 = Math.max(n6, rECT.right - rECT.left);
                }
            }
            if (n3 != 0) {
                OS.SelectObject(n4, n5);
            }
            OS.ReleaseDC(this.handle, n4);
        }
        if (n2 == -1 && (this.style & 0x40) != 0) {
            n3 = OS.SendMessage(this.handle, 326, 0, 0);
            n5 = OS.SendMessage(this.handle, 340, 0, 0);
            n7 = n3 * n5;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n != -1) {
            n6 = n;
        }
        if (n2 != -1) {
            n7 = n2;
        }
        if ((this.style & 8) != 0) {
            n6 += 8;
        } else {
            n3 = OS.GetDlgItem(this.handle, 1001);
            if (n3 != 0) {
                n5 = OS.SendMessage(n3, 212, 0, 0);
                n4 = OS.LOWORD(n5) + OS.HIWORD(n5);
                n6 += n4 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n6 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n7 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n5 = OS.GetSystemMetrics(45);
            n6 += OS.GetSystemMetrics(2) + n5 * 2;
            n4 = OS.SendMessage(this.handle, 340, -1, 0);
            n7 = (this.style & 4) != 0 ? n4 + 6 : (n7 += n4 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n7 += OS.GetSystemMetrics(3);
        }
        return new Point(n6, n7);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    @Override
    void createHandle() {
        int n;
        int n2;
        int n3;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            n3 = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            n2 = callback.getAddress();
            if (n2 == 0) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, n2, 0, n3);
            super.createHandle();
            if (this.cbtHook != 0) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLongPtr(n3, -4);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLongPtr(n, -4);
        }
        if ((this.style & 0x40) != 0) {
            n2 = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, n2);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n2);
        }
    }

    @Override
    void createWidget() {
        int n;
        super.createWidget();
        this.visibleCount = 5;
        if ((this.style & 0x40) == 0 && (n = OS.SendMessage(this.handle, 340, 0, 0)) != -1 && n != 0) {
            int n2 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n2 = (rECT.bottom - rECT.top) / 3;
            } else {
                int n3 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n3, mONITORINFO);
                n2 = (mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top) / 3;
            }
            this.visibleCount = Math.max(this.visibleCount, n2 / n);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR tCHAR, int n, int n2, boolean bl) {
        char[] cArray;
        if (tCHAR == null || this.segments == null) {
            return tCHAR;
        }
        int n3 = tCHAR.length();
        if (n3 == 0) {
            return tCHAR;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return tCHAR;
        }
        if (n < 0) {
            n = 0;
        }
        if (OS.IsUnicode) {
            cArray = tCHAR.chars;
            if (tCHAR.chars[n3 - 1] == '\u0000') {
                --n3;
            }
        } else {
            cArray = new char[n3];
            n3 = OS.MultiByteToWideChar(this.getCodePage(), 1, tCHAR.bytes, n3, cArray, n3);
        }
        if (n2 == -1) {
            n2 = n3;
        }
        if (n2 > this.segments[0] && n <= this.segments[n4 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            for (int i = n; i < n2; ++i) {
                if (n6 < n4 && i - n6 == this.segments[n6]) {
                    ++n6;
                    continue;
                }
                cArray[i - n6 + n5] = cArray[i];
            }
            n3 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n3) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
            return new TCHAR(this.getCodePage(), cArray2, bl);
        }
        return tCHAR;
    }

    @Override
    void deregister() {
        int n;
        super.deregister();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.removeControl(n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(n);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 327, 0, 0);
        if (n != n2) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    @Override
    boolean dragDetect(int n, int n2, int n3, boolean bl, boolean[] blArray, boolean[] blArray2) {
        int n4;
        if (bl && (this.style & 8) == 0 && (n4 = OS.GetDlgItem(this.handle, 1001)) != 0) {
            int n5;
            int n6;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n6 = OS.LOWORD(OS.SendMessage(n4, 215, 0, n5 = OS.MAKELPARAM(n2, n3)))) && n6 < nArray2[0] && super.dragDetect(n, n2, n3, bl, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, n3, bl, blArray, blArray2);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        int n = this.translateOffset(this.getCaretPosition());
        int n2 = OS.GetDlgItem(this.handle, 1001);
        int n3 = OS.SendMessage(n2, 214, n, 0);
        if (n3 == -1) {
            n3 = 0;
            if (n >= OS.GetWindowTextLength(n2)) {
                int n4 = this.getCodePage();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(n2, 176, nArray, nArray2);
                OS.SendMessage(n2, 177, n, n);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(n2, 194, 0, new TCHAR(n4, " ", true));
                n3 = OS.SendMessage(n2, 214, n, 0);
                OS.SendMessage(n2, 177, n, n + 1);
                OS.SendMessage(n2, 194, 0, new TCHAR(n4, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(n2, 177, nArray[0], nArray[0]);
                OS.SendMessage(n2, 177, nArray[0], nArray2[0]);
            }
        }
        POINT pOINT = new POINT();
        pOINT.x = OS.GET_X_LPARAM(n3);
        pOINT.y = OS.GET_Y_LPARAM(n3);
        OS.MapWindowPoints(n2, this.handle, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = OS.GetDlgItem(this.handle, 1001);
        OS.SendMessage(n, 176, nArray, nArray2);
        int n2 = nArray[0];
        if (nArray[0] != nArray2[0] && !OS.IsWinCE) {
            POINT pOINT;
            int n3 = OS.GetWindowThreadProcessId(n, null);
            GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
            gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
            if (OS.GetGUIThreadInfo(n3, gUITHREADINFO) && (gUITHREADINFO.hwndCaret == n || gUITHREADINFO.hwndCaret == 0) && OS.GetCaretPos(pOINT = new POINT())) {
                int n4 = OS.SendMessage(n, 214, nArray2[0], 0);
                if (n4 == -1) {
                    int n5 = OS.SendMessage(n, 214, nArray[0], 0);
                    int n6 = OS.GET_X_LPARAM(n5);
                    if (pOINT.x > n6) {
                        n2 = nArray2[0];
                    }
                } else {
                    int n7 = OS.GET_X_LPARAM(n4);
                    if (pOINT.x >= n7) {
                        n2 = nArray2[0];
                    }
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.mbcsToWcsPos(n2);
        }
        return this.untranslateOffset(n2);
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 329, n, 0);
        if (n2 != -1) {
            if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                return this.items[n];
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
            int n3 = OS.SendMessage(this.handle, 328, n, tCHAR);
            if (n3 != -1) {
                return tCHAR.toString(0, n2);
            }
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 <= n && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 326, 0, 0);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        int n = OS.SendMessage(this.handle, 340, 0, 0);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0, 0) != 0;
        }
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, bl ? 1 : 0, 0);
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    Event getSegments(String string) {
        int n;
        Event event = null;
        if (this.hooks(49) || this.filters(49)) {
            event = new Event();
            event.text = string;
            this.sendEvent(49, event);
            if (event != null && event.segments != null) {
                int n2;
                int n3 = event.segments.length;
                int n4 = n2 = string == null ? 0 : string.length();
                for (n = 1; n < n3; ++n) {
                    if (event.segments[n] >= event.segments[n - 1] && event.segments[n] <= n2) continue;
                    SWT.error(5);
                }
            }
        }
        if ((this.state & 0x400000) != 0) {
            n = BidiUtil.resolveTextDirection(string);
            if (n == 0) {
                n = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
            }
            int[] nArray = null;
            char[] cArray = null;
            if (event == null) {
                event = new Event();
            } else {
                nArray = event.segments;
                cArray = event.segmentsChars;
            }
            int n5 = nArray == null ? 0 : nArray.length;
            event.segments = new int[n5 + 1];
            event.segmentsChars = new char[n5 + 1];
            if (nArray != null) {
                System.arraycopy(nArray, 0, event.segments, 1, n5);
            }
            if (cArray != null) {
                System.arraycopy(cArray, 0, event.segmentsChars, 1, n5);
            }
            event.segments[0] = 0;
            event.segmentsChars[0] = n == 0x4000000 ? 8235 : 8234;
        }
        return event;
    }

    String getSegmentsText(String string, Event event) {
        int n;
        int n2;
        if (string == null || event == null) {
            return string;
        }
        int[] nArray = event.segments;
        if (nArray == null) {
            return string;
        }
        int n3 = nArray.length;
        if (n3 == 0) {
            return string;
        }
        char[] cArray = event.segmentsChars;
        int n4 = string.length();
        char[] cArray2 = new char[n4];
        string.getChars(0, n4, cArray2, 0);
        char[] cArray3 = new char[n4 + n3];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n5 < n4) {
            if (n6 < n3 && n5 == nArray[n6]) {
                n = cArray != null && cArray.length > n6 ? cArray[n6] : n2;
                cArray3[n5 + n6++] = n;
                continue;
            }
            cArray3[n5 + n6] = cArray2[n5++];
        }
        while (n6 < n3) {
            nArray[n6] = n5;
            n = cArray != null && cArray.length > n6 ? cArray[n6] : n2;
            cArray3[n5 + n6++] = n;
        }
        return new String(cArray3, 0, cArray3.length);
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(this.untranslateOffset(nArray[0]), this.untranslateOffset(nArray2[0]));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
            return tCHAR.toString();
        }
        return tCHAR.toString(0, n);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n = OS.SendMessage(this.handle, 340, -1, 0);
        if (n == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n + 6 : n + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.GetDlgItem(this.handle, 1001);
        if (n == 0) {
            return LIMIT;
        }
        int n2 = OS.SendMessage(n, 213, 0, 0) & Integer.MAX_VALUE;
        if (this.segments != null && n2 < LIMIT) {
            n2 = Math.max(1, n2 - this.segments.length);
        }
        return n2;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    boolean hasFocus() {
        int n = OS.GetFocus();
        if (n == this.handle) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n == n2) {
            return true;
        }
        int n3 = OS.GetDlgItem(this.handle, 1000);
        return n == n3;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            for (int i = n; i < n2; ++i) {
                if (!string.equals(this.getItem(i))) continue;
                return i;
            }
            return -1;
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n || n >= n3) {
            return -1;
        }
        int n4 = n - 1;
        int n5 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n4 = OS.SendMessage(this.handle, 344, n5 = n4, tCHAR)) != -1 && n4 > n5) continue;
            return -1;
        } while (!string.equals(this.getItem(n4)));
        return n4;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return n;
        }
        int n3 = OS.GetWindowTextLengthA(n2);
        if (n3 == 0) {
            return 0;
        }
        if (n >= n3) {
            return n3;
        }
        byte[] byArray = new byte[n3 + 1];
        OS.GetWindowTextA(n2, byArray, n3 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    @Override
    void register() {
        int n;
        super.register();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            this.display.addControl(n2, this);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(n, this);
        }
    }

    public void remove(int n) {
        this.checkWidget();
        this.remove(n, true);
    }

    void remove(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = OS.SendMessage(this.handle, 329, n, 0);
            if (n4 == -1) {
                n3 = OS.SendMessage(this.handle, 326, 0, 0);
                if (0 <= n && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = OS.SendMessage(this.handle, 326, 0, 0);
                if (0 <= n && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = OS.GetWindowTextLength(this.handle);
        n3 = OS.SendMessage(this.handle, 324, n, 0);
        if (n3 == -1) {
            n2 = OS.SendMessage(this.handle, 326, 0, 0);
            if (0 <= n && n < n2) {
                this.error(15);
            }
            this.error(6);
        } else if (n3 == 0) {
            OS.SendMessage(this.handle, 331, 0, 0);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl && n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n5 = OS.GetDC(this.handle);
            n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n6 = OS.SelectObject(n5, n7);
            }
        }
        int n9 = this.getCodePage();
        int n10 = 3104;
        for (int i = n; i <= n2; ++i) {
            int n11;
            int n12;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n12 = OS.SendMessage(this.handle, 329, n, 0)) == -1 || (n11 = OS.SendMessage(this.handle, 328, n, tCHAR = new TCHAR(n9, n12 + 1))) == -1)) break;
            n12 = OS.SendMessage(this.handle, 324, n, 0);
            if (n12 == -1) {
                this.error(15);
            } else if (n12 == 0) {
                OS.SendMessage(this.handle, 331, 0, 0);
            }
            if ((this.style & 0x100) == 0) continue;
            OS.DrawText(n5, tCHAR, -1, rECT, n10);
            n8 = Math.max(n8, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n7 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
            this.setScrollWidth(n8, false);
        }
        if (n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        int n = -1;
        if (!this.noSelection) {
            n = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n != -1) {
            OS.SendMessage(this.handle, 334, n, 0);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    @Override
    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, n3, n4, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c = event.character;
        int n5 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n5 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && OS.GetDlgItem(this.handle, 1001) == OS.GetCapture()) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n6 = OS.GetDlgItem(this.handle, 1001);
        if (n6 == 0) {
            return true;
        }
        OS.SendMessage(n6, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n6, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n7 = OS.GetWindowTextLength(n6);
                if (nArray[0] == n7) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n6, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n7);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(n6, 177, nArray[0], nArray2[0]);
        OS.SendMessage(n6, 194, 0, (TCHAR)object);
        return false;
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 <= n && n < n2) {
            int n3 = OS.SendMessage(this.handle, 327, 0, 0);
            int n4 = OS.SendMessage(this.handle, 334, n, 0);
            if (n4 != -1 && n4 != n3) {
                this.sendEvent(24);
            }
        }
    }

    @Override
    void setBackgroundImage(int n) {
        int n2;
        super.setBackgroundImage(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    @Override
    void setBackgroundPixel(int n) {
        int n2;
        super.setBackgroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    @Override
    void setBoundsInPixels(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 4) != 0) {
            int n6 = this.getItemCount() == 0 ? 5 : this.visibleCount;
            n4 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n6 + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0, rECT) != 0) {
                int n7 = rECT.right - rECT.left;
                int n8 = rECT.bottom - rECT.top;
                if (n7 == n3 && n8 == n4) {
                    n5 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
        } else {
            super.setBoundsInPixels(n, n2, n3, n4, n5);
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        boolean bl = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        super.setFont(font);
        if ((this.style & 8) == 0) {
            this.lockText = bl;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    @Override
    void setForegroundPixel(int n) {
        int n2;
        super.setForegroundPixel(n);
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.InvalidateRect(n3, null, true);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n2, null, true);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getSelectionIndex();
        this.remove(n, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n);
        if (n2 != -1) {
            this.select(n2);
        }
    }

    public void setItems(String ... stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            this.error(5);
        }
        RECT rECT = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n = OS.GetDC(this.handle);
            n3 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n3 != 0) {
                n2 = OS.SelectObject(n, n3);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int n5 = this.getCodePage();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            TCHAR tCHAR = new TCHAR(n5, string, true);
            int n6 = OS.SendMessage(this.handle, 323, 0, tCHAR);
            if (n6 == -1) {
                this.error(14);
            }
            if (n6 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) == 0) continue;
            int n7 = 3104;
            OS.DrawText(n, tCHAR, -1, rECT, n7);
            n4 = Math.max(n4, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n3 != 0) {
                OS.SelectObject(n, n2);
            }
            OS.ReleaseDC(this.handle, n);
            this.setScrollWidth(n4 + 3);
        }
        this.sendEvent(24);
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = this.getCodePage();
        int n6 = OS.SendMessage(this.handle, 326, 0, 0);
        int n7 = 3104;
        for (int i = 0; i < n6; ++i) {
            TCHAR tCHAR;
            int n8;
            int n9 = OS.SendMessage(this.handle, 329, i, 0);
            if (n9 == -1 || (n8 = OS.SendMessage(this.handle, 328, i, tCHAR = new TCHAR(n5, n9 + 1))) == -1) continue;
            OS.DrawText(n3, tCHAR, -1, rECT, n7);
            n = Math.max(n, rECT.right - rECT.left);
        }
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(n + 3);
    }

    void setScrollWidth(int n) {
        int n2;
        this.scrollWidth = n;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, n, 0);
            return;
        }
        boolean bl = false;
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n3 > 3) {
            n2 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n2 = (rECT.right - rECT.left) / 4;
            } else {
                int n4 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n4, mONITORINFO);
                n2 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            bl = n > n2;
        }
        n2 = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (bl) {
            OS.SendMessage(this.handle, 352, 0, 0);
            OS.SendMessage(this.handle, 350, n, 0);
        } else {
            OS.SendMessage(this.handle, 352, n += OS.GetSystemMetrics(3), 0);
            OS.SendMessage(this.handle, 350, 0, 0);
        }
        if ((this.style & 8) == 0) {
            this.lockText = n2;
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        int n4 = 3104;
        OS.DrawText(n2, tCHAR, -1, rECT, n4);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        if (bl) {
            if (n <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n + 3);
        } else {
            if (n < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = this.translateOffset(point.x);
        int n2 = this.translateOffset(point.y);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
            n2 = this.wcsToMbcsPos(n2);
        }
        int n3 = OS.MAKELPARAM(n, n2);
        OS.SendMessage(this.handle, 322, 0, n3);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
            return;
        }
        this.clearSegments(false);
        int n = LIMIT;
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0) {
            n = OS.SendMessage(n2, 213, 0, 0) & Integer.MAX_VALUE;
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.applyEditSegments();
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.segments != null && n > 0) {
            OS.SendMessage(this.handle, 321, n + Math.min(this.segments.length, LIMIT - n), 0);
        } else {
            OS.SendMessage(this.handle, 321, n, 0);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        int n = OS.GetDlgItem(this.handle, 1001);
        int n2 = OS.GetDlgItem(this.handle, 1000);
        if (n != 0) {
            shell.setToolTipText(n, string);
        }
        if (n2 != 0) {
            shell.setToolTipText(n2, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        this.updateDropDownHeight();
    }

    @Override
    void subclass() {
        int n;
        super.subclass();
        int n2 = this.display.windowProc;
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            OS.SetWindowLongPtr(n3, -4, n2);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLongPtr(n, -4, n2);
        }
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    @Override
    boolean translateTraversal(MSG mSG) {
        switch (mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    @Override
    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    @Override
    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseReturn();
    }

    @Override
    void unsubclass() {
        int n;
        super.unsubclass();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 != 0 && EditProc != 0) {
            OS.SetWindowLongPtr(n2, -4, EditProc);
        }
        if ((n = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLongPtr(n, -4, ListProc);
        }
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    void updateDropDownHeight() {
        if ((this.style & 4) != 0) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 338, 0, rECT);
            int n = this.getItemCount() == 0 ? 5 : this.visibleCount;
            int n2 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n + 2;
            if (n2 != rECT.bottom - rECT.top) {
                this.forceResize();
                OS.GetWindowRect(this.handle, rECT);
                int n3 = 54;
                this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, n2, n3);
            }
        }
    }

    @Override
    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            if (n == 0x6000000 && !OS.IsUnicode) {
                this.state &= 0xFFBFFFFF;
                return false;
            }
            this.clearSegments(true);
            this.applyEditSegments();
            this.applyListSegments();
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        int n;
        int n2 = OS.GetWindowLong(this.handle, -20);
        n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, n2 &= 0xFFFFDFFF);
        int n3 = 0;
        int n4 = 0;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n3 = cOMBOBOXINFO.hwndItem;
            n4 = cOMBOBOXINFO.hwndList;
        }
        if (n3 != 0) {
            n = OS.GetWindowLong(n3, -20);
            int n5 = OS.GetWindowLong(n3, -16);
            if ((this.style & 0x4000000) != 0) {
                n |= 0x3000;
                n5 |= 2;
            } else {
                n &= 0xFFFFCFFF;
                n5 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(n3, -20, n);
            OS.SetWindowLong(n3, -16, n5);
            RECT rECT = new RECT();
            OS.GetWindowRect(n3, rECT);
            int n6 = rECT.right - rECT.left;
            int n7 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n8 = rECT.right - rECT.left;
            int n9 = rECT.bottom - rECT.top;
            int n10 = 22;
            this.SetWindowPos(n3, 0, 0, 0, n6 - 1, n7 - 1, n10);
            this.SetWindowPos(this.handle, 0, 0, 0, n8 - 1, n9 - 1, n10);
            this.SetWindowPos(n3, 0, 0, 0, n6, n7, n10);
            this.SetWindowPos(this.handle, 0, 0, 0, n8, n9, n10);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (n4 != 0) {
            n = OS.GetWindowLong(n4, -20);
            n = (this.style & 0x4000000) != 0 ? (n |= 0x400000) : (n &= 0xFFBFFFFF);
            OS.SetWindowLong(n4, -20, n);
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        event2.start = this.untranslateOffset(event2.start);
        event2.end = this.untranslateOffset(event2.end);
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return n;
        }
        int n3 = OS.GetWindowTextLengthA(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3 + 1];
        OS.GetWindowTextA(n2, byArray, n3 + 1);
        int n4 = 0;
        for (int i = 0; n4 < n3 && n != i; ++i) {
            if (!OS.IsDBCSLeadByte(byArray[n4++])) continue;
            ++n4;
        }
        return n4;
    }

    @Override
    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    @Override
    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n | 1;
        }
        if ((this.style & 8) != 0) {
            return n | 3;
        }
        return n | 2;
    }

    @Override
    TCHAR windowClass() {
        return ComboClass;
    }

    @Override
    int windowProc() {
        return ComboProc;
    }

    @Override
    int windowProc(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.handle == 0) {
            return 0;
        }
        if (n != this.handle) {
            n6 = OS.GetDlgItem(this.handle, 1001);
            n5 = OS.GetDlgItem(this.handle, 1000);
            if (n6 != 0 && n == n6 || n5 != 0 && n == n5) {
                LRESULT lRESULT = null;
                boolean bl = false;
                boolean bl2 = false;
                switch (n2) {
                    case 258: {
                        bl = (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) && !this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0;
                        lRESULT = this.wmChar(n, n3, n4);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(n, n3, n4);
                        break;
                    }
                    case 256: {
                        bl = n3 == 46 && (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0);
                        lRESULT = this.wmKeyDown(n, n3, n4);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(n, n3, n4);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(n, n3, n4);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(n, n3, n4);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(n, n3, n4);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(n, n3, n4);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(n, n3, n4);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(n, n3, n4);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(n, n3, n4);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(n, n3, n4);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(n, n3, n4);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(n, n3, n4);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(n, n3, n4);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(n, n3, n4);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(n, n3, n4);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(n, n3, n4);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(n, n3, n4);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(n, n3, n4);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(n, n3, n4);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(n, n3, n4);
                        break;
                    }
                    case 198: {
                        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                        return 0;
                    }
                    case 199: 
                    case 772: {
                        if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                            return 0;
                        }
                    }
                    case 768: 
                    case 769: 
                    case 770: 
                    case 771: {
                        bl = this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0;
                    }
                    case 12: {
                        if (n != n6) break;
                        lRESULT = this.wmClipboard(n, n2, n3, n4);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                if (bl) {
                    if (this.getDrawing() && OS.IsWindowVisible(n6)) {
                        bl2 = true;
                        OS.DefWindowProc(n6, 11, 0, 0);
                    }
                    this.clearSegments(true);
                    int n7 = this.callWindowProc(n, n2, n3, n4);
                    this.applyEditSegments();
                    if (bl2) {
                        OS.DefWindowProc(n6, 11, 1, 0);
                        OS.InvalidateRect(n6, null, true);
                    }
                    return n7;
                }
                return this.callWindowProc(n, n2, n3, n4);
            }
        }
        switch (n2) {
            case 334: {
                Object object;
                n6 = -1;
                n5 = n3;
                if ((this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
                    object = this.getText();
                    String string = null;
                    if (n3 == -1) {
                        string = "";
                    } else if (0 <= n3 && n3 < this.getItemCount()) {
                        string = this.getItem(n3);
                    }
                    if (string != null && !string.equals(object)) {
                        int n8 = OS.GetWindowTextLength(this.handle);
                        object = string;
                        if ((string = this.verifyText(string, 0, n8, null)) == null) {
                            return 0;
                        }
                        if (!string.equals(object) && (n5 = this.indexOf(string)) != -1 && n5 != n3) {
                            return this.callWindowProc(this.handle, 334, n5, n4);
                        }
                    }
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0 || (n6 = super.windowProc(n, n2, n3, n4)) == -1 || n6 == -2) break;
                object = this.getSegments(this.items[n5]);
                int[] nArray = this.segments = object != null ? ((Event)object).segments : null;
                if (((Event)object).segmentsChars != null) {
                    int n9 = this.state & 0x400000;
                    if (((Event)object).segmentsChars[0] == '\u202b') {
                        super.updateTextDirection(0x4000000);
                    } else if (((Event)object).segmentsChars[0] == '\u202a') {
                        super.updateTextDirection(0x2000000);
                    }
                    this.state |= n9;
                }
                return n6;
            }
            case 323: 
            case 330: 
            case 344: {
                int n10;
                if (n4 == 0 || !this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                n6 = -1;
                n5 = OS.IsUnicode ? OS.wcslen(n4) : OS.strlen(n4);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n5);
                OS.MoveMemory(tCHAR, n4, tCHAR.length() * TCHAR.sizeof);
                String string = tCHAR.toString(0, n5);
                Event event = this.getSegments(string);
                if (event != null && event.segments != null) {
                    tCHAR = new TCHAR(this.getCodePage(), this.getSegmentsText(string, event), true);
                    n10 = OS.GetProcessHeap();
                    n5 = tCHAR.length() * TCHAR.sizeof;
                    int n11 = OS.HeapAlloc(n10, 8, n5);
                    OS.MoveMemory(n11, tCHAR, n5);
                    n6 = super.windowProc(n, n2, n3, n11);
                    OS.HeapFree(n10, 0, n11);
                }
                if (n2 == 323 || n2 == 330) {
                    n10 = n2 == 323 ? this.items.length : n3;
                    String[] stringArray = new String[this.items.length + 1];
                    System.arraycopy(this.items, 0, stringArray, 0, n10);
                    stringArray[n10] = string;
                    System.arraycopy(this.items, n10, stringArray, n10 + 1, this.items.length - n10);
                    this.items = stringArray;
                }
                if (n6 == -1 || n6 == -2) break;
                return n6;
            }
            case 324: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                n6 = super.windowProc(n, n2, n3, n4);
                if (n6 != -1 && n6 != -2) {
                    n5 = n3;
                    if (this.items.length == 1) {
                        this.items = new String[0];
                    } else if (this.items.length > 1) {
                        String[] stringArray = new String[this.items.length - 1];
                        System.arraycopy(this.items, 0, stringArray, 0, n5);
                        System.arraycopy(this.items, n5 + 1, stringArray, n5, this.items.length - n5 - 1);
                        this.items = stringArray;
                    }
                    if (!this.noSelection && (n5 = OS.SendMessage(this.handle, 327, 0, 0)) == n3) {
                        this.clearSegments(false);
                        this.applyEditSegments();
                    }
                }
                return n6;
            }
            case 331: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                if (this.items.length > 0) {
                    this.items = new String[0];
                }
                this.clearSegments(false);
                this.applyEditSegments();
            }
        }
        return super.windowProc(n, n2, n3, n4);
    }

    @Override
    LRESULT WM_CTLCOLOR(int n, int n2) {
        return this.wmColorChild(n, n2);
    }

    @Override
    LRESULT WM_GETDLGCODE(int n, int n2) {
        int n3 = this.callWindowProc(this.handle, 135, n, n2);
        return new LRESULT(n3 | 1);
    }

    @Override
    LRESULT WM_KILLFOCUS(int n, int n2) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(n, n2);
        }
        return null;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        int n3;
        int n4 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n4 != (n3 = OS.SendMessage(this.handle, 327, 0, 0))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendSelectionEvent(13, null, true);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(int n, int n2) {
        return null;
    }

    @Override
    LRESULT WM_SIZE(int n, int n2) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(n, n2);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    int n3;
                    int n4 = OS.GetDlgItem(this.handle, 1001);
                    if (n4 != 0) {
                        OS.InvalidateRect(n4, null, true);
                    }
                    if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
                        OS.InvalidateRect(n3, null, true);
                    }
                } else {
                    int n5 = 133;
                    OS.RedrawWindow(this.handle, null, 0, n5);
                }
            }
            return lRESULT;
        }
        boolean bl = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if ((this.style & 8) == 0) {
            this.lockText = bl;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int n, int n2) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 1) == 0) {
                wINDOWPOS.flags |= 8;
                OS.MoveMemory(n2, wINDOWPOS, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n3 = rECT.right - rECT.left;
                int n4 = rECT.bottom - rECT.top;
                if (n3 != 0 && n4 != 0) {
                    int n5;
                    int n6 = this.parent.handle;
                    int n7 = OS.GetWindow(n6, 5);
                    OS.MapWindowPoints(0, n6, rECT, 2);
                    int n8 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                    while (n7 != 0) {
                        if (n7 != this.handle) {
                            OS.GetWindowRect(n7, rECT);
                            OS.MapWindowPoints(0, n6, rECT, 2);
                            n5 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                            OS.CombineRgn(n8, n8, n5, 4);
                            OS.DeleteObject(n5);
                        }
                        n7 = OS.GetWindow(n7, 2);
                    }
                    n5 = 1029;
                    OS.RedrawWindow(n6, null, n8, n5);
                    OS.DeleteObject(n8);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmChar(int n, int n2, int n3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.sendSelectionEvent(14);
                }
                this.ignoreDefaultSelection = false;
                if (this.getSelectionIndex() == -1 && (this.style & 4) != 0 && (this.style & 8) == 0) {
                    if (OS.SendMessage(this.handle, 343, 0, 0) != 0) {
                        OS.SendMessage(this.handle, 335, 0, 0);
                    }
                    return LRESULT.ZERO;
                }
            }
            case 27: {
                if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) == 0) {
                    return LRESULT.ZERO;
                }
            }
            case 127: {
                String string;
                Matcher matcher;
                if (OS.GetKeyState(17) >= 0) break;
                if ((this.style & 8) != 0) {
                    return LRESULT.ZERO;
                }
                Point point = this.getSelection();
                int n4 = OS.GetDlgItem(this.handle, 1001);
                int n5 = point.x;
                int n6 = point.y;
                if (n5 == n6 && (matcher = CTRL_BS_PATTERN.matcher(string = this.getText().substring(0, n5))).find()) {
                    n5 = matcher.start();
                    n6 = matcher.end();
                    OS.SendMessage(n4, 177, n5, n6);
                }
                if (n5 < n6) {
                    OS.SendMessage(n4, 194, 1, 0);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n, int n2, int n3, int n4) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n2) {
            case 768: 
            case 771: {
                OS.SendMessage(n, 176, nArray, nArray2);
                if (this.untranslateOffset(nArray[0]) == this.untranslateOffset(nArray2[0])) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(n, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                int n5 = OS.GetWindowTextLength(n);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n, 176, (int[])object, nArray3);
                if (n5 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n5 + 1);
                    OS.GetWindowText(n, tCHAR, n5 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                OS.SendMessage(n, 176, nArray, nArray2);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                if (this.lockText) {
                    return null;
                }
                nArray2[0] = OS.GetWindowTextLength(n);
                int n5 = OS.IsUnicode ? OS.wcslen(n4) : OS.strlen(n4);
                object = new TCHAR(this.getCodePage(), n5);
                int n6 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, n4, n6);
                string = ((TCHAR)object).toString(0, n5);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, n, n2, n3, n4);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n2 == 12) {
                    int n7 = OS.GetProcessHeap();
                    int n8 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n9 = OS.HeapAlloc(n7, 8, n8);
                    OS.MoveMemory(n9, (TCHAR)object, n8);
                    int n10 = OS.CallWindowProc(EditProc, n, n2, n3, n9);
                    OS.HeapFree(n7, 0, n9);
                    return new LRESULT(n10);
                }
                OS.SendMessage(n, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    @Override
    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n4 = OS.SendMessage(this.handle, 327, 0, 0);
                if (n4 != -1) {
                    OS.SendMessage(this.handle, 334, n4, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 7: {
                this.setCursor();
                this.updateDropDownHeight();
                break;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    int n5 = n2;
                    int n6 = OS.GetWindowLong(n5, -20);
                    int n7 = OS.GetWindowLong(n5, -16);
                    if (n3 == 1792) {
                        n6 |= 0x3000;
                        n7 |= 2;
                    } else {
                        n6 &= 0xFFFFCFFF;
                        n7 &= 0xFFFFFFFD;
                    }
                    OS.SetWindowLong(n5, -20, n6);
                    OS.SetWindowLong(n5, -16, n7);
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                this.clearSegments(true);
                this.state &= 0xFFBFFFFF;
                this.applyEditSegments();
            }
        }
        return super.wmCommandChild(n, n2);
    }

    @Override
    LRESULT wmIMEChar(int n, int n2, int n3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n2, n3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n4 = this.callWindowProc(n, 646, n2, n3);
        MSG mSG = new MSG();
        int n5 = 10420227;
        while (OS.PeekMessage(mSG, n, 258, 258, n5)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n2, n3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n4);
    }

    @Override
    LRESULT wmKeyDown(int n, int n2, int n3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        switch (n2) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (this.segments == null) break;
                int n4 = 0;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.SendMessage(this.handle, 320, nArray, nArray2);
                while (true) {
                    n4 = this.callWindowProc(n, 256, n2, n3);
                    OS.SendMessage(this.handle, 320, nArray3, nArray4);
                    if (nArray3[0] != nArray[0] ? this.untranslateOffset(nArray3[0]) != this.untranslateOffset(nArray[0]) : nArray4[0] == nArray2[0] || this.untranslateOffset(nArray4[0]) != this.untranslateOffset(nArray2[0])) break;
                    nArray[0] = nArray3[0];
                    nArray2[0] = nArray4[0];
                }
                lRESULT = n4 == 0 ? LRESULT.ZERO : new LRESULT(n4);
                break;
            }
            case 13: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                this.ignoreDefaultSelection = true;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmSysKeyDown(int n, int n2, int n3) {
        int n4 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.wmSysKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n2 == 40) {
            int n5 = this.callWindowProc(n, 260, n2, n3);
            int n6 = OS.SendMessage(this.handle, 327, 0, 0);
            if (n4 != n6) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13, null, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(n5);
        }
        return lRESULT;
    }

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }
}

