/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hadoop.hive.jdbc.HiveDriver;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.VersionInfo;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.GenericTransCombiner;
import org.pentaho.hadoop.mapreduce.GenericTransReduce;
import org.pentaho.hadoop.mapreduce.PentahoMapRunnable;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.ShimVersion;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.DistributedCacheUtil;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.DistributedCacheUtilImpl;
import org.pentaho.hadoop.shim.common.DriverProxyInvocationChain;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.common.fs.FileSystemProxy;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hdfs.vfs.HDFSFileProvider;

public class CommonHadoopShim
implements HadoopShim {
    private DistributedCacheUtil dcUtil;
    protected static Map<String, Class<? extends Driver>> JDBC_DRIVER_MAP = new HashMap<String, Class<? extends Driver>>(){
        {
            this.put("hive", HiveDriver.class);
        }
    };
    protected static Map<String, String> JDBC_POSSIBLE_DRIVER_MAP = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<? extends Driver> tryToLoadDriver(String driverClassName) {
        Class<?> possibleDriver = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            possibleDriver = Class.forName(driverClassName);
            if (Driver.class.isAssignableFrom(possibleDriver)) {
                Class<?> clazz = possibleDriver;
                return clazz;
            }
            try {
                throw new ClassCastException("Specified extra driver class does not extends java.sql.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException e2) {
                e2.printStackTrace();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public ShimVersion getVersion() {
        return new ShimVersion(1, 0);
    }

    public String getHadoopVersion() {
        return VersionInfo.getVersion();
    }

    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        fsm.addProvider(config, "hdfs", config.getIdentifier(), (FileProvider)new HDFSFileProvider());
        this.setDistributedCacheUtil(new DistributedCacheUtilImpl(config));
    }

    public Driver getHiveJdbcDriver() {
        try {
            return new HiveDriver();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load Hive JDBC driver", ex);
        }
    }

    public Driver getJdbcDriver(String driverType) {
        try {
            Driver newInstance = null;
            Class<? extends Driver> clazz = JDBC_DRIVER_MAP.get(driverType);
            if (clazz != null) {
                newInstance = clazz.newInstance();
                return DriverProxyInvocationChain.getProxy(Driver.class, newInstance);
            }
            clazz = this.tryToLoadDriver(JDBC_POSSIBLE_DRIVER_MAP.get(driverType));
            if (clazz != null) {
                newInstance = clazz.newInstance();
                if (driverType.equals("Impala")) {
                    return DriverProxyInvocationChain.getProxy(Driver.class, newInstance);
                }
                return newInstance;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load JDBC driver of type: " + driverType, ex);
        }
    }

    public Configuration createConfiguration() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxy configurationProxy = new ConfigurationProxy();
            return configurationProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem(Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            FileSystemProxy fileSystemProxy = new FileSystemProxy(org.apache.hadoop.fs.FileSystem.get((org.apache.hadoop.conf.Configuration)ShimUtils.asConfiguration(conf)));
            return fileSystemProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void setDistributedCacheUtil(DistributedCacheUtil dcUtilParam) {
        if (dcUtilParam == null) {
            throw new NullPointerException();
        }
        this.dcUtil = dcUtilParam;
    }

    public DistributedCacheUtil getDistributedCacheUtil() throws ConfigurationException {
        if (this.dcUtil == null) {
            throw new ConfigurationException(BaseMessages.getString(CommonHadoopShim.class, (String)"CommonHadoopShim.DistributedCacheUtilMissing", (String[])new String[0]));
        }
        return this.dcUtil;
    }

    public String[] getNamenodeConnectionInfo(Configuration c) {
        URI namenode = org.apache.hadoop.fs.FileSystem.getDefaultUri((org.apache.hadoop.conf.Configuration)ShimUtils.asConfiguration(c));
        String[] result = new String[2];
        if (namenode != null) {
            result[0] = namenode.getHost();
            if (namenode.getPort() != -1) {
                result[1] = String.valueOf(namenode.getPort());
            }
        }
        return result;
    }

    public String[] getJobtrackerConnectionInfo(Configuration c) {
        String[] result = new String[2];
        if (!"local".equals(c.get("mapred.job.tracker", "local"))) {
            InetSocketAddress jobtracker = CommonHadoopShim.getJobTrackerAddress(c);
            result[0] = jobtracker.getHostName();
            result[1] = String.valueOf(jobtracker.getPort());
        }
        return result;
    }

    public static InetSocketAddress getJobTrackerAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr((String)jobTrackerStr);
    }

    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, Configuration conf, List<String> logMessages) throws Exception {
        if (namenodeHost == null || namenodeHost.trim().length() == 0) {
            throw new Exception("No hdfs host specified!");
        }
        if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
            throw new Exception("No job tracker host specified!");
        }
        if (namenodePort != null && namenodePort.trim().length() != 0 && !"-1".equals(namenodePort.trim())) {
            namenodePort = ":" + namenodePort;
        } else {
            namenodePort = "";
            logMessages.add("No hdfs port specified - HA? ");
        }
        if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
            jobtrackerPort = this.getDefaultJobtrackerPort();
            logMessages.add("No job tracker port specified - using default: " + jobtrackerPort);
        }
        String fsDefaultName = "hdfs://" + namenodeHost + namenodePort;
        String jobTracker = jobtrackerHost + ":" + jobtrackerPort;
        conf.set("fs.default.name", fsDefaultName);
        conf.set("mapred.job.tracker", jobTracker);
    }

    protected String getDefaultNamenodePort() {
        return "9000";
    }

    protected String getDefaultJobtrackerPort() {
        return "9001";
    }

    public RunningJob submitJob(Configuration c) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            RunningJob runningJob = c.submit();
            return runningJob;
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public Class<? extends Writable> getHadoopWritableCompatibleClass(ValueMetaInterface kettleType) {
        return TypeConverterFactory.getWritableForKettleType((ValueMetaInterface)kettleType);
    }

    public Class<?> getPentahoMapReduceCombinerClass() {
        return GenericTransCombiner.class;
    }

    public Class<?> getPentahoMapReduceReducerClass() {
        return GenericTransReduce.class;
    }

    public Class<?> getPentahoMapReduceMapRunnerClass() {
        return PentahoMapRunnable.class;
    }

    static {
        JDBC_POSSIBLE_DRIVER_MAP.put("hive2Simba", "org.pentaho.hadoop.shim.common.CommonHadoopShim$NotSupportedDriver");
        JDBC_POSSIBLE_DRIVER_MAP.put("ImpalaSimba", "org.pentaho.hadoop.shim.common.CommonHadoopShim$NotSupportedDriver");
        JDBC_POSSIBLE_DRIVER_MAP.put("SparkSqlSimba", "org.pentaho.hadoop.shim.common.CommonHadoopShim$NotSupportedDriver");
        JDBC_POSSIBLE_DRIVER_MAP.put("Impala", "org.apache.hive.jdbc.HiveDriver");
    }

    public static class NotSupportedDriver
    implements Driver {
        public static SQLException notSupported = new SQLException("Chosen driver is not supported in currently active Hadoop shim");

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            throw notSupported;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            throw notSupported;
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            throw notSupported;
        }

        @Override
        public int getMajorVersion() {
            return 0;
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public boolean jdbcCompliant() {
            return false;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

