/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.HttpBasicAuthInterceptor;
import org.apache.hive.jdbc.HttpKerberosRequestInterceptor;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveConnection
implements Connection {
    public static final Log LOG = LogFactory.getLog((String)HiveConnection.class.getName());
    private static final String HIVE_VAR_PREFIX = "hivevar:";
    private static final String HIVE_CONF_PREFIX = "hiveconf:";
    private String jdbcUriString;
    private String host;
    private int port;
    private final Map<String, String> sessConfMap;
    private final Map<String, String> hiveConfMap;
    private final Map<String, String> hiveVarMap;
    private Utils.JdbcConnectionParams connParams;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private boolean assumeSubject;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int loginTimeout = 0;
    private TProtocolVersion protocol;

    public HiveConnection(String uri, Properties info) throws SQLException {
        this.setupLoginTimeout();
        try {
            this.connParams = Utils.parseURL(uri, info);
        }
        catch (ZooKeeperHiveClientException e) {
            throw new SQLException(e);
        }
        this.jdbcUriString = this.connParams.getJdbcUriString();
        this.host = this.connParams.getHost();
        this.port = this.connParams.getPort();
        this.sessConfMap = this.connParams.getSessionVars();
        this.hiveConfMap = this.connParams.getHiveConfs();
        this.hiveVarMap = this.connParams.getHiveVars();
        this.isEmbeddedMode = this.connParams.isEmbeddedMode();
        if (this.isEmbeddedMode) {
            EmbeddedThriftBinaryCLIService embeddedClient = new EmbeddedThriftBinaryCLIService();
            embeddedClient.init(new HiveConf());
            this.client = embeddedClient;
        } else {
            this.openTransport();
            this.client = new TCLIService.Client((TProtocol)new TBinaryProtocol(this.transport));
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V2);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V4);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V5);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V7);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
        this.openSession();
        this.client = HiveConnection.newSynchronizedClient(this.client);
    }

    private void openTransport() throws SQLException {
        while (true) {
            try {
                this.assumeSubject = "fromSubject".equals(this.sessConfMap.get("kerberosAuthType"));
                TTransport tTransport = this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
                if (this.transport.isOpen()) break;
                this.transport.open();
                this.logZkDiscoveryMessage("Connected to " + this.connParams.getHost() + ":" + this.connParams.getPort());
            }
            catch (TTransportException e) {
                if (this.isZkDynamicDiscoveryMode()) {
                    LOG.info((Object)("Failed to connect to " + this.connParams.getHost() + ":" + this.connParams.getPort()));
                    try {
                        Utils.updateConnParamsFromZooKeeper(this.connParams);
                    }
                    catch (ZooKeeperHiveClientException ze) {
                        throw new SQLException("Could not open client transport for any of the Server URI's in ZooKeeper: " + ze.getMessage(), " 08S01", ze);
                    }
                    this.jdbcUriString = this.connParams.getJdbcUriString();
                    this.host = this.connParams.getHost();
                    this.port = this.connParams.getPort();
                    continue;
                }
                LOG.info((Object)("Transport Used for JDBC connection: " + this.sessConfMap.get("transportMode")));
                throw new SQLException("Could not open client transport with JDBC Uri: " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
            }
            break;
        }
    }

    private String getServerHttpUrl(boolean useSsl) {
        String schemeName = useSsl ? "https" : "http";
        String httpPath = this.sessConfMap.get("httpPath");
        if (httpPath == null) {
            httpPath = "/";
        } else if (!httpPath.startsWith("/")) {
            httpPath = "/" + httpPath;
        }
        return schemeName + "://" + this.host + ":" + this.port + httpPath;
    }

    private TTransport createHttpTransport() throws SQLException, TTransportException {
        boolean useSsl = this.isSslConnection();
        CloseableHttpClient httpClient = this.getHttpClient(useSsl);
        try {
            this.transport = new THttpClient(this.getServerHttpUrl(useSsl), (HttpClient)httpClient);
            TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol(this.transport));
            TOpenSessionResp openResp = client.OpenSession(new TOpenSessionReq());
            if (openResp != null) {
                client.CloseSession(new TCloseSessionReq(openResp.getSessionHandle()));
            }
        }
        catch (TException e) {
            LOG.info((Object)("JDBC Connection Parameters used : useSSL = " + useSsl + " , httpPath  = " + this.sessConfMap.get("httpPath") + " Authentication type = " + this.sessConfMap.get("auth")));
            String msg = "Could not create http connection to " + this.jdbcUriString + ". " + e.getMessage();
            throw new TTransportException(msg, (Throwable)e);
        }
        return this.transport;
    }

    private CloseableHttpClient getHttpClient(Boolean useSsl) throws SQLException {
        boolean isCookieEnabled = this.sessConfMap.get("cookieAuth") == null || !"false".equalsIgnoreCase(this.sessConfMap.get("cookieAuth"));
        String cookieName = this.sessConfMap.get("cookieName") == null ? "hive.server2.auth" : this.sessConfMap.get("cookieName");
        BasicCookieStore cookieStore = isCookieEnabled ? new BasicCookieStore() : null;
        HashMap<String, String> additionalHttpHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.sessConfMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("http.header.")) continue;
            additionalHttpHeaders.put(key.substring("http.header.".length()), entry.getValue());
        }
        HttpRequestInterceptorBase requestInterceptor = this.isKerberosAuthMode() ? new HttpKerberosRequestInterceptor(this.sessConfMap.get("principal"), this.host, this.getServerHttpUrl(useSsl), this.assumeSubject, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders) : new HttpBasicAuthInterceptor(this.getUserName(), this.getPassword(), (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders);
        HttpClientBuilder httpClientBuilder = isCookieEnabled ? HttpClients.custom().setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean ret;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl = ret = statusCode == 401 && executionCount <= 1;
                if (ret) {
                    context.setAttribute("hive.server2.retryserver", (Object)"true");
                }
                return ret;
            }

            public long getRetryInterval() {
                return 0L;
            }
        }) : HttpClientBuilder.create();
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)requestInterceptor);
        if (useSsl.booleanValue()) {
            String useTwoWaySSL = this.sessConfMap.get("twoWay");
            String sslTrustStorePath = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            try {
                SSLSocketFactory socketFactory;
                if (useTwoWaySSL != null && useTwoWaySSL.equalsIgnoreCase("true")) {
                    socketFactory = this.getTwoWaySSLSocketFactory();
                } else if (sslTrustStorePath == null || sslTrustStorePath.isEmpty()) {
                    socketFactory = SSLSocketFactory.getSocketFactory();
                } else {
                    KeyStore sslTrustStore = KeyStore.getInstance("JKS");
                    sslTrustStore.load(new FileInputStream(sslTrustStorePath), sslTrustStorePassword.toCharArray());
                    socketFactory = new SSLSocketFactory(sslTrustStore);
                }
                socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
            }
            catch (Exception e) {
                String msg = "Could not create an https connection to " + this.jdbcUriString + ". " + e.getMessage();
                throw new SQLException(msg, " 08S01", e);
            }
        }
        return httpClientBuilder.build();
    }

    private TTransport createBinaryTransport() throws SQLException, TTransportException {
        block13: {
            try {
                if (!"noSasl".equals(this.sessConfMap.get("auth"))) {
                    HashMap<String, String> saslProps = new HashMap<String, String>();
                    SaslQOP saslQOP = SaslQOP.AUTH;
                    if (this.sessConfMap.containsKey("saslQop")) {
                        try {
                            saslQOP = SaslQOP.fromString((String)this.sessConfMap.get("saslQop"));
                        }
                        catch (IllegalArgumentException e) {
                            throw new SQLException("Invalid saslQop parameter. " + e.getMessage(), "42000", e);
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                    } else {
                        saslProps.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
                    }
                    saslProps.put("javax.security.sasl.server.authentication", "true");
                    if (this.sessConfMap.containsKey("principal")) {
                        this.transport = KerberosSaslHelper.getKerberosTransport((String)this.sessConfMap.get("principal"), (String)this.host, (TTransport)HiveAuthFactory.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout), saslProps, (boolean)this.assumeSubject);
                    } else {
                        String tokenStr = this.getClientDelegationToken(this.sessConfMap);
                        if (tokenStr != null) {
                            this.transport = KerberosSaslHelper.getTokenTransport((String)tokenStr, (String)this.host, (TTransport)HiveAuthFactory.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout), saslProps);
                        } else {
                            String userName = this.getUserName();
                            String passwd = this.getPassword();
                            if (this.isSslConnection()) {
                                String sslTrustStore = this.sessConfMap.get("sslTrustStore");
                                String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
                                this.transport = sslTrustStore == null || sslTrustStore.isEmpty() ? HiveAuthFactory.getSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout) : HiveAuthFactory.getSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout, (String)sslTrustStore, (String)sslTrustStorePassword);
                            } else {
                                this.transport = HiveAuthFactory.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout);
                            }
                            this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)this.transport);
                        }
                    }
                    break block13;
                }
                this.transport = HiveAuthFactory.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout);
            }
            catch (SaslException e) {
                throw new SQLException("Could not create secure connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
            }
        }
        return this.transport;
    }

    SSLSocketFactory getTwoWaySSLSocketFactory() throws SQLException {
        SSLSocketFactory socketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            String keyStorePath = this.sessConfMap.get("sslKeyStore");
            String keyStorePassword = this.sessConfMap.get("keyStorePassword");
            KeyStore sslKeyStore = KeyStore.getInstance("JKS");
            if (keyStorePath == null || keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslKeyStore Not configured for 2 way SSL connection, keyStorePath param is empty");
            }
            sslKeyStore.load(new FileInputStream(keyStorePath), keyStorePassword.toCharArray());
            keyManagerFactory.init(sslKeyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            String trustStorePath = this.sessConfMap.get("sslTrustStore");
            String trustStorePassword = this.sessConfMap.get("trustStorePassword");
            KeyStore sslTrustStore = KeyStore.getInstance("JKS");
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslTrustStore Not configured for 2 way SSL connection");
            }
            sslTrustStore.load(new FileInputStream(trustStorePath), trustStorePassword.toCharArray());
            trustManagerFactory.init(sslTrustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            socketFactory = new SSLSocketFactory(context);
        }
        catch (Exception e) {
            throw new SQLException("Error while initializing 2 way ssl socket factory ", e);
        }
        return socketFactory;
    }

    private String getClientDelegationToken(Map<String, String> jdbcConnConf) throws SQLException {
        String tokenStr = null;
        if ("delegationToken".equalsIgnoreCase(jdbcConnConf.get("auth"))) {
            try {
                tokenStr = org.apache.hadoop.hive.shims.Utils.getTokenStrForm((String)"hiveserver2ClientToken");
            }
            catch (IOException e) {
                throw new SQLException("Error reading token ", e);
            }
        }
        return tokenStr;
    }

    private void openSession() throws SQLException {
        TOpenSessionReq openReq = new TOpenSessionReq();
        HashMap<String, String> openConf = new HashMap<String, String>();
        for (Map.Entry<String, String> hiveConf : this.connParams.getHiveConfs().entrySet()) {
            openConf.put("set:hiveconf:" + hiveConf.getKey(), hiveConf.getValue());
        }
        for (Map.Entry<String, String> hiveVar : this.connParams.getHiveVars().entrySet()) {
            openConf.put("set:hivevar:" + hiveVar.getKey(), hiveVar.getValue());
        }
        openConf.put("use:database", this.connParams.getDbName());
        Map<String, String> sessVars = this.connParams.getSessionVars();
        if (sessVars.containsKey("hive.server2.proxy.user")) {
            openConf.put("hive.server2.proxy.user", sessVars.get("hive.server2.proxy.user"));
        }
        openReq.setConfiguration(openConf);
        if ("noSasl".equals(this.sessConfMap.get("auth"))) {
            openReq.setUsername(this.sessConfMap.get("user"));
            openReq.setPassword(this.sessConfMap.get("password"));
        }
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.protocol = openResp.getServerProtocolVersion();
            this.sessHandle = openResp.getSessionHandle();
        }
        catch (TException e) {
            LOG.error((Object)"Error opening session", (Throwable)e);
            throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
        }
        this.isClosed = false;
    }

    private String getUserName() {
        return this.getSessionValue("user", "anonymous");
    }

    private String getPassword() {
        return this.getSessionValue("password", "anonymous");
    }

    private boolean isSslConnection() {
        return "true".equalsIgnoreCase(this.sessConfMap.get("ssl"));
    }

    private boolean isKerberosAuthMode() {
        return !"noSasl".equals(this.sessConfMap.get("auth")) && this.sessConfMap.containsKey("principal");
    }

    private boolean isHttpTransportMode() {
        String transportMode = this.sessConfMap.get("transportMode");
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    private boolean isZkDynamicDiscoveryMode() {
        return this.sessConfMap.get("serviceDiscoveryMode") != null && "zooKeeper".equalsIgnoreCase(this.sessConfMap.get("serviceDiscoveryMode"));
    }

    private void logZkDiscoveryMessage(String message) {
        if (this.isZkDynamicDiscoveryMode()) {
            LOG.info((Object)message);
        }
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupLoginTimeout() {
        long timeOut = TimeUnit.SECONDS.toMillis(DriverManager.getLoginTimeout());
        this.loginTimeout = timeOut > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeOut;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new SQLException("Could not retrieve token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not cancel token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not renew token: " + e.getMessage(), " 08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this, this.client, this.sessHandle);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported", "HYC00");
        }
        if (resultSetType == 1005) {
            throw new SQLException("Statement with resultset type " + resultSetType + " is not supported", "HYC00");
        }
        return new HiveStatement(this, this.client, this.sessHandle, resultSetType == 1004);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HiveDatabaseMetaData(this, this.client, this.sessHandle);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        Statement stmt = this.createStatement();
        ResultSet res = stmt.executeQuery("SELECT current_database()");
        if (!res.next()) {
            throw new SQLException("Failed to get schema information");
        }
        String schemaName = res.getString(1);
        res.close();
        stmt.close();
        return schemaName;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            throw new SQLException("enabling autocommit is not supported");
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Schema name is null or empty");
        }
        Statement stmt = this.createStatement();
        stmt.execute("use " + schema);
        stmt.close();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public TProtocolVersion getProtocol() {
        return this.protocol;
    }

    public static TCLIService.Iface newSynchronizedClient(TCLIService.Iface client) {
        return (TCLIService.Iface)Proxy.newProxyInstance(HiveConnection.class.getClassLoader(), new Class[]{TCLIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TCLIService.Iface client;

        SynchronizedHandler(TCLIService.Iface client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                TCLIService.Iface iface = this.client;
                synchronized (iface) {
                    return method.invoke((Object)this.client, args);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw (TException)e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
        }
    }
}

