/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainterExtension;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.step.StepMeta;

@ExtensionPoint(id="TransPainterStepExtensionPointPlugin", extensionPointId="TransPainterStep", description="Paint a database icon over a step in case a data service is defined")
public class TransPainterStepExtensionPointPlugin
implements ExtensionPointInterface {
    private DataServiceMetaStoreUtil metaStoreUtil;

    public TransPainterStepExtensionPointPlugin(DataServiceContext context) {
        this.metaStoreUtil = context.getMetaStoreUtil();
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        if (!(object instanceof TransPainterExtension)) {
            return;
        }
        TransPainterExtension extension = (TransPainterExtension)object;
        TransMeta transMeta = extension.transMeta;
        StepMeta stepMeta = extension.stepMeta;
        DataServiceMeta dataService = this.metaStoreUtil.getDataServiceByStepName(transMeta, stepMeta.getName());
        if (dataService != null && dataService.isUserDefined()) {
            extension.gc.drawImage("images/data-services.svg", this.getClass().getClassLoader(), extension.x1 - 11, extension.y1 - 9 + extension.iconsize);
            extension.areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, extension.x1 - 11, extension.y1 - 9 + extension.iconsize, 16, 16, extension.offset, (Object)transMeta, (Object)stepMeta));
        }
    }
}

