/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.CommandExecutor;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.clients.Query;

public class CommandQueryService
implements Query.Service {
    private DataServiceContext context;

    public CommandQueryService(DataServiceContext context) {
        this.context = context;
    }

    @Override
    public Query prepareQuery(String sql, int maxRows, Map<String, String> parameters) throws KettleException {
        if (sql.startsWith("[")) {
            return new CommandQuery(new CommandExecutor.Builder(sql, this.context).build());
        }
        return null;
    }

    public static DataOutputStream asDataOutputStream(OutputStream outputStream) {
        return outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    private class CommandQuery
    implements Query {
        private final CommandExecutor executor;

        public CommandQuery(CommandExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            this.executor.execute(CommandQueryService.asDataOutputStream(outputStream));
        }

        @Override
        public List<Trans> getTransList() {
            return new ArrayList<Trans>();
        }
    }
}

