/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class ExecutorQueryService
implements Query.Service {
    private DataServiceResolver resolver;
    private MetastoreLocator metastoreLocator;

    public ExecutorQueryService(DataServiceResolver resolver, MetastoreLocator metastoreLocator) {
        this.resolver = resolver;
        this.metastoreLocator = metastoreLocator;
    }

    @Override
    public Query prepareQuery(String sqlString, int maxRows, Map<String, String> parameters) throws KettleException {
        ExecutorQuery query;
        SQL sql = new SQL(sqlString);
        try {
            IMetaStore metaStore;
            IMetaStore iMetaStore = metaStore = this.metastoreLocator != null ? this.metastoreLocator.getMetastore() : null;
            if (metaStore == null) {
                metaStore = MetaStoreConst.openLocalPentahoMetaStore();
            }
            DataServiceExecutor executor = this.resolver.createBuilder(sql).rowLimit(maxRows).parameters(parameters).metastore(metaStore).build();
            query = new ExecutorQuery(executor);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KettleException.class);
            throw new KettleException((Throwable)e);
        }
        return query;
    }

    public static DataOutputStream asDataOutputStream(OutputStream outputStream) {
        return outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    private static class ExecutorQuery
    implements Query {
        private final DataServiceExecutor executor;

        public ExecutorQuery(DataServiceExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            this.executor.executeQuery(ExecutorQueryService.asDataOutputStream(outputStream)).waitUntilFinished();
        }

        @Override
        public List<Trans> getTransList() {
            return ImmutableList.of((Object)this.executor.getServiceTrans(), (Object)this.executor.getGenTrans());
        }
    }
}

