/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="Source Target Fields", description="Defines the mapping of a source to target field and any related metadata.  Used for push down optimization.")
public class SourceTargetFields {
    public static final String SOURCE_FIELD_NAME = "source_field_name";
    public static final String TARGET_FIELD_NAME = "target_field_name";
    public static final Predicate<SourceTargetFields> IS_DEFINED = new Predicate<SourceTargetFields>(){

        public boolean apply(SourceTargetFields input) {
            return input.isDefined();
        }
    };
    @MetaStoreAttribute(key="source_field_name")
    private String sourceFieldName;
    @MetaStoreAttribute(key="target_field_name")
    private String targetFieldName;

    public SourceTargetFields() {
    }

    public SourceTargetFields(String source, String target) {
        this.setSourceFieldName(source);
        this.setTargetFieldName(target);
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public void setSourceFieldName(String sourceFieldName) {
        this.sourceFieldName = sourceFieldName;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetFieldName) {
        this.targetFieldName = targetFieldName;
    }

    public boolean isDefined() {
        return !Strings.isNullOrEmpty((String)this.getSourceFieldName()) && !Strings.isNullOrEmpty((String)this.getTargetFieldName());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sourceFieldName", (Object)this.sourceFieldName).add("targetFieldName", (Object)this.targetFieldName).toString();
    }
}

