/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationException;
import org.pentaho.di.trans.dataservice.optimization.ValueMetaResolver;
import org.pentaho.di.trans.dataservice.optimization.paramgen.DatabaseWrapper;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationService;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.tableinput.TableInput;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInputParameterGeneration
implements ParameterGenerationService {
    private final ValueMetaResolver valueMetaResolver;
    protected DatabaseMeta dbMeta;

    public TableInputParameterGeneration(ValueMetaResolver resolver) {
        this.valueMetaResolver = resolver;
    }

    @Override
    public String getParameterDefault() {
        return "1=1";
    }

    @Override
    public OptimizationImpactInfo preview(Condition pushDownCondition, ParameterGeneration parameterGeneration, StepInterface stepInterface) {
        OptimizationImpactInfo optimizationInfo = new OptimizationImpactInfo(stepInterface.getStepname());
        try {
            String sql = this.getSQL(stepInterface);
            optimizationInfo.setQueryBeforeOptimization(sql);
            if (pushDownCondition == null) {
                optimizationInfo.setModified(false);
                return optimizationInfo;
            }
            DatabaseWrapper db = this.getDatabaseWrapper(stepInterface);
            StringBuilder sqlFragment = new StringBuilder();
            RowMeta paramsMeta = new RowMeta();
            LinkedList<Object> params = new LinkedList<Object>();
            this.dbMeta = db.getDatabaseMeta();
            this.convertCondition(pushDownCondition, sqlFragment, paramsMeta, params);
            String fragmentId = db.createRuntimePushDown(sqlFragment.toString(), paramsMeta, params, this.getParameterDefault());
            String modifiedSql = db.injectRuntime(db.pushDownMap, parameterGeneration.setQueryParameter(sql, fragmentId), (RowMetaInterface)new RowMeta(), new LinkedList<Object>());
            optimizationInfo.setQueryAfterOptimization(db.parameterizedQueryToString(modifiedSql, params));
            optimizationInfo.setModified(true);
        }
        catch (PushDownOptimizationException e) {
            optimizationInfo.setModified(false);
            optimizationInfo.setErrorMsg((Exception)((Object)e));
        }
        return optimizationInfo;
    }

    @Override
    public void pushDown(Condition condition, ParameterGeneration parameterGeneration, StepInterface stepInterface) throws PushDownOptimizationException {
        DatabaseWrapper db = this.getDatabaseWrapper(stepInterface);
        this.verifyDbConnection(db);
        this.dbMeta = db.getDatabaseMeta();
        StringBuilder sqlFragment = new StringBuilder();
        RowMeta paramsMeta = new RowMeta();
        LinkedList<Object> params = new LinkedList<Object>();
        this.convertCondition(condition, sqlFragment, paramsMeta, params);
        String fragmentId = db.createRuntimePushDown(sqlFragment.toString(), paramsMeta, params, this.getParameterDefault());
        stepInterface.setVariable(parameterGeneration.getParameterName(), fragmentId);
        TableInputData tableInput = this.getTableInputData(stepInterface);
        tableInput.db = db;
    }

    private void verifyDbConnection(DatabaseWrapper db) throws PushDownOptimizationException {
        try {
            db.connect();
        }
        catch (KettleDatabaseException e) {
            throw new PushDownOptimizationException("Failed to verify database connection", e);
        }
    }

    private DatabaseWrapper getDatabaseWrapper(StepInterface stepInterface) throws PushDownOptimizationException {
        TableInputData stepDataInterface = this.getTableInputData(stepInterface);
        DatabaseWrapper db = stepDataInterface.db instanceof DatabaseWrapper ? (DatabaseWrapper)stepDataInterface.db : new DatabaseWrapper(stepDataInterface.db);
        return db;
    }

    private TableInputData getTableInputData(StepInterface stepInterface) throws PushDownOptimizationException {
        if (!(stepInterface instanceof TableInput)) {
            throw new PushDownOptimizationException("Unable to push down to push down to type " + stepInterface.getClass());
        }
        TableInput tableInput = (TableInput)stepInterface;
        return (TableInputData)tableInput.getStepDataInterface();
    }

    private String getSQL(StepInterface stepInterface) throws PushDownOptimizationException {
        if (!(stepInterface instanceof TableInput)) {
            throw new PushDownOptimizationException("Unable to push down to push down to type " + stepInterface.getClass());
        }
        TableInput tableInput = (TableInput)stepInterface;
        TableInputMeta tableInputMeta = (TableInputMeta)tableInput.getStepMeta().getStepMetaInterface();
        return tableInputMeta.getSQL();
    }

    protected void convertCondition(Condition condition, StringBuilder builder, RowMeta paramsMeta, List<Object> params) throws PushDownOptimizationException {
        if (condition.isNegated()) {
            builder.append("NOT ");
        }
        if (condition.isComposite()) {
            builder.append("( ");
            for (Condition child : condition.getChildren()) {
                if (child.getOperator() == 2) {
                    builder.append(" AND ");
                } else if (child.getOperator() == 1) {
                    builder.append(" OR ");
                }
                this.convertCondition(child, builder, paramsMeta, params);
            }
            builder.append(" )");
        } else {
            builder.append(this.convertAtomicCondition(condition, paramsMeta, params));
        }
    }

    protected String convertAtomicCondition(Condition condition, RowMeta paramsMeta, List<Object> params) throws PushDownOptimizationException {
        String value = condition.getRightExactString();
        String function = condition.getFunctionDesc();
        String placeholder = "?";
        switch (condition.getFunction()) {
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                throw new PushDownOptimizationException(condition.getFunctionDesc() + " is not supported for push down.");
            }
            case 7: 
            case 8: {
                placeholder = "";
                break;
            }
            case 9: {
                Object[] inList = this.getInListArray(condition);
                ValueMetaInterface inListValueMeta = this.getResolvedValueMeta(condition);
                for (int i = 0; i < inList.length; ++i) {
                    paramsMeta.addValueMeta(inListValueMeta);
                    params.add(inList[i]);
                }
                placeholder = String.format("(%s)", StringUtils.join(Collections.nCopies(inList.length, "?").iterator(), (String)","));
                function = " IN ";
                break;
            }
            default: {
                if (value == null) {
                    throw new PushDownOptimizationException("Condition value can not be null: " + condition);
                }
                paramsMeta.addValueMeta(this.getResolvedValueMeta(condition));
                params.add(this.getResolvedValue(condition));
            }
        }
        return String.format("%s %s %s", this.getQuotedFieldName(condition), function, placeholder);
    }

    private Object[] getInListArray(Condition condition) throws PushDownOptimizationException {
        String value = condition.getRightExactString();
        return this.valueMetaResolver.inListToTypedObjectArray(this.getFieldName(condition), value);
    }

    private Object getResolvedValue(Condition condition) throws PushDownOptimizationException {
        ValueMetaAndData metaAndData = condition.getRightExact();
        String fieldName = this.getFieldName(condition);
        return this.valueMetaResolver.getTypedValue(fieldName, metaAndData.getValueMeta().getType(), metaAndData.getValueData());
    }

    private ValueMetaInterface getResolvedValueMeta(Condition condition) throws PushDownOptimizationException {
        return this.valueMetaResolver.getValueMeta(this.getFieldName(condition));
    }

    private String getFieldName(Condition condition) {
        assert (condition.isAtomic());
        return condition.getLeftValuename();
    }

    private String getQuotedFieldName(Condition condition) {
        String fieldName = this.dbMeta.quoteField(this.getFieldName(condition));
        return fieldName;
    }
}

