/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.pushdown.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.pentaho.di.trans.dataservice.optimization.pushdown.ParameterPushdown;
import org.pentaho.di.trans.dataservice.ui.AbstractModel;

public class ParameterPushdownModel
extends AbstractModel {
    private List<String> fieldList = new ArrayList<String>();
    private final ParameterPushdown parameterPushdown;
    private ImmutableList<DefinitionAdapter> definitions = ImmutableList.of();

    public ParameterPushdownModel(ParameterPushdown parameterPushdown) {
        this.parameterPushdown = parameterPushdown;
    }

    public ParameterPushdownModel reset() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<ParameterPushdown.Definition> iterator = this.parameterPushdown.getDefinitions().iterator();
        while (iterator.hasNext()) {
            ParameterPushdown.Definition definition = iterator.next();
            if (definition.isValid()) {
                builder.add((Object)this.createAdapter(definition));
                continue;
            }
            iterator.remove();
        }
        for (int i = 0; i < 10; ++i) {
            builder.add((Object)this.createAdapter(this.parameterPushdown.createDefinition()));
        }
        this.modify(new Runnable(){

            @Override
            public void run() {
                ParameterPushdownModel.this.definitions = builder.build();
            }
        });
        return this;
    }

    public ParameterPushdown getDelegate() {
        return this.parameterPushdown;
    }

    public ImmutableList<DefinitionAdapter> getDefinitions() {
        return this.definitions;
    }

    public void setFieldList(ImmutableList<String> fieldList) {
        this.fieldList = fieldList;
        for (DefinitionAdapter definitionAdapter : this.definitions) {
            definitionAdapter.setFieldList((List<String>)fieldList);
        }
        this.firePropertyChange("definitions", null, this.definitions);
    }

    @Override
    public Map<String, Object> snapshot() {
        return ImmutableMap.of((Object)"definitions", this.getDefinitions());
    }

    @VisibleForTesting
    protected DefinitionAdapter createAdapter(ParameterPushdown.Definition definition) {
        DefinitionAdapter definitionAdapter = new DefinitionAdapter(definition);
        definitionAdapter.setFieldList(this.fieldList);
        return definitionAdapter;
    }

    public class DefinitionAdapter
    extends AbstractModel {
        private final ParameterPushdown.Definition definition;
        private List<String> fieldList;

        public String getFieldName() {
            return Strings.nullToEmpty((String)this.definition.getFieldName());
        }

        public String getParameter() {
            if (!Strings.isNullOrEmpty((String)this.definition.getFieldName()) && (Strings.isNullOrEmpty((String)this.definition.getParameter()) || this.definition.getParameter().endsWith("_QUERY"))) {
                this.definition.setParameter(this.definition.getFieldName().toUpperCase() + "_QUERY");
            }
            return Strings.nullToEmpty((String)this.definition.getParameter());
        }

        public void setFieldList(List<String> fieldList) {
            this.fieldList = fieldList;
        }

        public Vector<String> getFieldList() {
            Vector<String> v = new Vector<String>();
            v.add("");
            v.addAll(this.fieldList);
            return v;
        }

        public String getFormat() {
            return this.isEmpty() ? "" : Strings.nullToEmpty((String)this.definition.getFormat());
        }

        public boolean isEmpty() {
            return this.getFieldName().isEmpty() && this.getParameter().isEmpty();
        }

        public void setFieldName(final String fieldName) {
            this.modify(new Runnable(){

                @Override
                public void run() {
                    DefinitionAdapter.this.definition.setFieldName(fieldName);
                }
            });
        }

        public void setParameter(final String parameter) {
            this.modify(new Runnable(){

                @Override
                public void run() {
                    DefinitionAdapter.this.definition.setParameter(parameter);
                }
            });
        }

        public void setFormat(final String format) {
            this.modify(new Runnable(){

                @Override
                public void run() {
                    DefinitionAdapter.this.definition.setFormat(format);
                }
            });
        }

        private DefinitionAdapter(ParameterPushdown.Definition definition) {
            this.definition = definition;
        }

        @Override
        public Map<String, Object> snapshot() {
            return ImmutableMap.of((Object)"parameter", (Object)this.getParameter(), (Object)"format", (Object)this.getFormat(), (Object)"fieldName", (Object)this.getFieldName());
        }
    }
}

