/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.resolvers;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.kettle.repository.locator.api.KettleRepositoryLocator;

public class MetaStoreResolver
implements DataServiceResolver {
    private DataServiceDelegate delegate;

    public MetaStoreResolver(final KettleRepositoryLocator repositoryLocator, DataServiceContext context) {
        this.delegate = repositoryLocator != null ? new DataServiceDelegate(context){

            @Override
            public Repository getRepository() {
                return repositoryLocator.getRepository();
            }
        } : DataServiceDelegate.withDefaultSpoonInstance(context);
    }

    @Override
    public List<DataServiceMeta> getDataServices(String dataServiceName, Function<Exception, Void> logger) {
        return this.getDataServices(logger);
    }

    @Override
    public List<DataServiceMeta> getDataServices(Function<Exception, Void> logger) {
        return (List)this.delegate.getDataServices(logger);
    }

    @Override
    public DataServiceMeta getDataService(String dataServiceName) {
        try {
            return this.delegate.getDataService(dataServiceName);
        }
        catch (MetaStoreException e) {
            return null;
        }
    }

    @Override
    public List<String> getDataServiceNames(String dataServiceName) {
        return this.getDataServiceNames();
    }

    @Override
    public DataServiceExecutor.Builder createBuilder(SQL sql) {
        try {
            return this.delegate.createBuilder(sql);
        }
        catch (MetaStoreException e) {
            return null;
        }
    }

    @Override
    public List<String> getDataServiceNames() {
        try {
            return this.delegate.getDataServiceNames();
        }
        catch (MetaStoreException e) {
            return new ArrayList<String>();
        }
    }
}

