/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Set;
import org.pentaho.ui.xul.binding.BindingConvertor;

public class BindingConverters {
    private BindingConverters() {
    }

    public static BindingConvertor<String, Boolean> stringIsEmpty() {
        return new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String value) {
                return Strings.isNullOrEmpty((String)value);
            }

            public String targetToSource(Boolean value) {
                throw new AbstractMethodError("Boolean to String conversion is not supported");
            }
        };
    }

    public static BindingConvertor<Boolean, Boolean> not() {
        return new BindingConvertor<Boolean, Boolean>(){

            public Boolean sourceToTarget(Boolean value) {
                return value == false;
            }

            public Boolean targetToSource(Boolean value) {
                return value == false;
            }
        };
    }

    public static <K, V> BindingConvertor<Map<K, V>, Set<K>> keySet() {
        return new BindingConvertor<Map<K, V>, Set<K>>(){

            public Set<K> sourceToTarget(Map<K, V> value) {
                return value.keySet();
            }

            public Map<K, V> targetToSource(Set<K> value) {
                throw new AbstractMethodError("Unable to convert a set to a map");
            }
        };
    }
}

