/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class DataServiceTestResults {
    private RowMetaInterface rowMeta;
    private final TransMeta transMeta;
    private final Composite container;

    public DataServiceTestResults(DataServiceMeta dataService, Composite container) throws KettleStepException {
        this.transMeta = dataService.getServiceTrans();
        this.container = container;
        this.rowMeta = new RowMeta();
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void load(List<Object[]> rows, Listener tableKeyListener) {
        TableView tableView = this.initTableView(rows);
        tableView.table.addListener(1, tableKeyListener);
        for (Object[] rowData : rows) {
            TableItem item = new TableItem(tableView.table, 0);
            this.applyRowDataToTableItem(rowData, item);
        }
        tableView.setRowNums();
        tableView.setShowingConversionErrorsInline(true);
        tableView.optWidth(true);
        this.container.layout();
    }

    private TableView initTableView(List<Object[]> rows) {
        for (Control control : this.container.getChildren()) {
            control.dispose();
        }
        TableView tableView = new TableView((VariableSpace)this.transMeta, this.container, 0, this.rowMetaToColumnInfo(), rows.size(), true, null, PropsUI.getInstance());
        tableView.table.setItemCount(0);
        return tableView;
    }

    private void applyRowDataToTableItem(Object[] rowData, TableItem item) {
        assert (rowData.length == this.rowMeta.size());
        for (int colNr = 0; colNr < this.rowMeta.size(); ++colNr) {
            String cellText = this.getCellTextFromObj(rowData[colNr], this.rowMeta.getValueMeta(colNr));
            this.setCellText(colNr, cellText, item);
        }
    }

    private void setCellText(int colNr, String cellText, TableItem tableItem) {
        if (cellText == null) {
            tableItem.setText(colNr + 1, "<null>");
            tableItem.setForeground(GUIResource.getInstance().getColorBlue());
            return;
        }
        tableItem.setForeground(colNr + 1, GUIResource.getInstance().getColorBlack());
        tableItem.setText(colNr + 1, cellText);
    }

    private String getCellTextFromObj(Object object, ValueMetaInterface valueMeta) {
        try {
            if (valueMeta.isStorageBinaryString()) {
                return valueMeta.getStorageMetadata().getString(valueMeta.convertBinaryStringToNativeType((byte[])object));
            }
            return valueMeta.getString(object);
        }
        catch (KettleValueException valueException) {
            return "ERROR: " + valueException.getMessage();
        }
    }

    private ColumnInfo[] rowMetaToColumnInfo() {
        ColumnInfo[] columnInfo = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < columnInfo.length; ++i) {
            ValueMetaInterface valueMeta = this.rowMeta.getValueMeta(i);
            columnInfo[i] = new ColumnInfo(valueMeta.getName(), 1, false, true);
            columnInfo[i].setValueMeta(valueMeta);
        }
        return columnInfo;
    }
}

