/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.ui.DriverDetailsDialog;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class DriverDetailsDialogController
extends AbstractController {
    private static final String NAME = "driverDetailsDialogController";
    private static final Class<?> PKG = DriverDetailsDialog.class;

    public DriverDetailsDialogController() {
        this.setName(NAME);
    }

    public void saveDriver() {
        try {
            File driverBundle = this.getDriverBundle();
            File saveLocation = this.getDriverSaveLocation();
            if (saveLocation == null) {
                return;
            }
            FileUtils.copyFile((File)driverBundle, (File)saveLocation);
        }
        catch (IOException ioe) {
            this.showErrorDialog(ioe);
            ioe.printStackTrace();
        }
    }

    ErrorDialog showErrorDialog(IOException ioe) {
        return new ErrorDialog(this.getDialog().getShell(), BaseMessages.getString(PKG, (String)"DriverDetailsDialog.ErrorCopyingDriver.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DriverDetailsDialog.ErrorCopyingDriver.Message", (String[])new String[0]), (Exception)ioe);
    }

    public void showHelp() {
        HelpUtils.openHelpDialog((Shell)this.getDialog().getShell(), (String)BaseMessages.getString(PKG, (String)"DriverDetailsDialog.ConnectionSetupLink.Label", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"DriverDetailsDialog.ConnectionSetupLink.Url", (String[])new String[0]), (String)"");
    }

    public void close() {
        this.getDialog().dispose();
    }

    SwtDialog getDialog() {
        return (SwtDialog)this.getElementById("driver-details-dialog");
    }

    File getDriverBundle() throws FileNotFoundException, AccessDeniedException {
        String driverFolderPath = BaseMessages.getString(PKG, (String)"DriverDetailsDialog.DriverZipPath", (String[])new String[]{PentahoSystem.getApplicationContext().getSolutionRootPath()});
        File[] matchingFiles = new File(driverFolderPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(BaseMessages.getString((Class)PKG, (String)"DriverDetailsDialog.DriverZipNamePrefix", (String[])new String[0])) && name.endsWith("zip");
            }
        });
        if (matchingFiles == null || matchingFiles.length == 0 || matchingFiles[0] == null || !matchingFiles[0].exists()) {
            throw new FileNotFoundException(BaseMessages.getString(PKG, (String)"DriverDetailsDialog.DriverBundleNotFoundError.Message", (String[])new String[]{driverFolderPath}));
        }
        return matchingFiles[0];
    }

    File getDriverSaveLocation() throws NotDirectoryException, AccessDeniedException, FileNotFoundException {
        FileDialog dialog = new FileDialog(this.getDialog().getShell(), 8192);
        dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"DriverDetailsDialog.SaveDialog.ZipFilesFilter.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DriverDetailsDialog.SaveDialog.AllFilesFilter.Label", (String[])new String[0])});
        dialog.setFilterExtensions(new String[]{"*.zip", "*.*"});
        dialog.setFileName(BaseMessages.getString(PKG, (String)"DriverDetailsDialog.SaveDialog.DefaultFileName.Label", (String[])new String[0]));
        String savePath = dialog.open();
        if (savePath != null) {
            return new File(savePath);
        }
        return null;
    }
}

