/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.menu;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.menu.DataServiceTreeDelegateExtension;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.SelectionTreeExtension;

@ExtensionPoint(id="DataServiceViewTreeExtension", description="Refreshes data services subtree", extensionPointId="SpoonViewTreeExtension")
public class DataServiceViewTreeExtension
implements ExtensionPointInterface {
    private DataServiceDelegate delegate;
    private static final Class<?> PKG = DataServiceTreeDelegateExtension.class;
    public static final String STRING_DATA_SERVICES = BaseMessages.getString(PKG, (String)"DataServicePopupMenu.TITLE", (String[])new String[0]);

    public DataServiceViewTreeExtension(DataServiceContext context) {
        this.delegate = context.getDataServiceDelegate();
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        SelectionTreeExtension selectionTreeExtension = (SelectionTreeExtension)object;
        if (selectionTreeExtension.getAction().equals("REFRESH_SELECTION_EXTENSION") && selectionTreeExtension.getMeta() instanceof TransMeta) {
            this.refreshTree(selectionTreeExtension);
        }
        if (selectionTreeExtension.getAction().equals("EDIT_SELECTION_EXTENSION")) {
            this.editDataService(selectionTreeExtension);
        }
    }

    private void refreshTree(SelectionTreeExtension selectionTreeExtension) {
        TransMeta meta = (TransMeta)selectionTreeExtension.getMeta();
        TreeItem tiRootName = selectionTreeExtension.getTiRootName();
        GUIResource guiResource = selectionTreeExtension.getGuiResource();
        TreeItem tiDSTitle = this.createTreeItem(tiRootName, STRING_DATA_SERVICES, guiResource.getImageFolder());
        for (DataServiceMeta dataService : this.delegate.getDataServices(meta)) {
            this.createTreeItem(tiDSTitle, dataService.getName(), this.getDataServiceImage(guiResource));
        }
    }

    private Image getDataServiceImage(GUIResource guiResource) {
        return guiResource.getImage("images/data-services_padding.svg", this.getClass().getClassLoader(), 24, 24);
    }

    private void editDataService(SelectionTreeExtension selectionTreeExtension) {
        Object selection = selectionTreeExtension.getSelection();
        if (selection instanceof DataServiceMeta) {
            this.delegate.editDataService((DataServiceMeta)selection);
        }
    }

    private TreeItem createTreeItem(TreeItem parent, String text, Image image) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        item.setImage(image);
        return item;
    }
}

