/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster.tests.hdfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.impl.cluster.tests.ClusterRuntimeTestEntry;
import org.pentaho.bigdata.api.hdfs.HadoopFileStatus;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemLocator;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemPath;
import org.pentaho.bigdata.api.hdfs.exceptions.AccessControlException;
import org.pentaho.di.core.Const;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.BaseRuntimeTest;

public class ListDirectoryTest
extends BaseRuntimeTest {
    public static final String LIST_DIRECTORY_TEST_COULDNT_GET_FILE_SYSTEM_DESC = "ListDirectoryTest.CouldntGetFileSystem.Desc";
    public static final String LIST_DIRECTORY_TEST_COULDNT_GET_FILE_SYSTEM_MESSAGE = "ListDirectoryTest.CouldntGetFileSystem.Message";
    public static final String LIST_DIRECTORY_TEST_SUCCESS_DESC = "ListDirectoryTest.Success.Desc";
    public static final String LIST_DIRECTORY_TEST_SUCCESS_MESSAGE = "ListDirectoryTest.Success.Message";
    public static final String LIST_DIRECTORY_TEST_ACCESS_CONTROL_EXCEPTION_DESC = "ListDirectoryTest.AccessControlException.Desc";
    public static final String LIST_DIRECTORY_TEST_ACCESS_CONTROL_EXCEPTION_MESSAGE = "ListDirectoryTest.AccessControlException.Message";
    public static final String LIST_DIRECTORY_TEST_ERROR_LISTING_DIRECTORY_DESC = "ListDirectoryTest.ErrorListingDirectory.Desc";
    public static final String LIST_DIRECTORY_TEST_ERROR_LISTING_DIRECTORY_MESSAGE = "ListDirectoryTest.ErrorListingDirectory.Message";
    public static final String LIST_DIRECTORY_TEST_ERROR_INITIALIZING_CLUSTER_DESC = "ListDirectoryTest.ErrorInitializingCluster.Desc";
    public static final String LIST_DIRECTORY_TEST_ERROR_INITIALIZING_CLUSTER_MESSAGE = "ListDirectoryTest.ErrorInitializingCluster.Message";
    private static final Class<?> PKG = ListDirectoryTest.class;
    private final HadoopFileSystemLocator hadoopFileSystemLocator;
    private final String directory;
    private final MessageGetterFactory messageGetterFactory;
    private final MessageGetter messageGetter;

    public ListDirectoryTest(MessageGetterFactory messageGetterFactory, HadoopFileSystemLocator hadoopFileSystemLocator, String directory, String id, String name) {
        super(NamedCluster.class, "Hadoop File System", id, name, new HashSet<String>(Arrays.asList("_hadoopFileSystemPingFileSystemEntryPointTest")));
        this.hadoopFileSystemLocator = hadoopFileSystemLocator;
        this.directory = directory;
        this.messageGetterFactory = messageGetterFactory;
        this.messageGetter = messageGetterFactory.create(PKG);
    }

    public RuntimeTestResultSummary runTest(Object objectUnderTest) {
        NamedCluster namedCluster = (NamedCluster)objectUnderTest;
        try {
            HadoopFileSystem hadoopFilesystem = this.hadoopFileSystemLocator.getHadoopFilesystem(namedCluster);
            if (hadoopFilesystem == null) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(LIST_DIRECTORY_TEST_COULDNT_GET_FILE_SYSTEM_DESC, new String[0]), this.messageGetter.getMessage(LIST_DIRECTORY_TEST_COULDNT_GET_FILE_SYSTEM_MESSAGE, new String[]{this.directory}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            HadoopFileSystemPath hadoopFilesystemPath = Const.isEmpty((String)this.directory) ? hadoopFilesystem.getHomeDirectory() : hadoopFilesystem.getPath(this.directory);
            try {
                HadoopFileStatus[] hadoopFileStatuses = hadoopFilesystem.listStatus(hadoopFilesystemPath);
                StringBuilder paths = new StringBuilder();
                for (HadoopFileStatus hadoopFileStatus : hadoopFileStatuses) {
                    paths.append(hadoopFileStatus.getPath());
                    paths.append(", ");
                }
                if (paths.length() > 0) {
                    paths.setLength(paths.length() - 2);
                }
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(LIST_DIRECTORY_TEST_SUCCESS_DESC, new String[0]), this.messageGetter.getMessage(LIST_DIRECTORY_TEST_SUCCESS_MESSAGE, new String[]{paths.toString()}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            catch (AccessControlException e) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ACCESS_CONTROL_EXCEPTION_DESC, new String[0]), this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ACCESS_CONTROL_EXCEPTION_MESSAGE, new String[]{hadoopFilesystemPath.toString()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            catch (IOException e) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ERROR_LISTING_DIRECTORY_DESC, new String[0]), this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ERROR_LISTING_DIRECTORY_MESSAGE, new String[]{hadoopFilesystemPath.toString()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
        }
        catch (ClusterInitializationException e) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ERROR_INITIALIZING_CLUSTER_DESC, new String[0]), this.messageGetter.getMessage(LIST_DIRECTORY_TEST_ERROR_INITIALIZING_CLUSTER_MESSAGE, new String[]{namedCluster.getName()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
        }
    }
}

