/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster.tests.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.impl.cluster.tests.ClusterRuntimeTestEntry;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemLocator;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemPath;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.BaseRuntimeTest;

public class WriteToAndDeleteFromUsersHomeFolderTest
extends BaseRuntimeTest {
    public static final String HADOOP_FILE_SYSTEM_WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST = "hadoopFileSystemWriteToAndDeleteFromUsersHomeFolderTest";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_NAME = "WriteToAndDeleteFromUsersHomeFolderTest.Name";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_COULDNT_GET_FILE_SYSTEM_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.CouldntGetFileSystem.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_COULDNT_GET_FILE_SYSTEM_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.CouldntGetFileSystem.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_FILE_EXISTS_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.FileExists.Desc";
    public static final String PENTAHO_SHIM_TEST_FILE_TEST = "pentaho-shim-test-file.test";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_FILE_EXISTS_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.FileExists.Message";
    public static final String HELLO_CLUSTER = "Hello, Cluster";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_SUCCESS_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.Success.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_SUCCESS_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.Success.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_UNABLE_TO_DELETE_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.UnableToDelete.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_UNABLE_TO_DELETE_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.UnableToDelete.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_INITIALIZING_CLUSTER_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorInitializingCluster.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_INITIALIZING_CLUSTER_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorInitializingCluster.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CHECKING_IF_FILE_EXISTS_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorCheckingIfFileExists.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CHECKING_IF_FILE_EXISTS_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorCheckingIfFileExists.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CREATING_FILE_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorCreatingFile.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CREATING_FILE_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorCreatingFile.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_TO_FILE_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorWritingToFile.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_TO_FILE_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorWritingToFile.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_DELETING_FILE_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorDeletingFile.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_DELETING_FILE_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorDeletingFile.Message";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_DELETING_FILE_DESC = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorWritingDeletingFile.Desc";
    public static final String WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_DELETING_FILE_MESSAGE = "WriteToAndDeleteFromUsersHomeFolderTest.ErrorWritingDeletingFile.Message";
    private static final Class<?> PKG = WriteToAndDeleteFromUsersHomeFolderTest.class;
    private final HadoopFileSystemLocator hadoopFileSystemLocator;
    private final MessageGetterFactory messageGetterFactory;
    private final MessageGetter messageGetter;

    public WriteToAndDeleteFromUsersHomeFolderTest(MessageGetterFactory messageGetterFactory, HadoopFileSystemLocator hadoopFileSystemLocator) {
        super(NamedCluster.class, "Hadoop File System", HADOOP_FILE_SYSTEM_WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST, messageGetterFactory.create(PKG).getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_NAME, new String[0]), new HashSet<String>(Arrays.asList("hadoopFileSystemListHomeDirectoryTest")));
        this.hadoopFileSystemLocator = hadoopFileSystemLocator;
        this.messageGetterFactory = messageGetterFactory;
        this.messageGetter = messageGetterFactory.create(PKG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeTestResultSummary runTest(Object objectUnderTest) {
        NamedCluster namedCluster = (NamedCluster)objectUnderTest;
        try {
            OutputStream outputStream;
            Boolean exists;
            HadoopFileSystem hadoopFilesystem = this.hadoopFileSystemLocator.getHadoopFilesystem(namedCluster);
            if (hadoopFilesystem == null) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_COULDNT_GET_FILE_SYSTEM_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_COULDNT_GET_FILE_SYSTEM_MESSAGE, new String[]{namedCluster.getName()}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            HadoopFileSystemPath path = hadoopFilesystem.getPath(PENTAHO_SHIM_TEST_FILE_TEST);
            HadoopFileSystemPath qualifiedPath = hadoopFilesystem.makeQualified(path);
            try {
                exists = hadoopFilesystem.exists(path);
            }
            catch (IOException e) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CHECKING_IF_FILE_EXISTS_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CHECKING_IF_FILE_EXISTS_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            if (exists.booleanValue()) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_FILE_EXISTS_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_FILE_EXISTS_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            try {
                outputStream = hadoopFilesystem.create(path);
            }
            catch (IOException e) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CREATING_FILE_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_CREATING_FILE_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
            }
            ClusterRuntimeTestEntry writeExceptionEntry = null;
            try {
                outputStream.write(HELLO_CLUSTER.getBytes(UTF8));
            }
            catch (IOException e) {
                writeExceptionEntry = new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_TO_FILE_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_TO_FILE_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            try {
                if (hadoopFilesystem.delete(path, false)) {
                    if (writeExceptionEntry == null) {
                        return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_SUCCESS_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_SUCCESS_MESSAGE, new String[]{qualifiedPath.toString()}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
                    }
                    return new RuntimeTestResultSummaryImpl(writeExceptionEntry);
                }
                if (writeExceptionEntry == null) {
                    return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_UNABLE_TO_DELETE_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_UNABLE_TO_DELETE_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
                }
                return new RuntimeTestResultSummaryImpl(writeExceptionEntry);
            }
            catch (IOException e) {
                ClusterRuntimeTestEntry deleteExceptionEntry = new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_DELETING_FILE_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_DELETING_FILE_MESSAGE, new String[]{qualifiedPath.getName(), qualifiedPath.getPath()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY);
                if (writeExceptionEntry == null) {
                    return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)deleteExceptionEntry);
                }
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_DELETING_FILE_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_WRITING_DELETING_FILE_MESSAGE, new String[0]), ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY), Arrays.asList(new RuntimeTestResultEntry[]{writeExceptionEntry, deleteExceptionEntry}));
            }
        }
        catch (ClusterInitializationException e) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_INITIALIZING_CLUSTER_DESC, new String[0]), this.messageGetter.getMessage(WRITE_TO_AND_DELETE_FROM_USERS_HOME_FOLDER_TEST_ERROR_INITIALIZING_CLUSTER_MESSAGE, new String[]{namedCluster.getName()}), e, ClusterRuntimeTestEntry.DocAnchor.ACCESS_DIRECTORY));
        }
    }
}

