/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;

public class Constants {
    public static final String PENTAHO_CACHE_PROVIDER = "pentaho.cache.provider";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String DEFAULT_TEMPLATE_DESCRIPTION = "Default Cache Template";
    public static final String CONFIG_TTL = "ttl";
    public static final String CONFIG_TTL_RESET = "ttl.resetOn";
    public static final ExpiryFunction CONFIG_TTL_RESET_DEFAULT = ExpiryFunction.TOUCH;
    public static final String CONFIG_STORE_BY_VALUE = "storeByValue";

    public static Map<String, String> convertDictionary(Dictionary<String, ?> dictionary) {
        HashMap properties = Maps.newHashMapWithExpectedSize((int)dictionary.size());
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            properties.put(key, String.valueOf(dictionary.get(key)));
        }
        return properties;
    }

    public static <T> T unwrap(Object object, Class<T> clazz) {
        Preconditions.checkArgument((boolean)clazz.isInstance(object), (String)"%s cannot be cast to %s", (Object[])new Object[]{object, clazz});
        return clazz.cast(object);
    }

    public static enum ExpiryFunction {
        CREATE{

            @Override
            public Factory<? extends ExpiryPolicy> createFactory(Long seconds) {
                return CreatedExpiryPolicy.factoryOf((Duration)ExpiryFunction.getDuration(seconds));
            }
        }
        ,
        MODIFY{

            @Override
            public Factory<? extends ExpiryPolicy> createFactory(Long seconds) {
                return ModifiedExpiryPolicy.factoryOf((Duration)ExpiryFunction.getDuration(seconds));
            }
        }
        ,
        ACCESS{

            @Override
            public Factory<? extends ExpiryPolicy> createFactory(Long seconds) {
                return AccessedExpiryPolicy.factoryOf((Duration)ExpiryFunction.getDuration(seconds));
            }
        }
        ,
        TOUCH{

            @Override
            public Factory<? extends ExpiryPolicy> createFactory(Long seconds) {
                return TouchedExpiryPolicy.factoryOf((Duration)ExpiryFunction.getDuration(seconds));
            }
        };


        private static Duration getDuration(Long seconds) {
            return new Duration(TimeUnit.SECONDS, seconds.longValue());
        }

        public Factory<? extends ExpiryPolicy> createFactory(Long seconds) {
            return EternalExpiryPolicy.factoryOf();
        }
    }
}

