/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class WorkflowNotificationXCommand
extends WorkflowXCommand<Void> {
    public static final String NOTIFICATION_URL_CONNECTION_TIMEOUT_KEY = "oozie.notification.url.connection.timeout";
    private static final String STATUS_PATTERN = "\\$status";
    private static final String JOB_ID_PATTERN = "\\$jobId";
    private static final String NODE_NAME_PATTERN = "\\$nodeName";
    private String url;
    private String id;
    int retries = 0;

    public WorkflowNotificationXCommand(WorkflowJobBean workflow) {
        super("job.notification", "job.notification", 0);
        ParamChecker.notNull(workflow, "workflow");
        this.id = workflow.getId();
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.workflow.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(STATUS_PATTERN, workflow.getStatus().toString());
        }
    }

    public WorkflowNotificationXCommand(WorkflowJobBean workflow, WorkflowActionBean action) {
        super("action.notification", "job.notification", 0);
        ParamChecker.notNull(workflow, "workflow");
        ParamChecker.notNull(action, "action");
        this.id = action.getId();
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.action.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(NODE_NAME_PATTERN, action.getName());
            this.url = action.isComplete() ? this.url.replaceAll(STATUS_PATTERN, "T:" + action.getTransition()) : this.url.replaceAll(STATUS_PATTERN, "S:" + action.getStatus().toString());
        }
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.id);
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return this.url;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected Void execute() throws CommandException {
        if (this.url != null) {
            int timeout = ConfigurationService.getInt(NOTIFICATION_URL_CONNECTION_TIMEOUT_KEY);
            try {
                URL url = new URL(this.url);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setConnectTimeout(timeout);
                urlConn.setReadTimeout(timeout);
                if (urlConn.getResponseCode() != 200) {
                    this.handleRetry();
                }
            }
            catch (IOException ex) {
                this.handleRetry();
            }
        }
        return null;
    }

    private void handleRetry() {
        if (this.retries < 3) {
            ++this.retries;
            this.resetUsed();
            this.queue(this, 60000L);
        } else {
            this.LOG.warn(4, "could not send notification [{0}]", this.url);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

