/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforcedelete;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepMeta;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDelete;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDeleteData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="SalesforceDelete", i18nPackageName="org.pentaho.di.trans.steps.salesforcedelete", name="SalesforceDelete.TypeLongDesc.SalesforceDelete", description="SalesforceDelete.TypeTooltipDesc.SalesforceDelete", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Output", image="SFD.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Salesforce+Delete")
public class SalesforceDeleteMeta
extends SalesforceStepMeta {
    private static Class<?> PKG = SalesforceDeleteMeta.class;
    private String module;
    private String DeleteField;
    private String batchSize;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public void setModule(String module) {
        this.module = module;
    }

    public void setDeleteField(String DeleteField) {
        this.DeleteField = DeleteField;
    }

    public String getDeleteField() {
        return this.DeleteField;
    }

    public void setBatchSize(String value) {
        this.batchSize = value;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(stepnode, databases, metaStore);
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceDeleteMeta retval = (SalesforceDeleteMeta)((Object)super.clone());
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(super.getXML());
        retval.append("    " + XMLHandler.addTagValue((String)"DeleteField", (String)this.getDeleteField()));
        retval.append("    " + XMLHandler.addTagValue((String)"batchSize", (String)this.getBatchSize()));
        retval.append("    " + XMLHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.isRollbackAllChangesOnError()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.setModule(XMLHandler.getTagValue((Node)stepnode, (String)"module"));
            this.setDeleteField(XMLHandler.getTagValue((Node)stepnode, (String)"DeleteField"));
            this.setBatchSize(XMLHandler.getTagValue((Node)stepnode, (String)"batchSize"));
            this.setRollbackAllChangesOnError("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rollbackAllChangesOnError")));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setModule("Account");
        this.setDeleteField(null);
        this.setBatchSize("10");
        this.setRollbackAllChangesOnError(false);
    }

    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        super.readRep(rep, metaStore, id_step, databases);
        try {
            this.setModule(rep.getStepAttributeString(id_step, "module"));
            this.setDeleteField(rep.getStepAttributeString(id_step, "DeleteField"));
            this.setBatchSize(rep.getStepAttributeString(id_step, "batchSize"));
            this.setRollbackAllChangesOnError(rep.getStepAttributeBoolean(id_step, "rollbackAllChangesOnError"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        super.saveRep(rep, metaStore, id_transformation, id_step);
        try {
            rep.saveStepAttribute(id_transformation, id_step, "batchSize", this.getBatchSize());
            rep.saveStepAttribute(id_transformation, id_step, "module", this.getModule());
            rep.saveStepAttribute(id_transformation, id_step, "DeleteField", this.getDeleteField());
            rep.saveStepAttribute(id_transformation, id_step, "rollbackAllChangesOnError", this.isRollbackAllChangesOnError());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceDelete(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new SalesforceDeleteData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

