/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.RuntimeTestProgressCallback;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.impl.RuntimeTestComparator;
import org.pentaho.runtime.test.impl.RuntimeTestRunner;

public class RuntimeTesterImpl
implements RuntimeTester {
    private final List<RuntimeTest> runtimeTests;
    private final ExecutorService executorService;
    private final RuntimeTestRunner.Factory runtimeTestRunnerFactory;
    private RuntimeTestComparator runtimeTestComparator;

    public RuntimeTesterImpl(List<RuntimeTest> runtimeTests, ExecutorService executorService, String orderedModulesString) {
        this(runtimeTests, executorService, orderedModulesString, new RuntimeTestRunner.Factory());
    }

    public RuntimeTesterImpl(List<RuntimeTest> runtimeTests, ExecutorService executorService, String orderedModulesString, RuntimeTestRunner.Factory runtimeTestRunnerFactory) {
        this.runtimeTests = runtimeTests;
        this.executorService = executorService;
        this.runtimeTestRunnerFactory = runtimeTestRunnerFactory;
        HashMap<String, Integer> orderedModules = new HashMap<String, Integer>();
        String[] split = orderedModulesString.split(",");
        for (int module = 0; module < split.length; ++module) {
            orderedModules.put(split[module].trim(), module);
        }
        this.runtimeTestComparator = new RuntimeTestComparator(orderedModules);
    }

    @Override
    public void runtimeTest(final Object objectUnderTest, final RuntimeTestProgressCallback runtimeTestProgressCallback) {
        final ArrayList<RuntimeTest> runtimeTests = new ArrayList<RuntimeTest>(this.runtimeTests);
        Collections.sort(runtimeTests, this.runtimeTestComparator);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                RuntimeTesterImpl.this.runtimeTestRunnerFactory.create(runtimeTests, objectUnderTest, runtimeTestProgressCallback, RuntimeTesterImpl.this.executorService).runTests();
            }
        });
    }
}

