/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle;

import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.messages.Messages;

public abstract class BaseDocumentAnalyzer
extends BaseKettleMetaverseComponent
implements IDocumentAnalyzer<IMetaverseNode> {
    protected void validateState(IDocument document) throws MetaverseAnalyzerException {
        if (document == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.Document.IsNull"));
        }
        Object repoObject = document.getContent();
        if (repoObject == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.Document.HasNoContent"));
        }
        if (this.metaverseObjectFactory == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseObjectFactory.IsNull"));
        }
        if (this.metaverseBuilder == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseBuilder.IsNull"));
        }
    }

    public void addParentLink(IComponentDescriptor descriptor, IMetaverseNode child) throws MetaverseAnalyzerException {
        IMetaverseNode locatorNode = this.metaverseObjectFactory.createNodeObject(descriptor.getStringID());
        this.metaverseBuilder.addLink(locatorNode, "contains", child);
    }
}

