/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.pentaho.di.trans.Trans;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.JobLineageHolderMap;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.util.MetaverseBeanUtil;

public class TransLineageHolderMap {
    private static TransLineageHolderMap INSTANCE = new TransLineageHolderMap();
    private Map<Trans, LineageHolder> lineageHolderMap = new MapMaker().weakKeys().makeMap();
    private IMetaverseBuilder defaultMetaverseBuilder;

    private TransLineageHolderMap() {
    }

    public static TransLineageHolderMap getInstance() {
        return INSTANCE;
    }

    protected static void setInstance(TransLineageHolderMap instance) {
        INSTANCE = instance;
    }

    public LineageHolder getLineageHolder(Trans t) {
        LineageHolder holder = this.lineageHolderMap.get(t);
        if (holder == null) {
            holder = new LineageHolder();
            this.putLineageHolder(t, holder);
        }
        return holder;
    }

    public void putLineageHolder(Trans t, LineageHolder holder) {
        this.lineageHolderMap.put(t, holder);
    }

    public IMetaverseBuilder getMetaverseBuilder(Trans trans) {
        if (trans != null) {
            if (trans.getParentJob() == null && trans.getParentTrans() == null) {
                IMetaverseBuilder builder = this.getLineageHolder(trans).getMetaverseBuilder();
                if (builder == null) {
                    return this.getDefaultMetaverseBuilder();
                }
                return builder;
            }
            if (trans.getParentJob() != null) {
                return JobLineageHolderMap.getInstance().getMetaverseBuilder(trans.getParentJob());
            }
            return this.getMetaverseBuilder(trans.getParentTrans());
        }
        return null;
    }

    protected IMetaverseBuilder getDefaultMetaverseBuilder() {
        IMetaverseBuilder newBuilder = (IMetaverseBuilder)MetaverseBeanUtil.getInstance().get("IMetaverseBuilderPrototype");
        if (newBuilder == null) {
            return this.defaultMetaverseBuilder;
        }
        return newBuilder;
    }

    protected void setDefaultMetaverseBuilder(IMetaverseBuilder builder) {
        this.defaultMetaverseBuilder = builder;
    }
}

