/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;

public class StepAnalyzerProvider
extends BaseKettleMetaverseComponent
implements IStepAnalyzerProvider {
    protected List<IStepAnalyzer> stepAnalyzers = new ArrayList<IStepAnalyzer>();
    protected Map<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>> analyzerTypeMap = new HashMap<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>>();

    public List<IStepAnalyzer> getAnalyzers() {
        return this.stepAnalyzers;
    }

    public List<IStepAnalyzer> getAnalyzers(Collection<Class<?>> types) {
        List<IStepAnalyzer> stepAnalyzers = this.getAnalyzers();
        if (types != null) {
            HashSet specificStepAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.analyzerTypeMap.containsKey(clazz)) continue;
                specificStepAnalyzers.addAll(this.analyzerTypeMap.get(clazz));
            }
            stepAnalyzers = new ArrayList<IStepAnalyzer>(specificStepAnalyzers);
        }
        return stepAnalyzers;
    }

    public void setStepAnalyzers(List<IStepAnalyzer> analyzers) {
        this.stepAnalyzers = analyzers;
        this.loadAnalyzerTypeMap();
    }

    protected void loadAnalyzerTypeMap() {
        this.analyzerTypeMap = new HashMap<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>>();
        if (this.stepAnalyzers != null) {
            for (IStepAnalyzer analyzer : this.stepAnalyzers) {
                this.addAnalyzer(analyzer);
            }
        }
    }

    public void addAnalyzer(IStepAnalyzer analyzer) {
        if (analyzer != null) {
            if (!this.stepAnalyzers.contains(analyzer)) {
                this.stepAnalyzers.add(analyzer);
            }
            Set types = analyzer.getSupportedSteps();
            analyzer.setMetaverseBuilder(this.metaverseBuilder);
            if (types != null) {
                for (Class type : types) {
                    Set<IStepAnalyzer> analyzerSet = this.analyzerTypeMap.containsKey(type) ? this.analyzerTypeMap.get(type) : new HashSet<IStepAnalyzer>();
                    analyzerSet.add(analyzer);
                    this.analyzerTypeMap.put(type, analyzerSet);
                }
            }
        }
    }

    public void removeAnalyzer(IStepAnalyzer analyzer) {
        if (analyzer != null) {
            Set types;
            if (this.stepAnalyzers != null && this.stepAnalyzers.contains(analyzer)) {
                try {
                    this.stepAnalyzers.remove(analyzer);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if ((types = analyzer.getSupportedSteps()) != null) {
                for (Class type : types) {
                    if (!this.analyzerTypeMap.containsKey(type)) continue;
                    Set<IStepAnalyzer> analyzerSet = this.analyzerTypeMap.get(type);
                    analyzerSet.remove(analyzer);
                    if (analyzerSet.size() != 0) continue;
                    this.analyzerTypeMap.remove(type);
                }
            }
        }
    }
}

