/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.selectvalues;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectValuesStepAnalyzer
extends StepAnalyzer<SelectValuesMeta> {
    private static final Logger log = LoggerFactory.getLogger(SelectValuesStepAnalyzer.class);
    protected static final int NOT_CHANGED = -2;

    protected void customAnalyze(SelectValuesMeta meta, IMetaverseNode rootNode) {
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        if (ArrayUtils.isEmpty((Object[])((SelectValuesMeta)this.baseStepMeta).getSelectName())) {
            SelectMetadataChange[] changes = ((SelectValuesMeta)this.baseStepMeta).getMeta();
            boolean isOnMetaTab = false;
            for (int i = 0; i < changes.length; ++i) {
                SelectMetadataChange change = changes[i];
                if (!originalFieldName.getFieldName().equals(change.getName())) continue;
                isOnMetaTab = true;
                break;
            }
            boolean isDeleted = ArrayUtils.contains((Object[])((SelectValuesMeta)this.baseStepMeta).getDeleteName(), (Object)originalFieldName.getFieldName());
            return !isOnMetaTab && !isDeleted;
        }
        return false;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(SelectValuesMeta selectValuesMeta) throws MetaverseAnalyzerException {
        ComponentDerivationRecord changeRecord;
        String outputFieldName;
        String inputFieldName;
        this.validateState(null, (BaseStepMeta)selectValuesMeta);
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        if (!Const.isEmpty((String[])selectValuesMeta.getSelectName())) {
            String[] fieldNames = selectValuesMeta.getSelectName();
            String[] fieldRenames = selectValuesMeta.getSelectRename();
            int[] fieldLength = selectValuesMeta.getSelectLength();
            int[] fieldPrecision = selectValuesMeta.getSelectPrecision();
            for (int i = 0; i < fieldNames.length; ++i) {
                inputFieldName = fieldNames[i];
                outputFieldName = fieldRenames[i];
                changeRecord = new ComponentDerivationRecord(inputFieldName, outputFieldName == null ? inputFieldName : outputFieldName, ChangeType.METADATA);
                HashSet<String> metadataChangedFields = new HashSet<String>();
                if (inputFieldName != null && outputFieldName != null && !inputFieldName.equals(outputFieldName)) {
                    metadataChangedFields.add("name");
                }
                if (fieldLength != null && fieldLength[i] != -2) {
                    metadataChangedFields.add("length");
                }
                if (fieldPrecision != null && fieldPrecision[i] != -2) {
                    metadataChangedFields.add("precision");
                }
                if (!metadataChangedFields.isEmpty()) {
                    changeRecord.addOperation(new Operation("modified", StringUtils.join(metadataChangedFields, (String)",")));
                }
                changeRecords.add(changeRecord);
            }
        }
        if (!Const.isEmpty((Object[])selectValuesMeta.getMeta())) {
            String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
            SelectMetadataChange[] metadataChanges = selectValuesMeta.getMeta();
            if (metadataChanges != null) {
                for (SelectMetadataChange metadataChange : metadataChanges) {
                    inputFieldName = metadataChange.getName();
                    outputFieldName = metadataChange.getRename();
                    changeRecord = new ComponentDerivationRecord(inputFieldName, outputFieldName == null ? inputFieldName : outputFieldName, ChangeType.METADATA);
                    HashSet<String> metadataChangedFields = new HashSet<String>();
                    if (inputFieldName != null && outputFieldName != null && !inputFieldName.equalsIgnoreCase(outputFieldName)) {
                        metadataChangedFields.add("name");
                    }
                    if (this.prevFields == null) {
                        this.prevFields = this.getInputFields((BaseStepMeta)selectValuesMeta);
                        if (this.prevFields == null) {
                            log.warn(Messages.getString("WARNING.CannotDetermineFieldType", inputFieldName));
                            continue;
                        }
                    }
                    RowMetaInterface rowMetaInterface = (RowMetaInterface)this.prevFields.get(prevStepNames[0]);
                    ValueMetaInterface inputFieldValueMeta = null;
                    if (rowMetaInterface == null) {
                        log.warn(Messages.getString("WARNING.CannotDetermineFieldType", inputFieldName));
                        continue;
                    }
                    inputFieldValueMeta = rowMetaInterface.searchValueMeta(inputFieldName);
                    if (inputFieldValueMeta == null) {
                        log.warn(Messages.getString("WARNING.CannotDetermineFieldType", inputFieldName));
                        continue;
                    }
                    if (inputFieldValueMeta.getType() != metadataChange.getType()) {
                        metadataChangedFields.add("type");
                    }
                    if (metadataChange.getLength() != -2) {
                        metadataChangedFields.add("length");
                    }
                    if (metadataChange.getPrecision() != -2) {
                        metadataChangedFields.add("precision");
                    }
                    if (metadataChange.getStorageType() != -1 && inputFieldValueMeta.getStorageType() != metadataChange.getStorageType()) {
                        metadataChangedFields.add("storagetype");
                    }
                    if (!(metadataChange.getConversionMask() == null || inputFieldValueMeta.getConversionMask() != null && inputFieldValueMeta.getConversionMask().equals(metadataChange.getConversionMask()))) {
                        metadataChangedFields.add("conversionmask");
                    }
                    if (inputFieldValueMeta.isDateFormatLenient() != metadataChange.isDateFormatLenient()) {
                        metadataChangedFields.add("dateformatlenient");
                    }
                    if (!(metadataChange.getDateFormatLocale() == null || inputFieldValueMeta.getDateFormatLocale() != null && inputFieldValueMeta.getDateFormatLocale().toString().equals(metadataChange.getDateFormatLocale()))) {
                        metadataChangedFields.add("datelocale");
                    }
                    if (!(metadataChange.getDateFormatTimeZone() == null || inputFieldValueMeta.getDateFormatTimeZone() != null && inputFieldValueMeta.getDateFormatTimeZone().toString().equals(metadataChange.getDateFormatTimeZone()))) {
                        metadataChangedFields.add("datetimezone");
                    }
                    if (inputFieldValueMeta.isLenientStringToNumber() != metadataChange.isLenientStringToNumber()) {
                        metadataChangedFields.add("lenientnumberconversion");
                    }
                    if (!(metadataChange.getDateFormatTimeZone() == null || inputFieldValueMeta.getStringEncoding() != null && inputFieldValueMeta.getStringEncoding().equals(metadataChange.getDateFormatTimeZone()))) {
                        metadataChangedFields.add("encoding");
                    }
                    if (!(metadataChange.getDecimalSymbol() == null || inputFieldValueMeta.getDecimalSymbol() != null && inputFieldValueMeta.getDecimalSymbol().equals(metadataChange.getDecimalSymbol()))) {
                        metadataChangedFields.add("decimalsymbol");
                    }
                    if (!(metadataChange.getGroupingSymbol() == null || inputFieldValueMeta.getGroupingSymbol() != null && inputFieldValueMeta.getGroupingSymbol().equals(metadataChange.getGroupingSymbol()))) {
                        metadataChangedFields.add("groupsymbol");
                    }
                    if (!(metadataChange.getCurrencySymbol() == null || inputFieldValueMeta.getCurrencySymbol() != null && inputFieldValueMeta.getCurrencySymbol().equals(metadataChange.getCurrencySymbol()))) {
                        metadataChangedFields.add("currencysymbol");
                    }
                    if (!metadataChangedFields.isEmpty()) {
                        changeRecord.addOperation(new Operation("modified", StringUtils.join(metadataChangedFields, (String)",")));
                    }
                    changeRecords.add(changeRecord);
                }
            }
        }
        return changeRecords;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supported = new HashSet<Class<? extends BaseStepMeta>>();
        supported.add(SelectValuesMeta.class);
        return supported;
    }

    protected Set<StepField> getUsedFields(SelectValuesMeta meta) {
        SelectMetadataChange[] selectMetadataChanges;
        String[] fieldNames;
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (String fieldName : fieldNames = meta.getSelectName()) {
            usedFields.addAll(this.createStepFields(fieldName, this.getInputs()));
        }
        for (SelectMetadataChange selectMetadataChange : selectMetadataChanges = meta.getMeta()) {
            usedFields.addAll(this.createStepFields(selectMetadataChange.getName(), this.getInputs()));
        }
        return usedFields;
    }

    protected void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    protected void setBaseStepMeta(SelectValuesMeta meta) {
        this.baseStepMeta = meta;
    }
}

